// Copyright (c) 1994, William Wagner
// All Rights reserved.
//
// This source is a portion of a shareware program.  It may be distributed
// only in its entirety.  The copyright statements must be included with any 
// reproduction of this source.
// 
// mainfrm.h : interface of the CMainFrame class
//
#ifndef __MAINFRM_H__
#define __MAINFRM_H__

/////////////////////////////////////////////////////////////////////////////
// The CMainFrame class is the main window.
// Its responsibilities are to be the container for all classes pertaining 
// to the tape labeler.
// This entails creating the splitter, the toolbar, and the status bar.
// That's about it.
// FormView related objects are very difficult to print.  So, I created
// a second view class.  This class is a ScrollView related class that
// allows me to print more easily.

class CMainFrame : public CFrameWnd
{
protected: // create from serialization only
	//Default constructor, from Serialization.
	CMainFrame();
	DECLARE_DYNCREATE(CMainFrame)

// Attributes
public:
	//Return pointers to the PrintView and the Tape Form View.
	CPrintView* GetPrintView ();
	CTapeView*  GetTapeView ();
	
// Implementation
public:
	//Destructor.
	virtual ~CMainFrame();

#ifdef _DEBUG
	virtual	void AssertValid() const;
	virtual	void Dump(CDumpContext& dc) const;
#endif

protected:	// control bar embedded members
	//This main frame has a status bar, a tool bar, and a splitter.
	CStatusBar		m_wndStatusBar;
	CToolBar		m_wndToolBar;
	CSplitterWnd	m_wndSplitter;
	
// Generated message map functions
	//This class overrides the Create, Create Client functions to 
	// create the splitter window.  
	// It also handles the print related command.  This is to handle
	// setting the active view correctly.  The Print View must be 
	// the active view when the print code is called.  FormViews
	// just don't cope.  These only take control when the Print View
	// is not active.
protected:
	//{{AFX_MSG(CMainFrame)
	afx_msg int OnCreate(LPCREATESTRUCT lpCreateStruct);
	afx_msg BOOL OnCreateClient ( LPCREATESTRUCT lpCreateStruct, CCreateContext* pContext);
	afx_msg void OnFilePrintPreview();
	afx_msg void OnFilePrint();
	//}}AFX_MSG
	DECLARE_MESSAGE_MAP()
};

/////////////////////////////////////////////////////////////////////////////
#endif
