// Copyright (c) 1994, William Wagner.
// All Rights reserved.
//
// This source is a portion of a shareware program.  It may be distributed
// only in its entirety.  The copyright statements must be included with any 
// reproduction of this source.
// 
// mainfrm.cpp : implementation of the CMainFrame class
//

#include "stdafx.h"
#include "cassette.h"

#include "mainfrm.h"
#include "printvie.h"
#include "tapeview.h"

#ifdef _DEBUG
#undef THIS_FILE
static char BASED_CODE THIS_FILE[] = __FILE__;
#endif

//Constants used for sizes of the views
static const int DLG_X = 4;
static const int DLG_Y = 8;

static const int VIEW_X = 130;
static const int VIEW_Y = 480;

/////////////////////////////////////////////////////////////////////////////
// CMainFrame

IMPLEMENT_DYNCREATE(CMainFrame, CFrameWnd)

BEGIN_MESSAGE_MAP(CMainFrame, CFrameWnd)
	//{{AFX_MSG_MAP(CMainFrame)
	ON_WM_CREATE()
	ON_COMMAND(ID_FILE_PRINT_PREVIEW, OnFilePrintPreview)
	ON_COMMAND(ID_FILE_PRINT, OnFilePrint)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// arrays of IDs used to initialize control bars

// toolbar buttons - IDs are command buttons
// I double the separators.  I think it looks better.
static UINT BASED_CODE buttons[] =
{
	// same order as in the bitmap 'toolbar.bmp'
	ID_FILE_NEW,
	ID_FILE_OPEN,
	ID_FILE_SAVE,
		ID_SEPARATOR,
		ID_SEPARATOR,
	ID_FILE_PRINT,
		ID_SEPARATOR,
		ID_SEPARATOR,
	ID_APP_ABOUT,
	ID_CONTEXT_HELP,
};

static UINT BASED_CODE indicators[] =
{
	ID_SEPARATOR,			// status line indicator
	ID_INDICATOR_CAPS,
	ID_INDICATOR_NUM,
	ID_INDICATOR_SCRL,
};

/////////////////////////////////////////////////////////////////////////////
// CMainFrame construction/destruction

// Constructor.
// This is an empty constructor.  Not much happens in the construction
// of this class.  
//
// I am purposefully trying to keep this a very small class.  I may
// change this to an MDI application.  Therefore, I am trying to keep as
// little as possible here.
// Dont call ASSERT_VALID because the splitter is not yet all there.
CMainFrame::CMainFrame()
{
}

// Destructor.
// This too is empty.  It needs to exist because of base classes that 
// have virtual destructors.
CMainFrame::~CMainFrame()
{
ASSERT_VALID (this);
}

// This function is called during the processing of the WM_CREATE
// message.  Its function is to creates the non-client area controls.
// Those are the toolbar and the status bar.  
// Those controls cannot be created during the constructor, because the
// window resource has not been created.  This overrides the base class
// implementation, which must be called from this function.
// Dont call ASSERT_VALID because the splitter is not yet all there.
int CMainFrame::OnCreate(LPCREATESTRUCT lpCreateStruct)
{
int retval;

if (-1 == CFrameWnd::OnCreate(lpCreateStruct))
	retval = -1;
else if (!m_wndToolBar.Create(this) ||
	!m_wndToolBar.LoadBitmap(IDR_MAINFRAME) ||
	!m_wndToolBar.SetButtons(buttons,
	sizeof(buttons)/sizeof(UINT)))
	{
	TRACE("Failed to create toolbar\n");
	retval = -1;
	}
else if (!m_wndStatusBar.Create(this) ||
	!m_wndStatusBar.SetIndicators(indicators,
	sizeof(indicators)/sizeof(UINT)))
	{
	TRACE("Failed to create status bar\n");
	retval = -1;
	}
else
	retval = 0;

ASSERT (0 == retval);

return retval;
}

// This function is called during the creation of the client window.  The default
// implementaion creates a single view class client window.  This application needs
// more extensive services.  Therefore, it creates the splitter window, and creates
// the two views that make up the splitter window views.
// Dont call ASSERT_VALID until the end because the splitter is not yet all there.
BOOL CMainFrame::OnCreateClient ( LPCREATESTRUCT /* lpCreateStruct */, CCreateContext* pContext)
{
BOOL retval;
DWORD dlgUnit = GetDialogBaseUnits ();
CSize ViewSize ((VIEW_X* LOWORD (dlgUnit)) / DLG_X, (VIEW_Y * HIWORD (dlgUnit)) / DLG_Y);

if (!m_wndSplitter.CreateStatic (this, 1, 2))
	retval = FALSE;
else if (!m_wndSplitter.CreateView (0,0, RUNTIME_CLASS (CTapeView), ViewSize, pContext))
	retval = FALSE;
else if (!m_wndSplitter.CreateView (0,1, RUNTIME_CLASS (CPrintView), ViewSize, pContext))
	retval =  FALSE;
else
	retval = TRUE;
	
ASSERT (TRUE == retval);
ASSERT_VALID (this);

return retval;
}

// This utility function returns a pointer to the print view.  
// The print view is the right pane: row 0, column 1.  
// This function returns the pointer to the correct view.
CPrintView* CMainFrame::GetPrintView ()
{
ASSERT_VALID (this);
ASSERT (2 == m_wndSplitter.GetColumnCount ());
ASSERT (1 == m_wndSplitter.GetRowCount ());

CWnd* pPrintView = m_wndSplitter.GetPane (0,1);

ASSERT_VALID (pPrintView);
ASSERT(pPrintView->IsKindOf(RUNTIME_CLASS(CPrintView)));

return (CPrintView*) pPrintView;
}

// This utility function returns a pointer to the tape form view.  
// The tape form view is the left pane: row 0, column 0.  
// This function returns the pointer to the correct view.
CTapeView* CMainFrame::GetTapeView ()
{
ASSERT_VALID (this);
ASSERT (2 == m_wndSplitter.GetColumnCount ());
ASSERT (1 == m_wndSplitter.GetRowCount ());

CWnd* pTapeView = m_wndSplitter.GetPane (0,0);

ASSERT_VALID (pTapeView);
ASSERT(pTapeView->IsKindOf(RUNTIME_CLASS(CTapeView)));

return (CTapeView*) pTapeView;
}

/////////////////////////////////////////////////////////////////////////////
// CMainFrame diagnostics

#ifdef _DEBUG
// Validation routine.
// This tests the validity of the main frame object. The member objects
// are validated.  However, objects pointed to are not validated.  
void CMainFrame::AssertValid() const
{
CFrameWnd::AssertValid();
m_wndSplitter.AssertValid ();
m_wndToolBar.AssertValid ();
m_wndStatusBar.AssertValid ();
}

void CMainFrame::Dump(CDumpContext& dc) const
{
CFrameWnd::Dump(dc);
m_wndSplitter.Dump (dc);
m_wndToolBar.Dump (dc);
m_wndStatusBar.Dump (dc);
}
#endif //_DEBUG

/////////////////////////////////////////////////////////////////////////////
// CMainFrame message handlers

// You will note that these two functions look almost exactly the same.
// This is by design.  The CFormView classes do not cope well (or at all)
// with the print and print preview functions.  So...
// if these to commands get here, we secretly switch the active view to
// the print view.  Then call its command handler.  Finally, restore the 
// active view back.
// The debug version checks that the tape view was active.  (this avoids
// any infinite loops.)
void CMainFrame::OnFilePrintPreview()
{
ASSERT_VALID (this);

CView* pOldView = GetActiveView ();
ASSERT(pOldView->IsKindOf(RUNTIME_CLASS(CTapeView)));

SetActiveView (GetPrintView ());
GetPrintView ()->OnFilePrintPreview ();
SetActiveView (pOldView);

ASSERT_VALID (this);
}

// See OnFilePrintPreview (up about 10 lines).
void CMainFrame::OnFilePrint()
{
ASSERT_VALID (this);

CView* pOldView = GetActiveView ();
ASSERT(pOldView->IsKindOf(RUNTIME_CLASS(CTapeView)));

SetActiveView (GetPrintView ());
GetPrintView ()->OnFilePrint ();
SetActiveView (pOldView);

ASSERT_VALID (this);
}
