// Copyright (c) 1994, William Wagner
// All Rights reserved.
//
// This source is a portion of a shareware program.  It may be distributed
// only in its entirety.  The copyright statements must be included with any 
// reproduction of this source.
// 

#ifndef __CASSEDOC_H__
#define __CASSEDOC_H__

// cassedoc.h : interface of the CCassetteDoc class
//
// CCassetteDoc is the class that handles a cassette document.  This class
// holds the data that represents a cassette label J-Card.
//
/////////////////////////////////////////////////////////////////////////////

// Defined constants for Updates:
// These constants are passed to the View classes in an OnUpdate method.
// Each defines what has changed.

// 100 - series:  Data has changed.
//The name of the constants should be clear.  The fields are 
// side one album, side two album, side one artist, side two artist,
// side one songs, side two songs, notes.
#define ALBUM1_CHANGE		100
#define ALBUM2_CHANGE		101
#define ARTIST1_CHANGE		102
#define ARTIST2_CHANGE		103
#define SONGS1_CHANGE		104
#define SONGS2_CHANGE		105
#define NOTES_CHANGE		106

// 200 - series:  Font information changed.
//The name should be clear.  The fields are album font,
// artist font, songs font, notes font.
#define FONT_ALBUM_CHANGE	200
#define FONT_ARTIST_CHANGE	201
#define FONT_SONGS_CHANGE	202
#define FONT_NOTES_CHANGE	203

class CCassetteDoc : public CDocument
{
protected: // create from serialization only
	CCassetteDoc();
	DECLARE_DYNCREATE(CCassetteDoc)

//Attributes
public:
	//These are the data members for a document.
	
	// Document version.  This is used to tag files so that future
	// versions of this program can read and translate old data files.
	LONG	m_lVersion;
	
	//Data members for the class.  These strings represent the 
	// data for the cassette label.  Some of the strings may get
	// very large.  (The Songs* variables contain CR/LF pairs and 
	// contain the entire set of songs.  The cs is my Hungarian
	// prefix for a CString.
	CString	m_csAlbum1;		//Album, side 1.
	CString	m_csAlbum2;		//Album, side 2.
	CString	m_csArtist1;	//Artist, side 1.
	CString	m_csArtist2;	//Artist, side 2.
	CString	m_csSongs1;		//Songs, side 1.
	CString	m_csSongs2;		//Songs, side 2.
	CString	m_csNotes;		//Notes along the bottom.

	// Logical fonts used in the casssette program.
	// Logical fonts are used because I can serialize them.  That
	// way, the font information stored is properly reloaded
	// again.  I use lfont for the Hungarian prefix.
	// Different fonts are used for songs, artist, album, and notes.
	LOGFONT m_lfontSongs;
	LOGFONT m_lfontArtist;
	LOGFONT m_lfontAlbum;
	LOGFONT m_lfontNotes;

//Operations
public:
	//This function changes one of the fonts in the document.  The WhichFont
	// parameter matches one of the 200-series constants used in the OnUpdate
	// method.  This gives the user the CommonFont dialog to change any of 
	// the fonts desired.  The font change commands are handled here becauase
	// that way, it doesn't matter which view is active, it just works.
	void DoFontCommand (int WhichFont);
	
// Implementation
private:
	//Initialize a logical font.  This initializes a logical font
	// to 8 pt. MS San Serif.
	void InitFont (LOGFONT* Font);
	
	//utility functions to read and write documents:
	void ReadDocument (CArchive& ar);
	void WriteDocument (CArchive& ar);
	void ReadFont (CArchive& ar, LOGFONT* font);
	void WriteFont (CArchive& ar, LOGFONT* font);
		
	//Change a font.  This utility function loads the CommDlg
	// font dialog, and lets the user change the font.  The return
	// value is return from the font dialos's DoModal () member
	// either IDOK, or IDCANCEL.
	int  ChangeFont (LOGFONT* Font);
	
public:

	//Emtpy a document.  However, this does not re-initialize the
	// font information.  I was sort of figuring that users would
	// want the font information sticky.  So, they can set the
	// fonts they want and then just tweak them.
	void DeleteContents ();
	
	//Destructor.
	~CCassetteDoc();
	
	//Serialization handler.
	void Serialize(CArchive& ar);	// overridden for document i/o
#ifdef _DEBUG
	void AssertValid() const;
	void Dump(CDumpContext& dc) const;
#endif

// Generated message map functions
// The document class updates the Save command to only allow it 
// on a changed document.  All font commands are handled by the
// document class.
protected:
	//{{AFX_MSG(CCassetteDoc)
	afx_msg void OnUpdateFileSave(CCmdUI* pCmdUI);
	afx_msg void OnFontsAlbum();
	afx_msg void OnFontsArtist();
	afx_msg void OnFontsNotes();
	afx_msg void OnFontsSongs();
	//}}AFX_MSG
	DECLARE_MESSAGE_MAP()
};

/////////////////////////////////////////////////////////////////////////////
#endif
