#include "stack.h"

#define THIS    Stack
#define BASE    SeqCltn
DEFINE_CLASS(Stack,SeqCltn);

Object* Stack::add(const Object& ob)    { return contents.add(ob); }

Collection& Stack::addContentsTo(Collection& cltn) const
{
    return contents.addContentsTo(cltn);
}

Object*& Stack::at(int i) const       { return contents.at(size()-i-1); }

unsigned Stack::capacity() const  { return contents.capacity(); }

void Stack::deepenShallowCopy()
{
    BASE::deepenShallowCopy();
    contents.deepenShallowCopy();
}

unsigned Stack::hash() const     { return contents.hash(); }

bool Stack::isEmpty()  const     { return contents.size()==0; }

bool Stack::isEqual(const Object& ob) const
{
    return ob.isSpecies(class_Stack) && contents.isEqual(((Stack*)&ob)->contents);
}

const Class* Stack::species() const  { return &class_Stack; }

Object* Stack::last() const      { return contents.last(); }

void Stack::printOn(ostream& strm) const
{
    strm << className() << "[";
    for (register unsigned i=size(); i>0; i--) {
        if(i<size()) strm << "\n";
        contents.at(i-1)->printOn(strm);
    }
    strm << "]\n";
}

void Stack::reSize(unsigned newSize) { contents.reSize(newSize); }

Object* Stack::removeLast() { return contents.removeLast(); }

unsigned Stack::size() const     { return contents.size(); }
