#include "arrayob.h"
#include "queue.h"

#define THIS Queue
#define BASE Object
DEFINE_CLASS(Queue,Object);

void Queue::state() const  //diagnostic
{
    cout << "Queue capacity: " << capacity() << "\n";
    cout << "Queue size: " << size() << "\n";
    cout << "Queue *pContents: " << *pContents << "\n";
    cout << "readPosition: " << readPosition << "\n";
    cout << "writePosition: " << writePosition << "\n";
}

unsigned Queue::capacity() const
{
    return pContents->capacity();
}

void Queue::makeRoomForWrite()
{
    if (readPosition==0)
    {
        //cout << "resizing array\n"; // diagnostic
        int i = capacity();
        pContents->reSize(size()+QUEUE_EXPANSION_INCREMENT);

            // -gmv  An error will occur if you try to print
            // the *pContents array without setting all
            // newly created elements to nil.  It seems
            // this should be a responsibility of the
            // ArrayOb class.
        for(; i<capacity(); i++)
            (*pContents)[i] = (Object*)nil;
    }
    else
    {
        // move all object to beginning of array
        unsigned contentsSize = writePosition - readPosition;
        for (int i=0; i<contentsSize; i++)
        {
            (*pContents)[i] = (*pContents)[i+readPosition];
        }
        readPosition=0;
        writePosition=contentsSize;
    }
}

unsigned Queue::size() const
{
    return writePosition - readPosition;
}


void Queue::printOn(ostream& strm) const
{

    strm << className() << "[\n";
    for (int i=readPosition; i<writePosition; i++)
    {
        if (i>0) strm << "\n";
        (*pContents)[i]->printOn(strm);
    }
    strm << "]\n";
}

Queue::Queue(int sz)
{
    pContents = new ArrayOb(sz);
    readPosition = writePosition = 0;
}

Object* Queue::next()
{
    if (readPosition==writePosition)
    {
        cerr << "Error, Queue::next(): queue empty\n";
        //exit(1);
    }
#if 1
    // better debugging info
    Object *p = (*pContents)[readPosition];
    (*pContents)[readPosition++] = (Object*)nil;
    return p;
#else
    // more efficient,
    return (*pContents)[i];
#endif

}

Object* Queue::nextPut(const Object& ob)
{
    if (writePosition>=capacity())
        makeRoomForWrite();
    (*pContents)[writePosition++] = (Object*)&ob;
    return (Object*)&ob; // error ?
}

