// ***************************************************************************
//    File Name: wsleep.c
//
//    Source file for wsleep().  
//
//    Written by Yin XIE 
// COPYRIGHT:
//
//   (C) Copyright Yin XIE 1995.  All rights reserved.
//
// ***************************************************************************



#include <windows.h>
#include "wsleepdf.h"
#include "wsleep.h"

// define the global variables
extern	HINSTANCE hDLLInst;			// DLL Handle
HANDLE	hTimerList = NULL;
int		nTimers = 0;

//
//	WSleep_TimerProc
//
void __export CALLBACK WSleep_TimerProc(HWND hwnd, UINT msg, UINT idTimer, DWORD dwTime)
{
#ifdef	_DEBUG
	char	buf[64];

	wsprintf(buf, "WSleep_TimerProc : id = %d time=%d\n", idTimer, dwTime);
	OutputDebugString(buf);
#endif
	WSleep(0, idTimer);
}

//	WSleep
// id should be 0 for the user call
//
BOOL  __export FAR PASCAL WSleep(UINT duration, UINT id)
{
	int			i;
	MSG			msg;
	PSLEEPCTRL	pSleep;
	TIMERPROC	lpfnTimerProc;

#ifdef	_DEBUG
	char	buf[128];
#endif

	if (hTimerList == NULL)
	{
		hTimerList = LocalAlloc(LHND, INIT_TIMER_NB * sizeof(SLEEPCTRL));
		nTimers = 0;
	}
	if (id == 0)
	{
		pSleep = (PSLEEPCTRL) LocalLock(hTimerList);

		// find a free slot
		for (i=0; (i<INIT_TIMER_NB) && pSleep[i].idTimer; i++);
		if (i>=INIT_TIMER_NB)
		{
			LocalUnlock(hTimerList);
			return FALSE;
		}
		
		LocalUnlock(hTimerList);

		lpfnTimerProc = (TIMERPROC) MakeProcInstance((FARPROC)WSleep_TimerProc, hDLLInst);
		pSleep[i].idTimer = SetTimer(NULL, 0, duration, lpfnTimerProc);
		FreeProcInstance(lpfnTimerProc);
		if (pSleep[i].idTimer == 0)
		{
			LocalUnlock(hTimerList);
			OutputDebugString("WSleep : SetTimer failed\n");
			return FALSE;
		}
#ifdef	_DEBUG
		wsprintf(buf, "WSleep : task %x starts timer No%d (id=%d)\n", GetCurrentTask(), i, pSleep[i].idTimer);
#endif
		LocalUnlock(hTimerList);
		nTimers ++;

		// wait for time out
#ifdef	_DEBUG
		OutputDebugString(buf);
#endif

		while (GetMessage(&msg, NULL, NULL, NULL))
		{
			TranslateMessage(&msg);          // Translates virtual key codes
			DispatchMessage(&msg);           // Dispatches message to window
			pSleep = (PSLEEPCTRL) LocalLock(hTimerList);
			if (pSleep[i].expired == TRUE)
			{
				LocalUnlock(hTimerList);
				break;
			}
			LocalUnlock(hTimerList);
		}

#ifdef	_DEBUG
		wsprintf(buf, "WSleep : task %x timer No%d expired\n", GetCurrentTask(), i);
		OutputDebugString(buf);
#endif

		pSleep = (PSLEEPCTRL) LocalLock(hTimerList);

		pSleep[i].idTimer = 0;
		pSleep[i].expired = FALSE;
#ifdef	_DEBUG
		wsprintf(buf, "WSleep : task %x free timer No%d\n", GetCurrentTask(), i);
		OutputDebugString(buf);
#endif
		LocalUnlock(hTimerList);
		nTimers --;
		if (nTimers == 0)
		{
			OutputDebugString("WSleep : no more timer, free memory\n");
			LocalFree(hTimerList);
			hTimerList = NULL;
		}
	}
	else
	{
		OutputDebugString("WSleep : time out\n");
		KillTimer(NULL, id);

		pSleep = (PSLEEPCTRL) LocalLock(hTimerList);

		for (i=0;(i<INIT_TIMER_NB) && (pSleep[i].idTimer != id);i++);
		if (i>=INIT_TIMER_NB)
		{
			OutputDebugString("WSleep : Fatal Error -> sleep struct NULL\n");
			LocalUnlock(hTimerList);
			return FALSE;
		}
		pSleep[i].expired = TRUE;
#ifdef	_DEBUG
		wsprintf(buf, "WSleep : task %x get time out No%d(id=%d)\n", GetCurrentTask(), i, pSleep[i].idTimer);
#endif
		LocalUnlock(hTimerList);
#ifdef	_DEBUG
		OutputDebugString(buf);
#endif
	}
	return TRUE;
}

/* END OF FILE */
