unit Winsaver;

{
  WinSaver is a component which is designed for programmers easily save
  states of windows. You may install it by Options->Install Component->
  OK->OK. It will be automaticly installed at [system] page with
  component name as "WinSaver" . You can chage this by modify the
  procedure register; for detail reference ,  please see winsaver.wri .

  Written By Kuan-Da Chen
  Last update : 4. March, 1996
  programminer environment : Delphi 1.0 under Win95 .
  (I am waiting for Delphi 2.0 published on Taiwan , where i live .)

  If you find any bugs or problems, please contact me via E-mail
  Internet: br831529@cs.nthu.edu.tw
}

interface

uses SysUtils,
  WinProcs,
  Forms,
  Classes,
  Dialogs;

type

TWinSaver = class(TComponent)
 private
	FIniFile: string;
        FIsLocal: Boolean;
	FIniSect: string;
        FSaveSize: Boolean;
        FSaveLocation: Boolean;
        FSaveState: Boolean;
        FRealIniFile: string;
        procedure OpenIniFile;
        procedure SaveWindow(TheForm: TForm);
        procedure RestoreWindow(TheForm: TForm);
 public
	constructor Create(AOwner: TComponent); override;
	procedure Save;
	procedure Restore;
        procedure SaveChildren(TheForm: TForm);
        procedure RestoreChildren(TheForm: TForm);
 published
        property IniFile: string read FIniFile write FIniFile;
        property LocalDir: Boolean read FIsLocal write FIsLocal default False;
        property IniSection: string read FIniSect write FIniSect;
        property SaveSize: Boolean read FSaveSize write FSaveSize default True;
        property SaveLocation: Boolean read FSaveLocation write FSaveLocation
default True;
        property SaveState: Boolean read FSaveState write FSaveState default
True;
end;

procedure register;

implementation

uses IniFiles;

var
   Ini: TIniFile;

constructor TWinSaver.Create(AOwner: TComponent);
begin
	inherited create(AOwner);

        FIsLocal := False;
        FSaveSize := True;
        FSaveLocation := True;
        FSaveState := True;
        FIniFile := ChangeFileExt(ExtractFileName(Application.Name), '.INI');
        FIniSect := 'WinSaver';
end;

procedure TWinSaver.RestoreWindow(TheForm: TForm);
begin
     with TheForm do begin
          if FSaveSize then begin
             Width := Ini.ReadInteger(FIniSect, ClassName + '_Width', Width);
             Height := Ini.ReadInteger(FIniSect, ClassName + '_Height', Height);
          end;


          if FSaveLocation then begin
             Top := Ini.ReadInteger(FIniSect, ClassName + '_Top', Top);
             Left := Ini.ReadInteger(FIniSect, ClassName + '_Left', Left);
          end;

          if FSaveState then
             case Ini.ReadInteger(FIniSect, ClassName + '_WindowState', 2) of
                  1: WindowState := wsMinimized;
                  2: WindowState := wsNormal;
                  3: WIndowState := wsMaximized;
             end;
     end;
end;


procedure TWinSaver.RestoreChildren(TheForm: TForm);
var i: integer;
begin
     for i := 0 to TheForm.MDIChildCount-1 do
         RestoreWindow(TheForm.MDIChildren[i]);
end;


procedure TWinSaver.Restore;
var i: Integer;
begin
        OpenIniFile;
	try
	   for i := 0 to Application.ComponentCount-1 do
               if (Application.Components[i] is TForm) then begin
                  RestoreWindow(TForm(Application.Components[i]));
                  if TForm(Application.Components[i]).FormStyle = fsMDIForm then
                     RestoreChildren(TForm(Application.Components[i]));
               end;
	finally
           Ini.free;
	end;
end;


procedure TWinSaver.Save;
var i: Integer;
begin
        OpenIniFile;
	try
	   for i := 0 to Application.ComponentCount-1 do
               if (Application.Components[i] is TForm) then begin
                  SaveWindow(TForm(Application.Components[i]));
                  if TForm(Application.Components[i]).FormStyle = fsMDIForm then
                     SaveChildren(TForm(Application.Components[i]));
               end;
	finally
           Ini.free;
	end;
end;

procedure TWinSaver.SaveWindow(TheForm: TForm);
begin
     with TheForm do begin
          if SaveSize then begin
             Ini.WriteInteger(FIniSect, ClassName + '_Width', Width);
             Ini.WriteInteger(FIniSect, ClassName + '_Height', Height);
          end;

          if FSaveLocation then begin
             Ini.WriteInteger(FIniSect, ClassName + '_Top', Top);
             Ini.WriteInteger(FIniSect, ClassName + '_Left', Left);
          end;

          if FSaveState then
             case TheForm.WindowState of
                  wsMinimized: Ini.WriteInteger(FIniSect, ClassName +
'_WindowState', 1);
                  wsNormal:    Ini.WriteInteger(FIniSect, ClassName +
'_WindowState', 2);
                  wsMaximized: Ini.WriteInteger(FIniSect, ClassName +
'_WindowState', 3);
             end;
     end;
end;

procedure TWinSaver.SaveChildren(TheForm: TForm);
var i: integer;
begin
     for i := 0 to TheForm.MDIChildCount-1 do
         SaveWindow(TheForm.MDIChildren[i]);
end;

procedure TWinSaver.OpenIniFile;
var
   buf: PChar;
begin
        if FIniFile = '' then     { if IniFile property is empty , set to
appname.ini}
           FIniFile := ChangeFileExt(ExtractFileName(Application.ExeName),
'.INI')
        else        { change to '.ini' extesion }
           FIniFile := ChangeFileExt(ExtractFileName(FIniFile), '.INI');

        if not FIsLocal then begin
           GetMem(buf,256);
           try
              GetWindowsDirectory(buf,256);
              FRealIniFile := StrPas(buf)+'\'+FIniFile;
           finally
              FreeMem(buf,256);
           end;
        end else
            FRealIniFile := FIniFile;

        if FIniSect = '' then        {if IniSection property is empty, set to
[WinSaver]}
	   FIniSect := 'WinSaver';

       	Ini := TIniFile.Create(FRealIniFile);
end;

procedure register;
begin
     RegisterComponents('system',[TWinSaver]);
end;

end.
