/*****************************************************************************

					Visualib Header File
					Copyright (c) 1994
					Visual Tech Co.
					P.O.Box 8735
					Fort Wayne, IN 46898-8735

*****************************************************************************/

/*****************************************************************************

					Constants, types, and Macros

*****************************************************************************/

#ifdef	__cplusplus
extern	"C" {
#endif

typedef DWORD	HVIEW;
typedef DWORD	HMATE;
typedef DWORD	HLITE;

#define REAL	double
#ifndef	WIN32
typedef int		INT;
#endif

#define VOIDED VOID WINAPI
#define INTEGER INT WINAPI
#define BOOLEAN BOOL WINAPI
#define SGLWORD WORD WINAPI
#define	DBLWORD DWORD WINAPI
#define	STRING LPSTR WINAPI
#define	VIEWHDL HVIEW WINAPI
#define MATEHDL HMATE WINAPI
#define LITEHDL HLITE WINAPI

typedef REAL FAR	*LPREAL;
typedef REAL FAR	*VECTOR;
typedef REAL FAR	*MATRIX;

typedef REAL		VECTOR2[2];
typedef REAL		VECTOR3[3];
typedef REAL		VECTOR4[4];
typedef REAL		MATRIX2D[9];
typedef REAL		MATRIX3D[16];
typedef VECTOR2	FAR	*LPVECT2;
typedef VECTOR3	FAR	*LPVECT3;
typedef	VECTOR4 FAR	*LPVECT4;
typedef VECTOR FAR	*LPVECTOR;

typedef struct _tagPOINT2D {		/* 2D point coordinates */
	REAL	x, y;
} POINT2D, FAR *LPPOINT2D;

typedef struct _tagPOINT2H {		/* 2D homogeneous point coordinates */
	REAL	x, y, w;
} POINT2H, FAR *LPPOINT2H;

typedef struct _tagPOINT3D {		/* 3D point coordinates */
	REAL	x, y, z;
} POINT3D, FAR *LPPOINT3D;

typedef struct _tagPOINT3H {		/* 3D homogeneous point coordinates */
	REAL	x, y, z, w;
} POINT3H, FAR *LPPOINT3H;

typedef struct _tagBOX2D {
	REAL	xmin, xmax, ymin, ymax;
} BOX2D, FAR *LPBOX2D;

typedef struct _tagBOX3D {
	REAL	xmin, xmax, ymin, ymax, zmin, zmax;
} BOX3D, FAR *LPBOX3D;

typedef struct tagFACET {
	INT		npts;
	VECTOR3 normal;
	LPINT	vindex;
	LPINT	nindex;
} FACET, FAR *LPFACET;

typedef struct tagWIRE {
	INT	vert1;
	INT	vert2;
} WIRE, FAR *LPWIRE;

typedef struct tagPOLYFACET {
	INT		nvert;
	INT		nnorm;
	INT		nfacet;
	INT		nwire;
	LPPOINT3D	vertex;
	LPVECT3		normal;
	LPFACET		facet;
	LPWIRE		wire;
} POLYFACET, FAR *LPPOLYFACET;

typedef MATRIX3D FAR	*LPMTRX3D;
typedef MATRIX2D FAR	*LPMTRX2D;

#define EPSILON (REAL) 1e-5
#define QUTRPI	(REAL) 0.78539816339744810711
#define HALFPI	(REAL) 1.57079632679489621423
#define PI		(REAL) 3.14159265358979323846
#define TWOPI	(REAL) 6.28318530717958647692
#define DTOR	(REAL) 0.0174532
#define ATOR	(REAL) 1.7453293e-3
#define RTOD	(REAL) 57.295779
#define	SQRT2	(REAL)1.414214
#define	SQRT3	(REAL)1.732051

/* coordinate type */
#define	VL_2D	0x1000
#define	VL_3D	0x2000
#define	VL_2H	0x0400
#define	VL_3H	0x0800

/* viewer status flag */
#define	VL_TWOD			8
#define	VL_THREED		16
#define	VL_CURRENT		0x0100
#define	VL_DEFAULT		0x1000
#define	VL_DEFAULT2D	0x1100

/* light coordinate mode */
#define	VL_WORLDLIGHT		0x0001
#define	VL_CAMERALIGHT		0x0002
#define	VL_OBJECTLIGHT		0x0004

/* light type */
#define	VL_POINTLIGHT		0x0100
#define	VL_DISTLIGHT		0x0200
#define	VL_SPOTLIGHT		0x0400
#define VL_AREALIGHT		0x0800

#define VL_INQUIRE			0xFFFFFFFF
#define	VL_PERTURBMATERIAL	0x0B00
#define VL_PERTURBNORMAL	0x0C00
#define	VL_PERTURBPIXEL		0x0D00
#define VL_PERTURBFACET		0x0E00

/* projection mode */
#define VL_PROJECTIONMODE	0x03
#define VL_PERSPECTIVE		0x01
#define VL_ORTHOGONAL		0x02

/* standard pen and brush color */
#define	VL_NONE			0
#define VL_RED			1
#define VL_GREEN		2
#define VL_BLUE			3
#define VL_BROWN		4
#define VL_MAGENTA		5
#define VL_CYAN			6
#define VL_WHITE		7
#define VL_GRAY			8
#define VL_LIGHTRED		9
#define VL_LIGHTGREEN	10
#define VL_LIGHTBLUE	11
#define VL_YELLOW		12
#define VL_LIGHTMAGENTA	13
#define VL_LIGHTCYAN	14
#define VL_LIGHTGRAY	15
#define VL_BLACK		16

/* shading method */
#define	VL_WIREFRAME		0x0001
#define	VL_SOLIDFILL		0x0002
#define	VL_CONTOURSHADE		0x0004
#define	VL_GOURAUDSHADE		0x0008
#define	VL_PHONGSHADE		0x0010
#define	VL_FLATSHADE		0x0020

/* shading model */
#define	VL_PHONGMODEL		0x0100
#define	VL_SPECULARMODEL	0x0200

/* mark type */
#define	VL_NULLMARK			0x0000
#define	VL_CIRCLEMARK		0x0001
#define	VL_CROSSMARK		0x0002
#define	VL_XMARK			0x0004
#define	VL_TRIANGLEMARK		0x0008
#define	VL_BOXMARK			0x0010
#define	VL_DIAMONDMARK		0x0020
#define	VL_HEXAGONMARK		0x0040
#define	VL_OCTAGONMARK		0x0080

/* arrow head type */
#define	VL_NULLARROW		0x0000
#define	VL_OPENARROW		0X0100
#define	VL_CLOSEDARROW		0X0200

/* position mark type */
#define	VL_CROSSHAIR	1
#define	VL_ORIGIN		2

/* solid texture flag */
#define	VL_MARBLE		0x0001
#define	VL_WOODGRAIN	0x0002
#define	VL_GRANITE		0x0004
#define	VL_BUMPY		0x0008

/* Useful Macros */
#define ABS(x)		(((x)>0)?(x):-(x))
#define TRUNC(x)	((INT) (x))
#define	FLOOR(x)	(((x)>0) ? (INT)(x) : -(INT)(-(x)+1))
#define	CEILING(x)	((x)==(INT)(x)?(x):(((x)>0)?1+(INT)(x):-(1+(INT)(-(x)))))
#define	ROUND(x)	((x)>0 ? (INT)(x+0.5f) : -(INT)(0.5f-x))
#define SQR(x)		((x)*(x))
#define SQR2(x,y)	((REAL)(SQR(x)+SQR(y)))
#define SQR3(x,y,z)	((REAL)(SQR(x)+SQR(y)+SQR(z)))

#define MAX(a,b)	(((a) > (b)) ? (a) : (b))
#define MIN(a,b)	(((a) < (b)) ? (a) : (b))
#define	SWAP(a,b)	{ a^=b; b^=a; a^=b; }
#define MIDVAL(a,b)	(((a) + (b)) * 0.5f)
#define	LERP(a,l,h)	((l) + (((h) - (l)) * (a)))
#define	CLAMP(v,l,h)	((v) < (l) ? (l) : (v) > (h) ? (h) : (v))
#define	STEP(v,s)	((v) < (s) ? 0 : 1)
#define	SIGN(x)		(((x) < 0) ? -1 : (x) > 0 ? 1 : 0)

#define	NEWLIST(type,n)	(type FAR *)_fmalloc (sizeof (type) * (n))
#define	NEWITEM(type)	(type FAR *)_fmalloc (sizeof (type))
#define	FREE(p)			_ffree(p)
#define	EXIT			goto exit
#define	NEXT(ptr)		ptr = (ptr)->next
#define PREV(ptr)		ptr = (ptr)->prev

#define DIST2(x,y)			((REAL)sqrt(SQR2(x,y)))
#define DIST3(x,y,z)		((REAL)sqrt(SQR3(x,y,z)))
#define DETERM2(a,b,c,d)	((a) * (d) - (b) * (c))
#define DETERM3(a,b,c,d,e,f,g,h,i) ((a)*DETERM2(e,f,h,i)+(b)*DETERM2(f,d,i,g)+(c)*DETERM2(d,e,g,h))

#define VSET2(v,x,y)		((v)[0]=(x),(v)[1]=(y))
#define VSET3(v,x,y,z)		((v)[0]=(x),(v)[1]=(y),(v)[2]=(z))
#define VSET4(v,x,y,z,w)	((v)[0]=(x),(v)[1]=(y),(v)[2]=(z),(v)[3]=(w))
#define	VGET2(v,x,y)		(x=(v)[0],y=(v)[1])
#define	VGET3(v,x,y,z)		(x=(v)[0],y=(v)[1],z=(v)[2])
#define	VGET4(v,x,y,z,w)	(x=(v)[0],y=(v)[1],z=(v)[2],w=(v)[3])

#define	VDOT(a,b)			((a[0]*b[0])+(a[1]*b[1])+(a[2]*b[2]))
#define	VDOT2(a,b)			((a[0]*b[0])+(a[1]*b[1]))
#define	VABS(a)				(REAL)sqrt(VDOT(a, a))
#define	VABS2(a)			(REAL)sqrt(VDOT2(a, a))

/*****************************************************************************

					Function Prototypes

*****************************************************************************/

/*****************************************************************************

					Math Functions

*****************************************************************************/

BOOLEAN	vunify (VECTOR a, VECTOR b);
VOIDED	vadd (VECTOR a, VECTOR b, VECTOR c);
VOIDED	vsub (VECTOR a, VECTOR b, VECTOR c);
VOIDED	dotproduct (VECTOR a, VECTOR b, LPREAL result);
VOIDED	crossproduct (VECTOR a, VECTOR b, VECTOR c);
VOIDED	mixproduct (VECTOR a, VECTOR b, VECTOR c, LPREAL result);
BOOLEAN	vcos (VECTOR a, VECTOR b, LPREAL result);
BOOLEAN	vsin (VECTOR a, VECTOR b, LPREAL result);
BOOLEAN	vangle (VECTOR a, VECTOR b, LPREAL result);
BOOLEAN	vpara (VECTOR a, VECTOR b);
BOOLEAN	vperp (VECTOR a, VECTOR b);
BOOLEAN	vflat (VECTOR a, VECTOR b, VECTOR c);

/*****************************************************************************

					Basic Functions

*****************************************************************************/

BOOLEAN	InitializeVisualib (void);
VOIDED	ExitVisualib (void);
VOIDED	AboutVisualib (void);
VOIDED	LicenseInfo (void);

/* utility functions */
int FAR CDECL	Message (WORD flag, LPSTR title, LPSTR format, ...);
COLORREF WINAPI	SelectColor (COLORREF color);

VOIDED	SetPoint2D (LPPOINT2D point, REAL x, REAL y);
VOIDED	SetPoint3D (LPPOINT3D point, REAL x, REAL y, REAL z);
VOIDED	SetPoint2H (LPPOINT2H point, REAL x, REAL y, REAL w);
VOIDED	SetPoint3H (LPPOINT3H point, REAL x, REAL y, REAL z, REAL w);
VOIDED	SetBox2D (LPBOX2D box, REAL xmin, REAL xmax, REAL ymin, REAL ymax);
VOIDED	SetBox3D (LPBOX3D box, REAL xmin, REAL xmax, REAL ymin, REAL ymax, REAL zmin, REAL zmax);

VOIDED	PenColor (HDC hdc, WORD color_index);
VOIDED	BrushColor (HDC hdc, WORD color_index);
VOIDED	TextColor (HDC hdc, WORD tcolor, WORD bcolor);
VOIDED	PaintColor (HDC hdc, WORD pen_color, WORD brush_color);

BOOLEAN	DeleteViewer (HVIEW hv);
VIEWHDL	NewViewer (WORD type);
VOIDED	FreeViewer (HVIEW hv);
DBLWORD	ViewerBackgroundColor (HVIEW hv, COLORREF color);

SGLWORD	ViewerMappingMode (HVIEW hv, WORD mode);
BOOLEAN	CopyViewer (HVIEW hv1, HVIEW hv2);
VIEWHDL	SelectViewer (HVIEW hv);
BOOLEAN	SetViewerFrame (HVIEW hv, LPRECT frame);
BOOLEAN	GetViewerFrame (HVIEW hv, LPRECT frame);
BOOLEAN	CleanViewer (HDC hdc, HVIEW hv);
DBLWORD	ViewerBackgroundColor (HVIEW hv, COLORREF color);
STRING	ViewerName (HVIEW hv, LPSTR name);
BOOLEAN	DisplayViewerFrame (HDC hdc, HVIEW hv);
BOOLEAN	DisplayViewerName (HDC hdc, HVIEW hv, BOOL top);

BOOLEAN	BeginDoubleBuffer (LPHANDLE hdc);
BOOLEAN	EndDoubleBuffer (LPHANDLE hdc);
BOOLEAN	UpdateDoubleBuffer (HDC hdc);

/*****************************************************************************

						2D Functions

*****************************************************************************/

VOIDED	Translate2D (REAL x, REAL y);
VOIDED	TranslateTo2D (REAL x, REAL y);
VOIDED	Scale2D (REAL x, REAL y);
VOIDED	PointScale2D (REAL x, REAL y, REAL sx, REAL sy);
VOIDED	TranScale2D (REAL x, REAL y, REAL sx, REAL sy);
VOIDED	Shear2D (REAL x, REAL y, REAL a, REAL u, REAL v);
VOIDED	Stretch2D (REAL x, REAL y, REAL a, REAL f);
VOIDED	Mirror2D (REAL x, REAL y, REAL a);
VOIDED	Rotate2D (REAL angle);
VOIDED	PointRotate2D (REAL x, REAL y, REAL a);
BOOLEAN	ViewerField2D (HVIEW hv,
			LPREAL left, LPREAL bottom, LPREAL right, LPREAL top);

BOOLEAN	PushTransformation2D (MATRIX m);
BOOLEAN	PopTransformation2D (MATRIX m);
VOIDED	ConcatTransformation2D (MATRIX m, BOOL post);
VOIDED	LoadTransformation2D (MATRIX m);

BOOLEAN	SetProjection2D (HVIEW hv,
			REAL left, REAL bottom, REAL right, REAL top);
BOOLEAN	SetView2D (HVIEW hv, REAL x, REAL y, REAL a);
BOOLEAN	SetWindow2D (HVIEW hv, REAL left, REAL bottom, REAL right, REAL top);

BOOLEAN	MoveViewer2D (HVIEW hv, REAL horizontal, REAL vertical, BOOL local);
BOOLEAN	RotateViewer2D (HVIEW hv, REAL angle, BOOL local);
BOOLEAN	ZoomViewer2D (HVIEW hv, REAL zoom);

VOIDED	MoveTo2D (HDC hdc, REAL x, REAL y);
VOIDED	LineTo2D (HDC hdc, REAL x, REAL y);
VOIDED	Line2D (HDC hdc, REAL x1, REAL y1, REAL x2, REAL y2);
VOIDED	Line2D (HDC hdc, REAL x1, REAL y1, REAL x2, REAL y2);

VOIDED	RMoveTo2D (HDC hdc, REAL x, REAL y);
VOIDED	RLineTo2D (HDC hdc, REAL x, REAL y);
VOIDED	RLine2D (HDC hdc, REAL x, REAL y, REAL dx, REAL dy);
VOIDED	Label2D (HDC hdc, REAL x, REAL y, LPSTR label);

VOIDED	MoveTo2H (HDC hdc, REAL x, REAL y, REAL w);
VOIDED	LineTo2H (HDC hdc, REAL x, REAL y, REAL w);
VOIDED	Line2H (HDC hdc, REAL x1, REAL y1, REAL w1,
			REAL x2, REAL y2, REAL w2);

VOIDED	Polygon2D (HDC hdc, WORD type, VECTOR vertex, INT count);
VOIDED	PolyPolygon2D (HDC hdc, WORD type, VECTOR vertex,
			LPINT polycount, INT count);
VOIDED	Polyline2D (HDC hdc, WORD type, VECTOR point, INT count);
VOIDED	ClosedPolyline2D (HDC hdc, WORD type, VECTOR point, INT count);
VOIDED	Mark2D (HDC hdc, REAL x, REAL y, INT hsize, INT vsize, WORD head);
VOIDED	PolyMark2D (HDC hdc, WORD type, VECTOR point, INT count,
			INT hsize, INT vsize, WORD head);
VOIDED	Pointer2D (HDC hdc, REAL x1, REAL y1, REAL x2, REAL y2,
			REAL l, REAL w, WORD type);
VOIDED	Arrow2D (HDC hdc, REAL x, REAL y, REAL u, REAL v, REAL r, REAL l, 
			REAL w, WORD type);
VOIDED	Net2D (HDC hdc, WORD type, VECTOR point, INT m, INT n);
VOIDED	MarkPosition2D (HDC hdc, REAL x, REAL y, REAL size, WORD type);

/*****************************************************************************

						3D Functions

*****************************************************************************/

SGLWORD	ProjectionMode (HVIEW hv, DWORD mode);

VOIDED	Translate3D (REAL x, REAL y, REAL z);
VOIDED	TranslateTo3D (REAL x, REAL y, REAL z);
VOIDED	Scale3D (REAL sx, REAL sy, REAL sz);
VOIDED	PointScale3D (REAL x, REAL y, REAL z, REAL sx, REAL sy, REAL sz);
VOIDED	Rotate3D (REAL angle, char axis);
VOIDED	AxleRotate3D (VECTOR ref, VECTOR dir, REAL a);
VOIDED	Stretch3D (VECTOR ref, VECTOR dir, REAL f);
VOIDED	Shear3D (VECTOR ref, VECTOR dir, REAL u, REAL v);
VOIDED	Mirror3D (VECTOR ref, VECTOR dir);

BOOLEAN	PushTransformation3D (MATRIX m);
BOOLEAN	PopTransformation3D (MATRIX m);
VOIDED	ConcatTransformation3D (MATRIX m, BOOL post);
VOIDED	LoadTransformation3D (MATRIX m);

BOOLEAN	SetProjection3D (HVIEW hv, REAL left, REAL bottom, REAL right,
			REAL top, REAL front, REAL back, BYTE mode);
BOOLEAN	SetPerspective (HVIEW hv, REAL fovy, REAL aspect,
			REAL zmin, REAL zmax);
BOOLEAN	SetView3D (HVIEW hv, REAL ex, REAL ey, REAL ez,
			REAL ax, REAL ay, REAL az, REAL twist);
BOOLEAN	SetPolarView (HVIEW hv, REAL ax, REAL ay, REAL az,
			REAL dist, REAL azim, REAL inc, REAL twist);

BOOLEAN	ViewerLocation (HVIEW hv, LPREAL x, LPREAL y, LPREAL z);
BOOLEAN	ViewerDirection (HVIEW hv, LPREAL x, LPREAL y, LPREAL z);
BOOLEAN	ViewerField3D (HVIEW hv, LPREAL left, LPREAL bottom,
			LPREAL right, LPREAL top, LPREAL front, LPREAL back);

BOOLEAN	MoveViewer3D (HVIEW hv, REAL horizontal, REAL vertical,
			REAL backforth, BOOL local);
BOOLEAN	RotateViewer3D (HVIEW hv, REAL angle, char axis, BOOL local);
BOOLEAN	ZoomViewer3D (HVIEW hv, REAL zoom);

VOIDED	MoveTo3D (HDC hdc, REAL x, REAL y, REAL z);
VOIDED	LineTo3D (HDC hdc, REAL x, REAL y, REAL z);
VOIDED	MoveTo3H (HDC hdc, REAL x, REAL y, REAL z, REAL w);
VOIDED	LineTo3H (HDC hdc, REAL x, REAL y, REAL z, REAL w);
VOIDED	Line3D (HDC hdc, REAL x1, REAL y1, REAL z1,
			REAL x2, REAL y2, REAL z2);
VOIDED	Line3H (HDC hdc, REAL x1, REAL y1, REAL z1, REAL w1,
			REAL x2, REAL y2, REAL z2, REAL w2);

VOIDED	RMoveTo3D (HDC hdc, REAL x, REAL y, REAL z);
VOIDED	RLineTo3D (HDC hdc, REAL x, REAL y, REAL z);
VOIDED	RLine3D (HDC hdc, REAL x, REAL y, REAL z, REAL dx, REAL dy, REAL dz);

VOIDED	PolyArrow3D (HDC hdc, WORD type, VECTOR poly, LPVECT3 dir, INT count,
			REAL r, REAL l, REAL w, WORD htype);
VOIDED	Label3D (HDC hdc, REAL x, REAL y, REAL z, LPSTR label);
BOOLEAN	Mark3D (HDC hdc, REAL x, REAL y, REAL z,
			INT hsize, INT vsize, WORD type);
VOIDED 	PolyMark3D (HDC hdc, WORD type, VECTOR point, INT count,
			INT hsize, INT vsize, WORD htype);


VOIDED	Polygon3D (HDC hdc, WORD type, VECTOR vertex, INT count);
VOIDED	PolyPolygon3D (HDC hdc, WORD type, VECTOR vertex,
			LPINT polycount, INT count);
VOIDED	Polyline3D (HDC hdc, WORD type, VECTOR point, INT count);
VOIDED	ClosedPolyline3D (HDC hdc, INT type, VECTOR point, INT count);
VOIDED	MarkPosition3D (HDC hdc, REAL x, REAL y, REAL z, REAL size, WORD type);
VOIDED	Pointer3D (HDC hdc, REAL x1, REAL y1, REAL z1, REAL x2, REAL y2,
			REAL z2, REAL l, REAL w, WORD type);
VOIDED	Arrow3D (HDC hdc, REAL x, REAL y, REAL z, REAL u, REAL v, REAL w,
			REAL r, REAL l, REAL t, WORD type);
VOIDED	Net3D (HDC hdc, WORD type, VECTOR point, INT m, INT n);

/*****************************************************************************

						Shading Functions

*****************************************************************************/

VOIDED	ResetShader (void);

/* depth buffer functions */
BOOLEAN	SetDepthBuffer (HVIEW hv);
BOOLEAN	SelectDepthBuffer (HVIEW hv);
BOOLEAN	FreeDepthBuffer (HVIEW hv);
VOIDED	ClearDepthBuffer (WORD val);

/* light functions */
BOOLEAN	CopyLight (HLITE hl1, HLITE hl2);
BOOLEAN	ResetLight (HLITE hl);
LITEHDL	SelectLight (HLITE hl);
BOOLEAN	DeleteLight (HLITE hl);
SGLWORD	LightType (HLITE hl);
BOOLEAN	SwitchLight (HLITE hl, DWORD status);
BOOLEAN	SetLightLocation (HLITE hl, REAL x, REAL y, REAL z);
BOOLEAN	GetLightLocation (HLITE hl, LPREAL x, LPREAL y, LPREAL z);
BOOLEAN	SetLightDirection (HLITE hl, REAL x, REAL y, REAL z);
BOOLEAN	GetLightDirection (HLITE hl, LPREAL x, LPREAL y, LPREAL z);
BOOLEAN	SetSpotlightSpread (HLITE hl, INT angle, INT spread);
BOOLEAN	GetSpotlightSpread (HLITE hl, LPINT angle, LPINT spread);

/* material functions */
BOOLEAN	DeleteMaterial (HMATE hm);
MATEHDL	SelectMaterial (HMATE hm);
BOOLEAN	CopyMaterial (HMATE hm1, HMATE hm2);
BOOLEAN	ResetMaterial (HMATE hm);

DBLWORD	AmbientColor (COLORREF color);
DBLWORD	LightColor (HLITE hl, COLORREF color);
DBLWORD	MaterialSpecular (HMATE hm, COLORREF color);
DBLWORD	MaterialAmbient (HMATE hm, COLORREF color);
DBLWORD	MaterialDiffuse (HMATE hm, COLORREF color);
DBLWORD	MaterialEmission (HMATE hm, COLORREF color);
SGLWORD	MaterialShininess (HMATE hm, DWORD shininess);
SGLWORD	LightIntensity (HLITE hl, DWORD intensity);
LITEHDL	NewLight (WORD type);
MATEHDL	NewMaterial (VOID);
SGLWORD	LightCoordinateType (HLITE hl, DWORD type);
STRING	LightName (HLITE hl, LPSTR name);
STRING	MaterialName (HMATE hm, LPSTR name);

/* shading parameter functions */
VOIDED	SetAttenuation (REAL k0, REAL k1, REAL k2);
BOOLEAN	LocalViewer (DWORD on);
BOOLEAN	DepthBuffer (DWORD on);
BOOLEAN	TwoSideShading (DWORD on);
BOOLEAN	BackFaceRemoval (DWORD on);
BOOLEAN	PolygonDirection (DWORD countclock);
SGLWORD	ShadingMethod (DWORD method);
SGLWORD	ShadingModel (DWORD type);

HPALETTE WINAPI	SetRGBPalette (void);

/* shading primitive functions */
BOOLEAN	_ShadeFacet (HDC hdc, VECTOR normal, WORD type, VECTOR vertex, INT count, LPVECT3 param);
#define	ShadeFacet(hdc, normal, type, vertex, count, param)	\
_ShadeFacet (hdc, normal, type, (VECTOR) vertex, count, param)
BOOLEAN	_ShadePolygon (HDC hdc, VECTOR normal, WORD type, VECTOR point, INT count);
#define	ShadePolygon(hdc, normal, type, point, count)	\
_ShadePolygon(hdc, normal, type, (VECTOR) point, count)
BOOLEAN	_ShadePolyPolygon (HDC hdc, VECTOR normal, WORD type, VECTOR vertex, LPINT pcount, INT count);
#define	ShadePolyPolygon(hdc, normal, type, vertex, pcount, count)	\
_ShadePolyPolygon (hdc, normal, type, (VECTOR) vertex, pcount, count)

BOOLEAN	ShadePolyFacet (HDC hdc, LPPOLYFACET polyfacet);
BOOLEAN	ShadingPreview (HDC hdc, LPRECT rect, REAL r, REAL d);
DBLWORD	ScaleColor (COLORREF color, REAL scale);

/* programmable shader functions */
VOIDED	GetPixelPosition (LPINT x, LPINT y);
VOIDED	GetPixelViewNormal (VECTOR normal);
VOIDED	GetPixelWorldNormal (VECTOR normal);
VOIDED	GetPixelObjectNormal (VECTOR normal);
VOIDED	GetPixelViewCoordinate (VECTOR coord);
VOIDED	GetPixelWorldCoordinate (VECTOR coord);
VOIDED	GetPixelObjectCoordinate (VECTOR coord);
VOIDED	GetPixelViewCameraAxis (VECTOR vaxis);
VOIDED	GetPixelWorldCameraAxis (VECTOR vaxis);
VOIDED	GetPixelObjectCameraAxis (VECTOR vaxis);

typedef void (CALLBACK *MATERIALPROC)(HMATE);
typedef void (CALLBACK *NORMALPROC)(VECTOR);
typedef void (CALLBACK *PIXELPROC)(LPDWORD);
VOIDED	SetPerturbation (WORD type, void (CALLBACK* proc)());

BOOLEAN	ShadingPerturbation (WORD type, DWORD status);
BOOLEAN	SolidTexture (WORD type);

/*****************************************************************************

				Image Mapping and Printing Functions

*****************************************************************************/

typedef int (WINAPI *DRAWPROC)(HDC);

#define	VL_FLUSHTOP		0x0001
#define	VL_FLUSHBOTTOM	0x0002
#define	VL_FLUSHLEFT	0x0004
#define	VL_FLUSHRIGHT	0x0008

#define	VL_HORZFIT		0x0010
#define	VL_VERTFIT		0x0020
#define	VL_ALLFIT		0x0030
#define	VL_HORZCENTER	0x0040
#define	VL_VERTCENTER	0x0080

#define	VL_HORZSCALED	0x0100
#define	VL_VERTSCALED	0x0200
#define	VL_BESTFIT		0x0400
#define	VL_USE31APIS	0x0800

#define	VL_MILLIMETER	0x1000
#define	VL_CENTIMETER	0x2000
#define	VL_MARKCORNER	0x4000
#define	VL_MARKPAGE		0x8000

BOOLEAN	ReadDIBFile (LPSTR fname, LPHANDLE hdib);
HANDLE	WINAPI	ScreenToDIB (LPRECT rect);
BOOLEAN	WriteDIBFile (LPSTR fname, HANDLE hdib);
BOOLEAN	SetPrintRect (HDC hdc, LPRECT rect, WORD mode, REAL x, REAL y,
			REAL w, REAL h, INT bw, INT bh);
VOIDED	GetScreenRect (HWND hwnd, BOOL withframe, LPRECT rect);
BOOLEAN	PrintImage (HANDLE hdib, WORD mode, REAL x, REAL y, REAL w, REAL h);
BOOLEAN	PrintDrawing (DRAWPROC draw, WORD mode,
			REAL x, REAL y, REAL w, REAL h);
BOOLEAN	ImageMap2D (HDC hdc, HGLOBAL hdib, WORD type, VECTOR vertex);
BOOLEAN	ImageMap3D (HDC hdc, HGLOBAL hdib, WORD type, VECTOR vertex);


/* text parameter */
#define	VL_TEXT_HEIGHT			0x0001
#define	VL_TEXT_ASPECT			0x0002
#define	VL_TEXT_THICKNESS		0x0004

BOOLEAN	TextParameter (WORD type, REAL param);
BOOLEAN	SelectTrueTypeFont (void);
BOOLEAN	SetFont (const LPLOGFONT lplf);
BOOLEAN	Character2D (HDC hdc, REAL x, REAL y, REAL a, WORD character);
BOOLEAN	Character3D (HDC hdc, REAL x, REAL y, REAL a, WORD character);
BOOLEAN	SolidCharacter (HDC hdc, WORD character);
BOOLEAN	Text2D (HDC hdc, REAL x, REAL y, REAL a, LPSTR text);
BOOLEAN	Text3D (HDC hdc, REAL x, REAL y, REAL a, LPSTR text);
BOOLEAN	SolidText (HDC hdc, LPSTR text);
VOIDED	SetTextHeight (REAL height);
VOIDED	GetTextHeight (LPREAL height);
VOIDED	SetTextAspect (REAL aspect);
VOIDED	GetTextAspect (LPREAL aspect);
VOIDED	SetTextThickness (REAL thick);
VOIDED	GetTextThickness (LPREAL thick);

/*****************************************************************************

					2D Curve Functions

*****************************************************************************/

VOIDED	QBezierCurve2D (HDC hdc, WORD type, VECTOR poly);
VOIDED	QBSplineCurve2D (HDC hdc, WORD type, VECTOR poly, INT count);
VOIDED	QNURBSCurve2D (HDC hdc, WORD type, VECTOR poly, INT count, VECTOR knot);

VOIDED	BezierCurve2D (HDC hdc, WORD type, VECTOR poly);
VOIDED	HermitCurve2D (HDC hdc, WORD type, VECTOR poly);
VOIDED	BSplineCurve2D (HDC hdc, WORD type, VECTOR poly, INT count);
VOIDED	NURBSCurve2D (HDC hdc, WORD type, VECTOR poly, INT count, VECTOR knot);
VOIDED	SplineInterp2D (HDC hdc, WORD type, VECTOR poly, INT count);

VOIDED	BSplineCurveClosed2D (HDC hdc, WORD type, VECTOR poly, INT count);
VOIDED	NURBSCurveClosed2D (HDC hdc, WORD type, VECTOR poly,
			INT count, VECTOR knot);

VOIDED	CatmullRomSpline2D (HDC hdc, WORD type, VECTOR poly, INT count);


/*****************************************************************************

					3D Curve Functions

*****************************************************************************/

VOIDED	QBezierCurve3D (HDC hdc, WORD type, VECTOR poly);
VOIDED	QBSplineCurve3D (HDC hdc, WORD type, VECTOR poly, INT count);
VOIDED	QNURBSCurve3D (HDC hdc, WORD type, VECTOR poly, INT count, VECTOR knot);
VOIDED	BezierCurve3D (HDC hdc, WORD type, VECTOR poly);
VOIDED	HermitCurve3D (HDC hdc, WORD type, VECTOR poly);
VOIDED	BSplineCurve3D (HDC hdc, WORD type, VECTOR poly, INT count);
VOIDED	NURBSCurve3D (HDC hdc, WORD type, VECTOR poly, INT count, VECTOR knot);
VOIDED	SplineInterp3D (HDC hdc, WORD type, VECTOR poly, INT count);
VOIDED	BSplineCurveClosed3D (HDC hdc, WORD type, VECTOR poly, INT count);
VOIDED	NURBSCurveClosed3D (HDC hdc, WORD type, VECTOR poly,
			INT count, VECTOR knot);
VOIDED	CatmullRomSpline3D (HDC hdc, WORD type, VECTOR poly, INT count);
VOIDED	Spring (HDC hdc, INT count, REAL radius, REAL height);

/*****************************************************************************

					3D Curve Functions

*****************************************************************************/

INTEGER	CircleSide (WORD side);
VOIDED	TransfVertex (WORD type, REAL x, REAL y, REAL a, REAL sx, REAL sy, LPREAL vertex, INT count);
INTEGER	RectangleVertex (WORD type, REAL x1, REAL y1, REAL x2, REAL y2, LPREAL vertex);
INTEGER	BoxVertex (WORD type, REAL x, REAL y, REAL t, REAL sx, REAL sy, LPREAL vertex);
INTEGER	NgonVertex (WORD type, REAL x, REAL y, REAL t, REAL rx, REAL ry, INT count, LPREAL vertex);
INTEGER	FlowerVertex (WORD type, REAL x, REAL y, REAL t, REAL rx, REAL ry, INT count, REAL r, LPREAL vertex);
INTEGER	StarVertex (WORD type, REAL x, REAL y, REAL t, REAL rx, REAL ry, INT count, LPREAL vertex);
INTEGER	ArcVertex (WORD type, REAL x, REAL y, REAL t, REAL rx, REAL ry, INT count, REAL a, REAL b, LPREAL vertex);
INTEGER	PieVertex (WORD type, REAL x, REAL y, REAL t, REAL rx, REAL ry, INT count, REAL a, REAL b, LPREAL vertex);
INTEGER	RingVertex (WORD type, REAL x, REAL y, REAL t, REAL rx, REAL ry, INT count, REAL a, REAL b, REAL w, LPREAL vertex);
INTEGER	RoseVertex (WORD type, REAL x, REAL y, REAL a, REAL r, INT m, INT n, LPREAL vertex);

/*****************************************************************************

				2D Primitive Functions

*****************************************************************************/

VOIDED	Rectangle2D (HDC hdc, REAL x1, REAL y1, REAL x2, REAL y2);
VOIDED	Box2D (HDC hdc, REAL x, REAL y, REAL t, REAL w, REAL h);
VOIDED	Disk2D (HDC hdc, REAL x, REAL y, REAL t, REAL rx, REAL ry);
VOIDED	Pie2D (HDC hdc, REAL x, REAL y, REAL t,
			REAL rx, REAL ry, REAL a, REAL b);
VOIDED	Ring2D (HDC hdc, REAL x, REAL y, REAL t,
			REAL rx, REAL ry, REAL a, REAL b, REAL w);
VOIDED	Chord2D (HDC hdc, REAL x, REAL y, REAL t,
			REAL rx, REAL ry, REAL a, REAL b);
VOIDED	Ngon2D (HDC hdc, REAL x, REAL y, REAL t, REAL rx, REAL ry, INT count);
VOIDED	Flower2D (HDC hdc, REAL x, REAL y, REAL t,
			REAL rx, REAL ry, INT count, REAL ratio);
VOIDED	Star2D (HDC hdc, REAL x, REAL y, REAL t, REAL rx, REAL ry, INT count);
VOIDED	Arc2D (HDC hdc, REAL x, REAL y, REAL t,
			REAL rx, REAL ry, REAL a, REAL b);
VOIDED	Rose2D (HDC hdc, REAL x, REAL y, REAL t, REAL r, INT m, INT n);

VOIDED	Spiral2D (HDC hdc, REAL x, REAL y, REAL a, REAL b, REAL r, REAL dr);


/*****************************************************************************

				3D Primitive Functions

*****************************************************************************/

VOIDED	Rectangle3D (HDC hdc, REAL x1, REAL y1, REAL x2, REAL y2);
VOIDED	Box3D (HDC hdc, REAL x, REAL y, REAL t, REAL sx, REAL sy);
VOIDED	Ring3D (HDC hdc, REAL x, REAL y, REAL t,
			REAL rx, REAL ry, REAL a, REAL b, REAL w);
VOIDED	Disk3D (HDC hdc, REAL x, REAL y, REAL t, REAL rx, REAL ry);
VOIDED	Pie3D (HDC hdc, REAL x, REAL y, REAL t,
			REAL rx, REAL ry, REAL a, REAL b);
VOIDED	Chord3D (HDC hdc, REAL x, REAL y, REAL t,
			REAL rx, REAL ry, REAL a, REAL b);
VOIDED	Ngon3D (HDC hdc, REAL x, REAL y, REAL t, REAL rx, REAL ry, INT count);
VOIDED	Flower3D (HDC hdc, REAL x, REAL y, REAL t,
			REAL rx, REAL ry, INT count, REAL r);
VOIDED	Star3D (HDC hdc, REAL x, REAL y, REAL t, REAL rx, REAL ry, INT count);

VOIDED	Arc3D (HDC hdc, REAL x, REAL y, REAL t,
			REAL rx, REAL ry, REAL a, REAL b);
VOIDED	Rose3D (HDC hdc, REAL x, REAL y, REAL t, REAL r, INT m, INT n);

VOIDED	Spiral3D (HDC hdc, REAL a, REAL b, REAL r, REAL dr, REAL h);
VOIDED	Spring3D (HDC hdc, REAL a, REAL b, REAL r, REAL h);


/*****************************************************************************

				3D Surface Functions

*****************************************************************************/

BOOLEAN	BezierSurface (HDC hdc, WORD type, VECTOR poly, INT ns, INT nt);
BOOLEAN	HermitSurface (HDC hdc, WORD type, VECTOR poly, INT ns, INT nt);
BOOLEAN	BSplineSurface (HDC hdc, WORD type, VECTOR poly,
			INT Sc, INT Tc, INT ns, INT nt);
BOOLEAN	NURBSSurface (HDC hdc, WORD type, VECTOR poly,
			INT Sc, INT Tc, VECTOR Skn, VECTOR Tkn, INT ns, INT nt);

BOOLEAN	CoonsPatch (HDC hdc, WORD type, VECTOR point, INT nu, INT nv);
BOOLEAN RevolveBezier (HDC hdc, WORD type, VECTOR poly, INT n, REAL angle);
BOOLEAN RevolveHermit (HDC hdc, WORD type, VECTOR poly, INT n, REAL angle);
BOOLEAN RevolveNURBS (HDC hdc, WORD type, VECTOR poly, INT count, VECTOR knot,
			INT n, REAL angle);
BOOLEAN RevolveBSpline (HDC hdc, WORD type, VECTOR poly, INT count,
			INT n, REAL angle);

/*****************************************************************************

							Solid Primitive Functions

*****************************************************************************/

BOOLEAN	Cube (HDC hdc, REAL w, REAL l, REAL h);
BOOLEAN	Cylinder (HDC hDC, REAL rx, REAL ry, REAL h);
BOOLEAN	Cone (HDC hDC, REAL rx, REAL ry, REAL h);
BOOLEAN	Ellipsoid (HDC hdc, REAL a, REAL b, REAL c);
BOOLEAN	Sphere (HDC hdc, REAL r);
BOOLEAN	HemiSphere (HDC hdc, REAL r, REAL h);
BOOLEAN	SolidStar (HDC hdc, INT count, REAL rx, REAL ry, REAL h);
BOOLEAN	SolidFlower (HDC hdc, INT count, REAL r, REAL rx, REAL ry, REAL h);
BOOLEAN	SolidPie (HDC hdc, REAL rx, REAL ry, REAL h, REAL a, REAL b);
BOOLEAN	Frustum (HDC hdc, REAL bw, REAL bl, REAL tw, REAL tl, REAL h);
BOOLEAN	Ridge (HDC hdc, REAL w, REAL l, REAL h, REAL r);
BOOLEAN	Prism (HDC hdc, WORD type, VECTOR base, INT count, REAL h);
BOOLEAN	Pyramid (HDC hdc, LPPOINT3D base, INT count, LPPOINT3D tip);
BOOLEAN	WedgedCone (HDC hdc, REAL rx, REAL ry, REAL h, REAL a, REAL b);
BOOLEAN	WedgedCylinder (HDC hdc, REAL rx, REAL ry, REAL h,
			REAL tr, REAL a, REAL b);
BOOLEAN	WedgedSphere (HDC hdc, REAL rx, REAL ry, REAL rz,
			REAL a1, REAL a2, REAL b1, REAL b2);
BOOLEAN	WedgedTorus (HDC hdc, REAL r1, REAL r2,
			REAL a1, REAL a2, REAL b1, REAL b2);

BOOLEAN	Torus (HDC hdc, REAL r1, REAL r2);

BOOLEAN	SolidRing (HDC hdc, REAL rtop, REAL rbot, REAL t, REAL h, REAL a,
			REAL b, REAL ratio);
BOOLEAN	Tube (HDC hdc, REAL rtop, REAL rbot, REAL t, REAL h);
BOOLEAN	Sweep (HDC hdc, MATRIX transf, INT nstep, LPVECT3 vertex,
			LPVECT3 normals, INT npts, WORD mode, VECTOR snormal);
BOOLEAN	Revolution (HDC hdc, LPVECT3 vertex, LPVECT3 normal, INT n,
			REAL angle, WORD mode, VECTOR snormal);
BOOLEAN	Tetrahedron (HDC hdc, REAL r);
BOOLEAN	Octahedron (HDC hdc, REAL r);
BOOLEAN	Dodecahedron (HDC hdc, REAL r);
BOOLEAN	Icosahedron (HDC hdc, REAL r);

/*****************************************************************************

							Object Array Functions

*****************************************************************************/

typedef	BOOL (WINAPI *BidimArrayProc)(HDC hdc, INT row, INT col);
typedef BOOL (WINAPI *TridimArrayProc)(HDC hdc, INT row, INT col, INT lev);

BOOLEAN	RectangularArray2D (HDC hdc, INT m, INT n,
			REAL xinc, REAL yinc, BidimArrayProc fp);
BOOLEAN	RectangularArray3D (HDC hdc, INT m, INT n,
			REAL xinc, REAL yinc, BidimArrayProc fp);
BOOLEAN	PolarArray2D (HDC hdc, INT m, INT n,
			REAL roff, REAL ainc, REAL rinc, BidimArrayProc);
BOOLEAN	PolarArray3D (HDC hdc, INT m, INT n,
			REAL roff, REAL ainc, REAL rinc, BidimArrayProc);
BOOLEAN	CubicArray (HDC hdc, INT m, INT n, INT l,
			REAL xinc, REAL yinc, REAL zinc, TridimArrayProc fp);
BOOLEAN	CylindricArray (HDC hdc, INT m, INT n, INT l,
			REAL roff, REAL ainc, REAL rinc, REAL zinc,
			TridimArrayProc fp);
BOOLEAN	SphericArray (HDC hdc, INT m, INT n, INT l,
			REAL roff, REAL toff, REAL ainc, REAL rinc, REAL tinc,
			TridimArrayProc fp);

/* Coordinate Transformation Function */

VOIDED	MultiplyMatrix3D (MATRIX a, MATRIX b, MATRIX c);
VOIDED	MultiplyVector3D (MATRIX m, VECTOR a, VECTOR b);
VOIDED	MultiplyVectorTranspose3D (MATRIX m, VECTOR a, VECTOR b);
VOIDED	ConcatMatrix3D (MATRIX a, MATRIX b, BOOL post);
VOIDED	TransformXYZ (MATRIX m, REAL u, REAL v, REAL w, LPREAL x, LPREAL y, LPREAL z);
BOOLEAN	TransformCoordinate3D (MATRIX m, VECTOR a, VECTOR b);
VOIDED	TransformCoordinate3H (MATRIX m, VECTOR a, VECTOR b);
SGLWORD	TransformationMode3D (WORD type);
VOIDED	TransformCoordinates3D (MATRIX m, VECTOR a, VECTOR b, INT n, WORD mode);
VOIDED	TransformPoint3H (MATRIX m, LPPOINT3H a, LPPOINT3H b);
VOIDED	TransformBase3D (MATRIX m, VECTOR a, VECTOR b, VECTOR c);
VOIDED	TransformNormal3D (MATRIX m, VECTOR a, VECTOR b);

/* 3D Transformation Matrix */

VOIDED	SetTranslationMatrix3D (MATRIX m, REAL x, REAL y, REAL z);
VOIDED	SetScaleMatrix3D (MATRIX m, REAL x, REAL y, REAL z);
VOIDED	SetCenterScaleMatrix3D (MATRIX m, REAL x, REAL y, REAL z,
			REAL sx, REAL sy, REAL sz);
VOIDED	SetTranScaleMatrix3D (MATRIX m, REAL tx, REAL ty, REAL tz,
						REAL sx, REAL sy, REAL sz);
VOIDED	SetXRotationMatrix3D (MATRIX m, REAL a);
VOIDED	SetYRotationMatrix3D (MATRIX m, REAL a);
VOIDED	SetZRotationMatrix3D (MATRIX m, REAL a);
VOIDED	SetRotationMatrix3D (MATRIX m, REAL a, char axis);
VOIDED	SetTransformation3D (MATRIX m, REAL x, REAL y, REAL a, REAL sx, REAL sy);
VOIDED	SetBaseMatrix3D (MATRIX m, VECTOR x, VECTOR y, VECTOR t);
VOIDED	SetAxleMatrix3D (MATRIX m, VECTOR ref, VECTOR dir);
VOIDED	SetPlaneMatrix3D (MATRIX m, VECTOR plane);
VOIDED	SetOperationMatrix3D (MATRIX m, MATRIX base, MATRIX operation);
VOIDED	SetAxleRotationMatrix3D (MATRIX m, VECTOR ref, VECTOR dir, REAL a);
VOIDED	SetStretchMatrix3D (MATRIX m, VECTOR ref, VECTOR dir, REAL f);
VOIDED	SetMirrorMatrix3D (MATRIX m, VECTOR ref, VECTOR dir);
VOIDED	SetShearMatrix3D (MATRIX m, VECTOR ref, VECTOR dir, REAL u, REAL v);
VOIDED	SetPointScaleMatrix3D (MATRIX m, REAL x, REAL y, REAL z, REAL sx, REAL sy, REAL sz);

#ifdef __cplusplus
}
#endif
