Declare Function WriteProfileString Lib "Kernel" (ByVal
  lpApplicationName As String, ByVal lpKeyName As String, ByVal lpString
  As String) As Integer
Declare Function CreateScalableFontResource% Lib "GDI" (ByVal fHidden%,
  ByVal lpszResourceFile$, ByVal lpszFontFile$, ByVal lpszCurrentPath$)
  Declare Function AddFontResource Lib "GDI" (ByVal lpFilename As Any) As
  Integer
Declare Function SendMessage Lib "User" (ByVal hWnd As Integer, ByVal
  wMsg As Integer, ByVal wParam As Integer, lParam As Any) As Long

'  This sub installs a TrueType font and makes it available to
'  all Windows apps to use. Also adds it to WIN.INI so on next
'  boot up the font is also loaded.
'
'  FontName$ is the name that appears in the application font menu.
'  FontFileName$ is the actual font name.  (i.e. something.ttf)
'  WindSysDir$ is the Windows system directory. (i.e. C:\WINDOWS\SYSTEM)
'
'  YOU MUST COPY THE FONT FILE TO WINDOWS DIRECTORY BEFORE CALLING THE SUB!
'
'  For examples on how you can get the Windows system directory and copying
'  a copy see Setup Wizard examples in your VB directory.
'
Sub Install_TTF (FontName$, FontFileName$, WindSysDir$)
    Dim Ret%, Res&, FontPath$, FontRes$
    Const WM_FONTCHANGE = &H1D
    Const HWND_BROADCAST = &HFFFF

    FontPath$ = WindSysDir$ + "\" + FontFileName$
    FontRes$ = Left$(FontPath$, Len(FontPath$) - 3) + "FOT"

    Ret% = CreateScalableFontResource(0, FontRes$, FontFileName$, WindSysDir$)
    Ret% = AddFontResource(FontRes$)
    Res& = SendMessage(HWND_BROADCAST, WM_FONTCHANGE, 0, 0)
    Ret% = WriteProfileString("fonts", FontName + " (TrueType)", FontRes$)
End Sub
