unit MLB_Fix;
{ FIXED CODE & DATA SEGMENTS FOR MIDLPBK.DLL}

{$C FIXED PRELOAD PERMANENT}

interface

uses WinTypes,
     MMSystem;

const
      gNumPorts = 4;
      gNumInClients = 4;
      gNumOutClients = 10;

Type
    { MIDI input and output device open information structure }
    {  One Instance per in-client and out-client }
    TPORTALLOC = record
     dwCallback,           { client's callback }
     dwInstance : LongInt; { client's instance data }
     h_Midi : THandle;
     dwFlags : LongInt;
    end;
    PPORTALLOC = ^TPORTALLOC;

    { midi*Open parameter structure }
    TMIDIOPENDESC = record
     hMidi : THandle;
     dwCallback,
     dwInstance : LongInt; { app's private information }
    end;
    PMIDIOPENDESC = ^TMIDIOPENDESC;

    { Local Data for each MIDI input port}
    TMIDIINMSGCLIENT = record
     bStarted : boolean;

     fSysEx: Boolean;
     bStatus: Byte ;

     bBytesLeft: Byte;
     bBytePos: Byte;

     dwShortMsg: LongInt;
     dwMsgTime: LongInt;
     dwRefTime: LongInt;

     dwCurData: LongInt;
     lpmhQueue: PMIDIHDR;
    end;
    PMIDIINMSGCLIENT = ^TMIDIINMSGCLIENT;

var
    { global data for each input }
    gMidiInClient :          Array [ 0..gNumPorts-1,0..gNumInClients-1 ] of TPORTALLOC;
    gMIMC :                  Array [ 0..gNumPorts-1,0..gNumInClients-1 ] of TMIDIINMSGCLIENT;

    { global data for each output }
    gMidiOutClient :         Array [ 0..gNumPorts-1,0..gNumOutClients-1 ] of TPORTALLOC;
    gbMidiOutCurrentStatus : Array [ 0..gNumPorts-1,0..gNumOutClients-1 ] of Byte;

    gActivePorts : integer;

function modMessage(id:WORD; msg: WORD; dwUser, dwparam1, dwparam2:LongInt):Longint;export;
procedure MsgCallBack(var midiclient:TPORTALLOC;msg: WORD; dwparam1, dwparam2:LongInt);

implementation
uses WinProcs,MLB_nfix; { only for modGetDevCaps }


procedure AHIncr; far; external 'KERNEL' index 114;
function HugePointer(p:Pointer;o:LongInt):Pointer; assembler;
asm
   mov cx,o.Word[0]
   add cx,p.Word[0]
   mov bx,o.Word[2]
   adc bx,0
   mov ax,offset AHIncr
   mul bx
   add ax,p.WORD[2]
   mov dx,ax
   mov ax,cx
end;

{ -------------------------------------------------------------------------
  COMMON MIDI PART
  -------------------------------------------------------------------------  }
Type CBProc=procedure(h_Midi:THandle;wMsg:WORD;dwInstance,dwParam1,dwParam2:Longint);


{ -------------------------------------------------------------------------
  MsgCallBack : application callbac, send MM_MOIM messages
  -------------------------------------------------------------------------  }
procedure MsgCallBack(var midiclient:TPORTALLOC;msg: WORD; dwparam1, dwparam2:LongInt);
{ MMSYSTEM - Driver Functions }
      const
           DCB_NOSWITCH   = $0008; { don't switch stacks for callback }
           DCB_TYPEMASK   = $0007; { callback type mask }
           DCB_NULL       = $0000; { unknown callback type }

{ flags for wFlags parameter of DriverCallback() }
           DCB_WINDOW     = $0001; { dwCallback is a HWND }
           DCB_TASK       = $0002; { dwCallback is a HTASK }
           DCB_FUNCTION   = $0003; { dwCallback is a FARPROC }
begin
   with midiclient do begin
      if (dwCallback<>0) and (h_Midi<>0) then
         case (HiWord(dwFlags) and DCB_TYPEMASK) of
           DCB_FUNCTION: CBProc(dwCallback)(h_Midi,msg,dwInstance,dwparam1,dwparam2);
           DCB_WINDOW: PostMessage(HWnd(dwCallback),msg,h_Midi,dwparam1);
           DCB_TASK  : PostAppMessage(THandle(dwCallback),msg,h_Midi,dwparam1);
         end;
   end;
end;

{ -------------------------------------------------------------------------
  midiMsgLen : return length of this MIDI msg
  -------------------------------------------------------------------------  }
function midiMsgLen(msg:Byte):WORD;
begin
    MidiMsgLen:=0;
    if Msg >= $80 then
       if Msg >= $F0 then
           if (msg<$F1) or (msg>=$F4) then
               MidiMsgLen := 1
           else
               if msg=$F2 then
                  MidiMsgLen := 3
               else
                  MidiMsgLen:=2
       else
           if (msg<$C0) or (msg>=$E0) then
               MidiMsgLen := 3
           else
               MidiMsgLen := 2;
end;

{ -------------------------------------------------------------------------
  midBufferWrite : send SYSEX Buffer back
  -------------------------------------------------------------------------  }
procedure midBufferWrite(id,cl:integer; bByte:Byte );
VAR lpmh : PMIDIHDR;
BEGIN
  with gMIMC[id,cl] do
  begin
    { if no buffers, nothing happens }
    lpmh := lpmhQueue;
    if lpmh <> nil then
    BEGIN
        { if the long message is being terminated, only save eox byte }
        if (bByte < $80) or (bByte = $F7) or (bByte = $F0) then
        begin
            { write the data into the long message buffer }
            PByte(HugePointer(lpmh^.lpData,dwCurData))^ := bByte;
            inc(dwCurData);
            { if !(end of sysex or buffer full), return }
            if (bByte = $F7) or (dwCurData >= lpmh^.dwBufferLength) then
            begin
                { send client back the data buffer }
                lpmhQueue := lpmhQueue^.lpNext;
                lpmh^.dwBytesRecorded := dwCurData;
                dwCurData := 0;
                lpmh^.dwFlags := lpmh^.dwFlags or MHDR_DONE;
                lpmh^.dwFlags := lpmh^.dwFlags and (not MHDR_INQUEUE);
                MsgCallBack(gMidiInClient[id,cl],MIM_LONGDATA,LongInt(lpmh),dwMsgTime);
            end;
        end;
    END;
  end;
END;


TYPE    ByteArray = array [0..32767] of Byte;
    PByteArray = ^ByteArray;
{ -------------------------------------------------------------------------
  midByteRec - Receive next MIDI byte
               This is the heart of Midi Input
  ------------------------------------------------------------------------- }
procedure midByteRec(id,cl:integer;bByte:BYTE );
VAR dwCurTime:LongInt;

BEGIN
  with gMIMC[id,cl] do
  begin
    if not bStarted then exit;

    { time byte received }
    dwCurTime := timeGetTime - dwRefTime;

    {  System Real-Time Messages (SRTM) range from 0xF8 to 0xFF.
     *
     *  There are no data bytes attached to SRTM status bytes and
     *  they can appear _anywhere_ in the data stream.  They should
     *  affect _nothing_.  They do not terminate SysEx, do not reset
     *  running status, nothing.  Just send them up.
     }
    if bByte >= $F8 then begin
       MsgCallBack(gMidiInClient[id,cl],MIM_DATA, LongInt(bByte), dwCurTime);
       end
    { if the high bit is set (>= 0x80), then it is a status byte }
    else if ( bByte >= $80 ) then
    begin
        {  SysEx, if going, can be terminated by either an End of
         *  Exclusion (EOX, 0xF7) or any other Status Byte (except real-
         *  time messages which are handled above).  An EOX _should_
         *  always be sent at the end of a SysEx message, but any status
         *  byte is legal.
         }
        if fSysEx then
        begin
            { bStatus should never be set if in SysEx }
            { reset SysEx flag--it has been terminated }
            fSysEx := FALSE;

            { post sysex data back to caller }
            midBufferWrite(id,cl,bByte);

            {  If this was an EOX, then we are done.  If it is a different
             *  status byte, then we have terminated the SysEx, but we still
             *  need to process the new status byte.
             }
            if ( bByte = $F7 {MIDI_SYSEX_EOX} ) then
                exit;
        end;

        {  If there is a partially recorded short message, then post
         *  it with an error (it's considered garbage).  The first byte
         *  of the message is non-zero if partly recorded.
         }
        if ( LoByte(LoWord(dwShortMsg))<>0 ) then
        begin
            MsgCallBack(gMidiInClient[id,cl],MIM_ERROR,dwShortMsg,dwMsgTime);
            dwShortMsg := 0;
        end;

        {  The message time is always the time at which the 'status' byte
         *  for the message was received.  So set this.
         }
        dwMsgTime := dwCurTime;

        {  There are two different types of messages that bByte could
         *  represent: channel messages (0x80 - 0xE0) or system messages
         *  (0xF0 - 0xFF).  We already took care of the system 'real-time
         *  messages' (0xF8 - 0xFF) above, so we don't need to check for
         *  them.
         *
         *  So is it a 'system' status byte or a 'channel' status byte?
         }
        if ( bByte >= $F0 ) then
        BEGIN
            { running status applies to channel messages only }
            bStatus := 0;

            case bByte of
                $F0 : { MIDI_SYSEX_BEGIN }
                    BEGIN
                       fSysEx := TRUE;
                       midBufferWrite(id,cl,bByte);
                    END;

                $F7 : { MIDI_SYSEX_EOX }
                    BEGIN
                       bBytePos := 0;
                       MsgCallBack(gMidiInClient[id,cl],MIM_ERROR,LongInt(bByte),dwMsgTime);
                    END;
                $F4,$F5,$F6 : { MIDI_COMMON_UNDEFINED_F4, MIDI_COMMON_UNDEFINED_F5, MIDI_COMMON_TUNE_REQUEST }
                    BEGIN
                       MsgCallBack(gMidiInClient[id,cl],MIM_DATA,LongInt(bByte),dwMsgTime);
                       bBytePos := 0;
                    END;

                $F1,$F3 : { MIDI_COMMON_TCQF, MIDI_COMMON_SONG_SELECT }
                    BEGIN
                    dwShortMsg := bByte;
                    bBytesLeft := 1;
                    bBytePos := 1;
                    END;

                $F2: { MIDI_COMMON_SONG_POSITION }
                    BEGIN
                    dwShortMsg := bByte;
                    bBytesLeft := 2;
                    bBytePos := 1;
                    END;
            end;
        end

        { it is a 'channel' voice status byte (0x80 - 0xE0) }
        else
        begin
            { running status applies to channel messages only }
            bStatus := bByte;
            dwShortMsg := bByte;
            bBytePos := 1;

            { convert channel status byte to number of bytes remaining }
            bBytesLeft := MidiMsgLen(bByte) - 1;
        end;

    end { if (bByte == status byte) }

    {  bByte is not a status byte (it is <= 0x7F and is considered a data
     *  byte).
     }
    else
    begin
        { if in SysEx receive mode, then record byte in long message }
        if ( fSysEx ) then
            { write in long message buffer }
            midBufferWrite(id,cl,bByte )
        { else if it's an expected data byte for a short message }
        else if ( bBytePos <> 0 ) then
        begin
            { if running status }
            if ( bStatus<>0 ) and (bBytePos = 1) then
            begin
                { setup for next short message }
                dwShortMsg := bStatus;
                dwMsgTime := dwCurTime;
            end;

            PByteArray(@dwShortMsg)^[ bBytePos ] := bByte;
            Inc(bBytePos);
            Dec(bBytesLeft);
            if ( bBytesLeft = 0 ) then
            begin
                MsgCallBack(gMidiInClient[id,cl],MIM_DATA,dwShortMsg,dwMsgTime);

                dwShortMsg := 0;

                if ( bStatus <> 0 ) then
                begin
                    bBytesLeft := bBytePos - 1;
                    bBytePos := 1;
                end
                else
                    bBytePos := 0;
            end;
        end

        else
            MsgCallBack(gMidiInClient[id,cl],MIM_ERROR,LongInt(bByte),dwMsgTime);
    end;
  end;
end;


procedure SendMidiByteToInput(id:integer;bByte:BYTE);
Var cl: integer;
begin

   for cl:=0 to gNumInClients-1 do
      if gMidiInClient[id,cl].h_Midi<>0 then
         midByteRec(id,cl,bByte);
end;

procedure modSendData( id:integer; var vMidiOutCurrentStatus:Byte; lpBuf:PChar; dwLength:LongInt );
var bByte:Byte;
    dwCur:Longint;
begin
   for dwCur:=0 to dwLength-1 do
   begin
        bByte := PByte(HugePointer(lpBuf,dwCur))^;

        if (bByte >= $80) and (bByte < $F8) then
           if bByte < $F0 then
              vMidiOutCurrentStatus := bByte
           else
              vMidiOutCurrentStatus := 0;

        SendMidiByteToInput(id, bByte );
   end;
end;

function modSendLongData( id,cl: integer; lpHdr:PMIDIHDR):LongInt;
BEGIN
   modSendData( id, gbMidiOutCurrentStatus[id,cl], lpHdr^.lpData, lpHdr^.dwBufferLength );
   { set the done bit }
   lpHdr^.dwFlags := lpHdr^.dwFlags or MHDR_DONE;

   { notify client }
   MsgCallBack(gMidiOutClient[id,cl], MOM_DONE, LongInt(lpHdr), 0);
   modSendLongData := 0;
end;


{ send Msg to input - expand running status }
procedure modSendShortMsg(id,cl:integer;msg:LongInt);
var bStatus:BYTE;
    n,nbytes : WORD;

BEGIN
   { expand running status }
   bStatus := LoByte(LoWord(msg));
   if bStatus < $80 then
      msg := (msg shl 8)+gbMidiOutCurrentStatus[id,cl]
   else if bStatus < $F0 then
      gbMidiOutCurrentStatus[id,cl]:=bStatus;
   nbytes := midiMsgLen(msg);
   for n:=0 to nbytes-1 do SendMidiByteToInput(id,PByteArray(@msg)^[n]);
END;


const wMidiOutEntered : array[0..gNumports-1]of integer = (0,0,0,0);
const wMidiOutLongEntered : integer = 0;
function modMessage(id:WORD; msg: WORD; dwUser, dwparam1, dwparam2:LongInt):Longint;
const { from MMDDK.INC}
     MODM_GETNUMDEVS     =    1;
     MODM_GETDEVCAPS     =    2;
     MODM_OPEN           =    3;
     MODM_CLOSE          =    4;
     MODM_PREPARE        =    5;
     MODM_UNPREPARE      =    6;
     MODM_DATA           =    7;
     MODM_LONGDATA       =    8;
     MODM_RESET          =    9;
     MODM_GETVOLUME      =   10;
     MODM_SETVOLUME      =   11;
     MODM_CACHEPATCHES   =   12;
     MODM_CACHEDRUMPATCHES = 13;

var cl:integer;

BEGIN
     if (id >= gActivePorts) then begin
        modMessage := MMSYSERR_BADDEVICEID;
        exit;
     end;
     ModMessage := 0; { some fewer BEGINs req'd so}
     case msg of
     MODM_GETNUMDEVS:
          modMessage := gActivePorts;
     MODM_GETDEVCAPS:
         modGetDevCaps(id,Pointer(dwparam1)^,WORD(dwparam2));
     MODM_OPEN:
          BEGIN
            modMessage:=MMSYSERR_ALLOCATED;
            for cl:=0 to gNumOutClients-1 do begin
              if gMidiOutClient[id,cl].h_Midi=0 then begin
                 { use this port }
                 PLongInt(dwUser)^:=cl;
                 { save client information }
                 with gMidiOutClient[id,cl] do begin
                    dwCallback := PMIDIOPENDESC(dwParam1)^.dwCallback;
                    dwInstance := PMIDIOPENDESC(dwParam1)^.dwInstance;
                    h_Midi     := PMIDIOPENDESC(dwParam1)^.hMidi;
                    dwFlags    := dwParam2;
                    { !!! reset running status }
                    gbMidiOutCurrentStatus[id,cl] := 0;
                    MsgCallBack(gMidiOutClient[id,cl],MOM_OPEN,0,0);
                 end;
                 modMessage:=MMSYSERR_NOERROR;
                 break;
              end;
            end;
          END;
     MODM_CLOSE:
          BEGIN
             cl:=dwUser;
             MsgCallBack(gMidiOutClient[id,cl],MOM_CLOSE,0,0);
             gMidiOutClient[id,cl].h_Midi := 0; { Mark as closed }
          END;
{
     MODM_PREPARE:
     MODM_UNPREPARE:
}
     MODM_DATA:
          BEGIN
            { make sure we're not being reentered }
            Inc(wMidiOutEntered[id]);

            if ( wMidiOutEntered[id] > 1 ) then
                  ModMessage := MIDIERR_NOTREADY
            else
                  modSendShortMsg( id,dwUser,dwParam1 );

            Dec(wMidiOutEntered[id]);
          END;
     MODM_LONGDATA:
          BEGIN
            { make sure we're not being reentered }
            Inc(wMidiOutEntered[id]);

            if ( wMidiOutEntered[id] > 1 ) then
                    ModMessage := MIDIERR_NOTREADY
            else
                    modMessage := modSendLongData( id,dwUser,PMIDIHDR(dwParam1) );
            Dec(wMidiOutEntered[id]);
          END;
     MODM_RESET: { Nothing to to}
                BEGIN END;
{
     MODM_GETVOLUME:
     MODM_SETVOLUME:
     MODM_CACHEPATCHES:
     MODM_CACHEDRUMPATCHES:
}
     else
          modMessage := MMSYSERR_NOTSUPPORTED;
     end;
END;

{ -------------------------------------------------------------------------
  END OF MIDI OUTPUT PART
  ------------------------------------------------------------------------- }



begin
end.

