(*
{$A-,B-,D+,F-,G+,I-,K-,L+,N-,P-,Q-,R-,S-,T-,V+,W-,X+,Y+}
*)
{$M 8192,4096}

{ "MIDI cable" Windows application written in Turbo Pascal }

program hwmdcabl;
{$D Hubi's MIDI-Cable}

{$R hwmdcabl}

uses WinTypes, WinProcs, Win31, ShellApi, Strings, MMSystem, HWMD, Ctl3d;

const
  AppName :PChar = 'HWMidiCable';
  WName   :PChar = 'Hubi''s MIDI cable';
const
  idm_About = 100;
{  idm_ReOpen = 101;
  idm_Reset = 102;}
  idm_input_none = 200;
  idm_output_none = 300;

  Syx_Nums = 3;
  Syx_Size = 1024;
var
  ghicon : HIcon;
  idm_past_midiin : Word;
  idm_past_midiout : Word;



const  giMidiOut : integer=0;  { 0=None ; 1=MIDI_MAPPER, 2=first port ... }
       giMidiIn  : integer=0;  { 0=None ; 1=first port ...}

       p_thru : Pointer = nil;
       cb_thru : PCBThru = nil;

       hSysMenu : HMENU = 0;

(* ======== FUNCTION OVERVIEW

procedure debugprintf(fmt:PChar;var param);
function Min(a,b:integer):integer;
function Max(a,b:integer):integer;
function About(Dialog: HWnd; Message, WParam: Word;
procedure DoAbout(Window:HWnd);
function About(Dialog: HWnd; Message, WParam: Word;
procedure AllocThruData;
procedure FreeThruData;
function GetMidiHeader(i:word):PMIDIHDR;
procedure WriteInifile;forward;
function WindowProc(Window: HWnd; Message, WParam: Word;
  procedure SetupSysMenu;
  procedure Check_giMidiRange;
  procedure PaintIcon;
  procedure SetWndTxt;
  procedure CloseMidiIn;
  procedure CloseMidiOut;
  procedure SetMidiInOut(new_in:integer; new_out:integer);
  procedure ChangeOutput;
  procedure ChangeInput;
    procedure ReadIniFile;
    procedure WriteIniFile;
procedure WinMain;
    procedure ProcessCommandLine;
       function ScanInt(pstring:PChar;var n:integer):boolean;

   ======== *)



{$IFDEF DEBUG}
procedure debugprintf(fmt:PChar;var param);
var buf:array[0..63]of char;
begin
   wvsprintf(buf,fmt,param);
   OutputDebugString(Buf);
end;
{$ENDIF}

function Min(a,b:integer):integer;
begin
  if a<b then
     Min := a
  else
     Min := b
end;

function Max(a,b:integer):integer;
begin
  if a>b then
     Max := a
  else
     Max := b
end;

function About(Dialog: HWnd; Message, WParam: Word;
  LParam: Longint): Bool; export; forward;

const reenter:integer=0;
procedure DoAbout(Window:HWnd);
var AboutProc: TFarProc;
begin
    AboutProc := MakeProcInstance(@About, HInstance);
    DialogBox(HInstance, PChar(1), Window, AboutProc);
    FreeProcInstance(AboutProc);
End;

function About(Dialog: HWnd; Message, WParam: Word;
  LParam: Longint): Bool;
const id_notok=100;
      id_more=101;
begin
  About := True;
  case Message of
    wm_InitDialog:
      Exit;
    wm_Command:
      if (WParam = id_Ok) or (WParam = id_Cancel) then
      begin
        EndDialog(Dialog, 1);
        Exit;
      end else
      if (WParam = id_more) then begin
         inc(Reenter);
         if Reenter>8 then
            MessageBox(Dialog,'Stack Back','He !',MB_OK or MB_ICONSTOP)
         else
            DoAbout(Dialog);
         dec(Reenter);
         EndDialog(Dialog,1);
         exit;
      end else
      if (WParam = id_notok) then begin
            MessageBox(Dialog,'It is not OK to be not OK','Hubi says:',MB_OK or MB_ICONEXCLAMATION)
      end;
  end;
  About := False;
end;

procedure AllocThruData;
var bsiz:LongInt;
    blocksiz:LongInt;
    i:Integer;
    midi_header:PMIDIHDR;
begin
   if p_thru=nil then begin
      bsiz := sizeof(TCBThru);
      blocksiz:=SizeOf(TMIDIHDR)+Syx_Size;
      inc(bsiz,Syx_Nums*blocksiz);
      p_thru:=GlobalAllocPtr(GMEM_MOVEABLE or GMEM_SHARE or GMEM_ZEROINIT, bsiz );
      cb_thru := p_thru;
      for i:=0 to Syx_Nums-1 do begin
         with PMIDIHDR(LongInt(p_thru)+sizeof(TCBTHRU)+i*blocksiz)^ do begin
            lpData := Pointer(LongInt(p_thru)+sizeof(TCBTHRU)+i*blocksiz+sizeof(TMIDIHDR));
            dwBufferLength := Syx_Size;
            dwUser := LongInt(cb_thru);
         end;
      end;
   end;
end;

procedure FreeThruData;
begin
   GlobalFreePtr(p_thru);
   p_thru:=nil;
   cb_thru := nil;
end;

function GetMidiHeader(i:word):PMIDIHDR;
begin
   GetMidiHeader:=nil;
   if (p_thru<>nil)and(i<Syx_Nums) then
      GetMidiHeader:=PMIDIHDR(LongInt(p_thru)+sizeof(TCBTHRU)+i*(SizeOf(TMIDIHDR)+Syx_Size));
end;


procedure WriteInifile;forward;

function WindowProc(Window: HWnd; Message, WParam: Word;
  LParam: Longint): Longint; export;
var
  i:Word;

  { add available Midi Ports to System Menu }
  procedure SetupSysMenu;
  VAR h_pmenu : HMENU;
  begin
    h_pmenu := GetSystemMenu(Window,False);
    hSysMenu:=h_pmenu;
    if (h_pmenu=0) then Exit;
    AppendMenu(h_pmenu,MF_SEPARATOR,0,nil);
    AppendMenu(h_pmenu,MF_STRING,idm_about,'About...');
{    AppendMenu(h_pmenu,MF_STRING,idm_reOpen,'Re-Open MIDI');}
{    AppendMenu(h_pmenu,MF_STRING,idm_reset,'Reset MIDI');}

    { Append MIDI Inputs }
    AppendMenu(h_pmenu,MF_STRING or MF_MENUBARBREAK,idm_input_none,'&0 No Input');
    idm_past_midiin:=AppendMidiInMenus(h_pmenu,idm_input_none+1);

    { Append MIDI Outputs }
    AppendMenu(h_pmenu,MF_STRING or MF_MENUBARBREAK,idm_output_none,'&0 No Output');
    idm_past_midiout:=AppendMidiOutMenus(h_pmenu,idm_output_none+1);

  end;

  procedure Check_giMidiRange;
  begin
     giMidiIn:=Min(midiInGetNumDevs+menu_in_offs-1,Max(0,giMidiIn));
     giMidiOut:=Min(midiOutGetNumDevs+menu_out_offs-1,Max(0,giMidiOut));
  end;

  procedure PaintIcon;
  var ps:  TPaintStruct;
  begin
         BeginPaint(Window, ps);
         { Paint the desktop window background }
         DefWindowProc(Window, WM_ICONERASEBKGND, ps.hdc, 0);
         { Draw the icon on top of it }
         DrawIcon(ps.hdc, 0,0, ghIcon);
         EndPaint(Window, ps);
  end;


  procedure SetWndTxt;
  var buf:array[0..2*MAXPNAMELEN+5]of char;
      i:Word;
  const Arrow3:Array[0..2]of Char=(' ','*',' ');
  begin
    if (giMidiOut=0)and(giMidiIn=0) then
      SetWindowText(Window,WName)
    else begin
      GetMenuString(hsysmenu,idm_input_none+giMidiIn,buf,MAXPNAMELEN,MF_BYCOMMAND);
      {StrCat(buf,#10#13'to'#10#13#0);}
      Move(buf[3],buf[0],MAXPNAMELEN-3);
      i:=StrLen(buf);
      GetMenuString(hsysmenu,idm_output_none+giMidiOut,@(buf[i]),MAXPNAMELEN,MF_BYCOMMAND);
      Move(Arrow3,buf[i],3);{overwrite Menu Shortcut}
      SetWindowText(Window,buf);
    end;
  end;

  procedure CloseMidiIn;
  var i:integer;
  begin
    if (cb_thru^.hMdIn<>0) then begin
       MidiInReset(cb_thru^.hMdIn);
{       While (NumberOfBuffers>=1) do WaitFor(MM_MIM_LONGDATA,500);}
       MidiInClose(cb_thru^.hMdIn);
       cb_thru^.hMdIn:=0;
    end;
    giMidiIn:=0;
  end;

  procedure CloseMidiOut;
  begin

{$IFDEF DEBUG}
	debugprintf('CloseMidiOut %4X'#13#10,cb_thru^.hMdOut);
{$ENDIF}
    if (cb_thru^.hMdOut<>0) then begin
       MidiOutReset(cb_thru^.hMdOut);
       MidiOutClose(cb_thru^.hMdOut);
       cb_thru^.hMdOut:=0;
    end;
    giMidiOut:=0;
  end;

  procedure SetMidiInOut(new_in:integer; new_out:integer);
  var i:integer;
      midi_header:PMIDIHDR;
      err:word;
  begin
     CloseMidiIn;
     CloseMidiOut;

     err:=midiOutOpen(@(cb_thru^.hMdOut),new_out-menu_out_offs,Longint(@MidiCBQuickThru),LongInt(cb_thru),CALLBACK_FUNCTION);
     if err=0 then
        giMidiOut := new_out
     else begin
        if (new_out<>0) then begin
           ModErrorMessageBox(window,err);
        end;
        giMidiOut:=0;
     end;

    err:=midiInOpen(@(cb_thru^.hMdIn),new_in-menu_in_offs,Longint(@MidiCBQuickThru),LongInt(cb_thru),CALLBACK_FUNCTION);
    if err=0 then
    begin
       giMidiIn:=new_in;
       for i:=1 to Syx_Nums do begin
          midi_header:=GetMidiHeader(i-1);
          if (midi_header <> nil) then begin
             midi_header^.dwUser:= LongInt(cb_thru);
             if midiInPrepareHeader(cb_thru^.hMdIn,midi_header,SizeOf(TMIDIHDR))=0 then
                if MidiInAddBuffer(cb_thru^.hMdIn,midi_header,SizeOf(TMIDIHDR))<>0
                then midiInUnPrepareHeader(cb_thru^.hMdIn,midi_header,SizeOf(TMIDIHDR));
          end;
       end;
       cb_thru^.pLastBuf:=midi_header;
       midiInStart(cb_thru^.hMdIn);
    end else
      if (new_in<>0) then MidErrorMessageBox(window,err);
  end;

  procedure ChangeOutput;
  begin
    CheckMenuItem(hsysmenu,idm_output_none+giMidiOut ,MF_BYCOMMAND or MF_UNCHECKED);
    SetMidiInOut(giMidiIn,WParam - idm_output_none);
    CheckMenuItem(hsysmenu,idm_output_none+giMidiOut ,MF_BYCOMMAND or MF_CHECKED);
    SetWndTxt;
  end;

  procedure ChangeInput;
  begin
    CheckMenuItem(hsysmenu,idm_input_none+giMidiIn ,MF_BYCOMMAND or MF_UNCHECKED);
    SetMidiInOut(WParam - idm_input_none,giMidiOut);
    CheckMenuItem(hsysmenu,idm_input_none+giMidiIn ,MF_BYCOMMAND or MF_CHECKED);
    SetWndTxt;
  end;


begin
  WindowProc := 0;
  case Message of
    WM_CREATE:
      begin
        SetupSysMenu;
        Check_giMidiRange;
        SetMidiInOut(giMidiIn,giMidiOut);
        CheckMenuItem(hsysmenu,idm_input_none+giMidiIn ,MF_BYCOMMAND or MF_CHECKED);
        CheckMenuItem(hsysmenu,idm_output_none+giMidiOut ,MF_BYCOMMAND or MF_CHECKED);
        SetWndTxt;
      end;
    WM_CLOSE:
      begin
         WriteIniFile;
         CloseMidiIn;
         CloseMidiOut;
      end;
    WM_PAINT:
      if (IsIconic(Window)) then
      begin
         PaintIcon;
         Exit;
      end;
    WM_ERASEBKGND:
      if (IsIconic(Window)) then
      begin
         { Don't erase the background now, since we will do it
           at WM_PAINT time when we paint our own icon... }
         WindowProc := LongInt(TRUE);
         Exit;
      end;
   WM_QUERYDRAGICON:
      begin
        WindowProc := ghIcon;
        Exit;
      end;
    wm_Command:
      if WParam = idm_About then
      begin
        DoAbout(Window);
        Exit;
      end;
    wm_Destroy:
      begin
        PostQuitMessage(0);
        Exit;
      end;
    wm_QueryOpen:
      begin
        WindowProc:=0;
        Exit;
      end;
    wm_sysCommand:
      if (WParam >= idm_output_none) and (WParam < idm_past_midiout) then
      begin
        ChangeOutput;
        Exit;
      end
      else if (WParam >= idm_input_none) and (WParam < idm_past_midiin) then
      begin
        ChangeInput;
        Exit;
      end
      else if WParam=idm_About then
      begin
        DoAbout(Window);
        Exit;
      end
(*      else if WParam=idm_Reset then
      begin
        if cb_thru^.hMdOut<>0 then MidiOutReset(cb_thru^.hMdOut);
        Exit;
      end *)
(*      else if WParam=idm_ReOpen then
      begin
        SetMidiInOut(giMidiIn,giMidiOut);
        Exit;
      end*)
      ;
  end;
  WindowProc := DefWindowProc(Window, Message, WParam, LParam)
end;

const szIniInput  : PChar = 'Input';
      szIniOutput : PChar = 'Output';

procedure ReadIniFile;
begin
   giMidiIn  := GetProfileInt(WName, szIniInput ,0);
   giMidiOut := GetProfileInt(WName,szIniOutput,0);
end;

procedure WriteIniFile;
var s:Array [0..11]of Char;
begin
   wvsprintf(s,'%d',giMidiIn);
   WriteProfileString(WName,szIniInput,s);
   wvsprintf(s,'%d',giMidiOut);
   WriteProfileString(WName,szIniOutput,s);
end;

procedure WinMain;
var
  Window: HWnd;
  Message: TMsg;
const
  WindowClass: TWndClass = (
    style: 0;
    lpfnWndProc: @WindowProc;
    cbClsExtra: 0;
    cbWndExtra: 0;
    hInstance: 0;
    hIcon: 0;
    hCursor: 0;
    hbrBackground: 0;
    lpszMenuName: nil;
    lpszClassName: nil);

    procedure ProcessCommandLine;
    var s:PChar;

       function ScanInt(pstring:PChar;var n:integer):boolean;
       type ps=^String;
       var code,v:integer;
           slen:Byte;
       begin
          for slen:=1 to 16 do if not(pstring[slen] in ['0'..'9','-','+']) then break;
          pstring[0]:=Chr(slen-1);
          Val(ps(@pstring[0])^,v,code);
          if code=0 then n:=v;
          ScanInt:=code=0;
       end;

    begin
       s := StrPos(CmdLine,'IN=');
       if s<>nil then scanInt(@s[2],giMidiIn);

       s := StrPos(CmdLine,'OUT=');
       if s<>nil then scanInt(@s[3],giMidiOut);
    end;

begin
  if HPrevInst = 0 then
  begin
    WindowClass.hInstance := HInstance;
    WindowClass.hIcon := 0 ;
    WindowClass.hCursor := LoadCursor(0, idc_Arrow);
    WindowClass.hbrBackground := GetStockObject(white_Brush);
    WindowClass.lpszClassName:= AppName;
    if not RegisterClass(WindowClass) then Halt(255);
  end;

  ReadIniFile;
  ProcessCommandLine;

  Ctl3dRegister(HInstance);
  Ctl3dAutoSubclass(HInstance);

  AllocThruData;

  Window := CreateWindow(
    AppName,
    Wname,
    ws_OverlappedWindow or ws_minimize,
    cw_UseDefault,
    cw_UseDefault,
    cw_UseDefault,
    cw_UseDefault,
    0,
    0,
    HInstance,
    nil);
  ghIcon := LoadIcon(Hinstance,PChar(1));

  ShowWindow(Window, SW_SHOWMINIMIZED);
  UpdateWindow(Window);

  while GetMessage(Message, 0, 0, 0) do
  begin
    TranslateMessage(Message);
    DispatchMessage(Message);
  end;

  FreeThruData;

  Ctl3dUnregister(HInstance);

  Halt(Message.wParam);
end;

begin
  WinMain;
end.
