(**************************************************)
(*   Unit CTL3D                                   *)
(*                                                *)
(*   for use with CTL3D.DLL from Microsoft        *)
(**************************************************)

unit Ctl3D;

interface

uses WinTypes;

const CTL3D_BUTTONS      = $0001;
      CTL3D_LISTBOXES    = $0002;
      CTL3D_EDITS        = $0004;
      CTL3D_COMBOS       = $0008;
      CTL3D_STATICTEXTS  = $0010;
      CTL3D_STATICFRAMES = $0020;
      CTL3D_ALL          = $ffff;

function Ctl3dGetVer : WORD;
function Ctl3dSubclassDlg(HWindow : HWND; Ctrls : WORD) : bool;
function Ctl3dSubclassCtl(HWindow : HWND) : bool;

function Ctl3dCtlColor(DC : HDC; Color : TColorRef) : HBrush; 		{ARCHAIC, use Ctl3dCtlColorEx}

function Ctl3dEnabled : bool;
function Ctl3dColorChange : bool;
function Ctl3dRegister(Instance : THandle) : bool;
function Ctl3dUnregister(Instance : THandle) : bool;
function Ctl3dAutoSubclass(Instance : THandle) : bool;
function Ctl3dCtlColorEx(Message, wParam : WORD; lParam : LONGINT)

	: HBrush;



implementation

function Ctl3dGetVer;       external 'Ctl3d' index 1;
function Ctl3dSubclassDlg;  external 'Ctl3d' index 2;
function Ctl3dSubclassCtl;  external 'Ctl3d' index 3;
function Ctl3dCtlColor;     external 'Ctl3d' index 4;
function Ctl3dEnabled;      external 'Ctl3d' index 5;
function Ctl3dColorChange;  external 'Ctl3d' index 6;
function Ctl3dRegister;     external 'Ctl3d' index 12;
function Ctl3dUnregister;   external 'Ctl3d' index 13;
function Ctl3dAutoSubclass; external 'Ctl3d' index 16;
function Ctl3dCtlColorEx;   external 'Ctl3d' index 18;
end.
