#define STRICT
#include <windows.h>
#include <windowsx.h>
#include <stdio.h>
#include <stdlib.h>
#include "dlgtst.h"

static char szAppname[]="dlgtst";
static HWND hWindow;
static HINSTANCE hInst;
static DLGPROC lpproc;

BOOL CALLBACK About(HWND hDlg, UINT message, WPARAM wParam, LPARAM lParam)
{
    if (message == WM_INITDIALOG)
	return (TRUE);

    else if (message == WM_COMMAND) {
	switch (wParam) {
	    case IDOK:
		EndDialog(hDlg, TRUE);
		return (TRUE);
	    default:
		return (TRUE);
	}
    }
    return (FALSE);
}

LRESULT CALLBACK WndProc(HWND hWnd, UINT message, WPARAM wParam, LPARAM lParam)
{
    HANDLE hAboutDlg;

    switch (message) {

	case WM_DESTROY:
	    FreeProcInstance((FARPROC)lpproc);
	    PostQuitMessage(0);
	    break;

	case WM_COMMAND:
	    switch (wParam) {
		case IDM_ABOUT:
		    hAboutDlg = CreateDialog(hInst,"ABOUT",hWnd,lpproc);
		    ShowWindow(hAboutDlg, SW_SHOWNORMAL);
		    break;
	    }
	    break;

	default:
	    return (DefWindowProc(hWnd, message, wParam, lParam));
    }
    return (0L);
}

BOOL InitApplication(HINSTANCE hInstance)
{
    WNDCLASS wc;

    wc.style = NULL;
    wc.lpfnWndProc = WndProc;
    wc.cbClsExtra = 0;
    wc.cbWndExtra = 0;
    wc.hInstance = hInstance;
    wc.hIcon = LoadIcon(NULL, IDI_APPLICATION);
    wc.hCursor = LoadCursor(NULL, IDC_ARROW);
    wc.hbrBackground = GetStockObject(WHITE_BRUSH);
    wc.lpszMenuName =  szAppname;
    wc.lpszClassName = szAppname;

    return RegisterClass(&wc);
}

BOOL InitInstance(HINSTANCE hInstance, INT nCmdShow)
{
    hWindow = CreateWindow(
	szAppname,
	"DIALOG TEST",
	WS_OVERLAPPEDWINDOW,
	CW_USEDEFAULT, CW_USEDEFAULT, CW_USEDEFAULT, CW_USEDEFAULT,
	NULL, NULL,
	hInstance,
	NULL);

    if (!hWindow)
	return (NULL);

    lpproc = (DLGPROC) MakeProcInstance((FARPROC) About, hInst);

    ShowWindow(hWindow, nCmdShow);
    UpdateWindow(hWindow);

    return TRUE;
}

INT PASCAL WinMain(
	HINSTANCE hInstance,
	HINSTANCE hPrevInst,
	LPSTR lpszCmdParam,
	INT nCmdShow)
{
    MSG msg;

    hInst = hInstance;

    if (hPrevInst) {
	MessageBox(NULL,"only one instance",NULL,MB_OK);
	return (FALSE);
    }
    if (!InitApplication(hInstance)) {
	MessageBox(NULL,"register class",NULL,MB_OK);
	return (FALSE);
    }
    if (!InitInstance(hInstance, nCmdShow)) {
	MessageBox(NULL,"create window",NULL,MB_OK);
	return (FALSE);
    }

    while (GetMessage(&msg, NULL, 0, 0)) {
	TranslateMessage(&msg);
	DispatchMessage(&msg);
    }
    return msg.wParam;
}
