/*  Project ottest
    Freeman-Teresa Software
    Copyright  1994. All Rights Reserved.

    SUBSYSTEM:    ottest.exe Application
    FILE:         ottstapp.cpp
    AUTHOR:       Kent Tong


    OVERVIEW
    ========
    Source file for implementation of ottestApp (TApplication).      
*/


#include <owl\owlpch.h>
#pragma hdrstop

#include "owl\static.h" 

#include "ottstapp.h"
#include "ttstabtd.h"                        // Definition of about dialog.


#ifndef __OPTTREE_H
#include "opttree.h"
#endif


//{{ottestApp Implementation}}


//
// Build a response table for all messages/commands handled
// by the application.
//
DEFINE_RESPONSE_TABLE1(ottestApp, TApplication)
//{{ottestAppRSP_TBL_BEGIN}}
    EV_COMMAND(CM_HELPABOUT, CmHelpAbout),
    EV_COMMAND(CM_TEST1, CmTest1),
    EV_COMMAND(CM_TEST2, CmTest2),
    EV_COMMAND(CM_TEST3, CmTest3),
    EV_COMMAND(CM_TEST7, CmTest7),
    EV_COMMAND(CM_TEST8, CmTest8),
    EV_COMMAND(CM_TEST6, CmTest6),
    EV_COMMAND(CM_TEST4, CmTest4),
    EV_COMMAND(CM_TEST5, CmTest5),
//{{ottestAppRSP_TBL_END}}
END_RESPONSE_TABLE;


//
// FrameWindow must be derived to override Paint for Preview and Print.
//
class SDIDecFrame : public TDecoratedFrame {
public:
    SDIDecFrame (TWindow *parent, const char far *title, TWindow *clientWnd, BOOL trackMenuSelection = FALSE, TModule *module = 0) :
            TDecoratedFrame(parent, title, clientWnd, trackMenuSelection, module)
      {  }
    ~SDIDecFrame ()
      {  }
};


//////////////////////////////////////////////////////////
// ottestApp
// =====
//
ottestApp::ottestApp () : TApplication("Option Tree Test")
{

    // Common file file flags and filters for Open/Save As dialogs.  Filename and directory are
    // computed in the member functions CmFileOpen, and CmFileSaveAs.
    FileData.Flags = OFN_FILEMUSTEXIST | OFN_HIDEREADONLY | OFN_OVERWRITEPROMPT;
    FileData.SetFilter("All Files (*.*)|*.*|");

    // INSERT>> Your constructor code here.

}


ottestApp::~ottestApp ()
{
    // INSERT>> Your destructor code here.

}


//////////////////////////////////////////////////////////
// ottestApp
// =====
// Application intialization.
//
void ottestApp::InitMainWindow ()
{
    Client = new TWindow(0, "");
    SDIDecFrame *frame = new SDIDecFrame(0, GetName(), Client, TRUE);

    nCmdShow = nCmdShow != SW_SHOWMINIMIZED ? SW_SHOWNORMAL : nCmdShow;

    //
    // Assign ICON w/ this application.
    //
    frame->SetIcon(this, IDI_SDIAPPLICATION);

    //
    // Menu associated with window and accelerator table associated with table.
    //
    frame->AssignMenu(SDI_MENU);
    
    //
    // Associate with the accelerator table.
    //
    frame->Attr.AccelTable = SDI_MENU;


    TStatusBar *sb = new TStatusBar(frame, TGadget::Recessed,
                                    TStatusBar::CapsLock        |
                                    TStatusBar::NumLock         |
                                    TStatusBar::ScrollLock      |
                                    TStatusBar::Overtype);
    frame->Insert(*sb, TDecoratedFrame::Bottom);
    MainWindow = frame;
    EnableBWCC();
    EnableCtl3d();
    EnableCtl3dAutosubclass(1);
}


//////////////////////////////////////////////////////////
// ottestApp
// ===========
// Menu File New command
void ottestApp::CmFileNew ()
{
}


//////////////////////////////////////////////////////////
// ottestApp
// ===========
// Menu File Open command
void ottestApp::CmFileOpen ()
{
    //
    // Display standard Open dialog box to select a file name.
    //
    *FileData.FileName = 0;
    if (Client->CanClose())
        if (TFileOpenDialog(MainWindow, FileData).Execute() == IDOK)
            OpenFile();
}


void ottestApp::OpenFile (const char *fileName)
{
    if (fileName)
        lstrcpy(FileData.FileName, fileName);

}


//////////////////////////////////////////////////////////
// ottestApp
// =====
// Menu File Close command
void ottestApp::CmFileClose ()
{
}


//////////////////////////////////////////////////////////
// ottestApp
// ===========
// Menu Help About ottest.exe command
void ottestApp::CmHelpAbout ()
{
    //
    // Show the modal dialog.
    //
    ottestAboutDlg(MainWindow).Execute();
}


int OwlMain (int , char* [])
{
    ottestApp     App;
    int             result;

    result = App.Run();

    return result;
}

class TMyOptNode:public TOptNode           /* provide a description text field */
{
   public:

   /* for leaf node */
   TMyOptNode(char txt[], int isxcl, int chksti, int enable):TOptNode(txt, isxcl, chksti, enable)
   {
      setdesc(txt);
   }

   /* for branch node */
   TMyOptNode(char txt[], int isxcl, int isexp):TOptNode(txt, isxcl, isexp)
   {
      setdesc(txt);
   }

   char desc[80];

   void setdesc(char descx[])
   {
      lstrcpy(desc, descx);
   }
};

class TMyOptTree:public TOptTree      /* provide our own notification handlers */
{
   public:

   TMyOptTree(TWindow *parent, int isshowdot = 1, int isindinv = 1):TOptTree(parent, isshowdot, isindinv)
   {

   }
   void notifyselchg(TOptNode *p);
};

class TDlgTest1:public TDialog
{
   TOptTree *otc;

   public:

   TDlgTest1(TWindow *parent, TResID id, int cap);

   void SetupWindow();

   void CleanupWindow();
};

class TDlgTest2:public TDialog
{
   TOptTree *otc;

   public:

   TDlgTest2(TWindow *parent, TResID id, int cap);

   void SetupWindow();

   void CleanupWindow();
};

class TDlgTest3:public TDialog
{
   TOptTree *otc;

   public:

   TDlgTest3(TWindow *parent, TResID id, int cap);

   void SetupWindow();

   void CleanupWindow();
};

class TDlgTest4:public TDialog
{
   TOptTree *otc;

   public:

   TDlgTest4(TWindow *parent, TResID id, int cap);

   void SetupWindow();

   void CleanupWindow();
};

/* p is just selected */
void TMyOptTree::notifyselchg(TOptNode *p)
{
   TMyOptNode *q;

   q = (TMyOptNode*)p;
   TWindow dlg(GetParent());
   TWindow desc(dlg.GetDlgItem(102));
   desc.SetWindowText(q->desc);
}

TDlgTest1::TDlgTest1(TWindow *parent, TResID id, int cap):TDialog(parent, id)
{
   TMyOptNode *p;
   TMyOptNode *q;
   TMyOptNode *r;
   TMyOptNode *s;

   if (!cap)
   {
      otc = new TMyOptTree(this, 1);        /* will be deleted by the dlg */

      p = new TMyOptNode("Software Products", 0, 1);
      p->setdesc("All software products available are listed here");
      p->begappendkid();
      {
         q = new TMyOptNode("Lotus 123 for Windows", 0, 0, 1);
         q->setdesc("Spreadsheet program from Lotus Corp.");
         p->appendkid(q);

         q = new TMyOptNode("Microsoft Word",        0, 1, 1);
         q->setdesc("Word Processor from Microsoft");
         p->appendkid(q);

         q = new TMyOptNode("Borland C++",           0, 1, 0);
         q->setdesc("C++ compiler with edge leading C++ features");
         p->appendkid(q);

         q = new TMyOptNode("Choose One Utility", 0, 0);
         q->setdesc("You can choose one of the utilities listed below");
         q->begappendkid();
         {
            r = new TMyOptNode("Visual Calendar",           1, 1, 1);
            r->setdesc("Utility keeping track of your appointments");
            q->appendkid(r);

            r = new TMyOptNode("Norton Desktop", 1, 0);
            r->setdesc("A set of powerful utilities from Symantec");
            r->begappendkid();
            {
               s = new TMyOptNode("Norton Disk Doctor", 0, 0, 1);
               s->setdesc("Program checking and/or fixing your hard disk");
               r->appendkid(s);

               s = new TMyOptNode("Virtual Desktop",    0, 0, 1);
               s->setdesc("Manages your desktop");
               r->appendkid(s);

               s = new TMyOptNode("INI Assistant",      0, 0, 1);
               s->setdesc("Helps you understand the profound Windows INI settings");
               r->appendkid(s);
            }
            r->endappendkid();
            q->appendkid(r);

            r = new TMyOptNode("Business Card for Windows", 1, 0, 1);
            r->setdesc("A simple free form database");
            q->appendkid(r);

            r = new TMyOptNode("MicroHelp Uninstaller",     1, 0, 1);
            r->setdesc("Uninstalls all the nasty Windows applications");
            q->appendkid(r);
         }
         q->endappendkid();
         p->appendkid(q);

         q = new TMyOptNode("Visual C++",        0, 1, 1);
         q->setdesc("C++ compiler from Microsoft");
         p->appendkid(q);
      }
      p->endappendkid();
      otc->begappendroot();
      otc->appendroot(p);
      otc->endappendroot();
   }
   else
   {
      int i;
      int j;
      char b[20];

      otc = new TMyOptTree(this, 1, 0);               /* invalidate as a whole */

      otc->begappendroot();

      for (i = 0; i < 10; i++)
      {
         wsprintf(b, "%5d-%5d", i*1000, (i+1)*1000-1);

         p = new TMyOptNode(b, 0, 0);

         p->begappendkid();

         for (j = 0; j < 1000; j++)
         {
            wsprintf(b, "%5d", i*1000+j);

            q = new TMyOptNode(b, 0, 1, 1);

            p->appendkid(q);
         }
         p->endappendkid();

         otc->appendroot(p);
      }
      otc->endappendroot();
   }
}

void TDlgTest1::SetupWindow()
{
   TDialog::SetupWindow();
   otc->create(102, 101);
   SetWindowText("Test1 - Option Tree");
}

void TDlgTest1::CleanupWindow()
{
   otc->freeallnodes();

   TDialog::CleanupWindow();
}

TDlgTest2::TDlgTest2(TWindow *parent, TResID id, int cap):TDialog(parent, id)
{
   TMyOptNode *q;

   otc = new TMyOptTree(this, 0);        /* will be deleted by the dlg */

   if (!cap)
   {
      otc->begappendroot();

      q = new TMyOptNode("Lotus 123 for Windows",     0, 1, 1);
      q->setdesc("Spreadsheet program from Lotus Corp.");
      otc->appendroot(q);

      q = new TMyOptNode("Microsoft Word",            0, 0, 1);
      q->setdesc("Word Processor from Microsoft");
      otc->appendroot(q);

      q = new TMyOptNode("Borland C++",               0, 0, 1);
      q->setdesc("C++ compiler with edge leading C++ features");
      otc->appendroot(q);

      q = new TMyOptNode("Visual Calendar",           0, 1, 1);
      q->setdesc("Utility keeping track of your appointments");
      otc->appendroot(q);

      q = new TMyOptNode("Business Card for Windows", 0, 0, 1);
      q->setdesc("A simple free form database");
      otc->appendroot(q);

      q = new TMyOptNode("Visual C++",                0, 1, 1);
      q->setdesc("C++ compiler from Microsoft");
      otc->appendroot(q);

      q = new TMyOptNode("Freeman Installer",         0, 0, 1);
      q->setdesc("A powerful install utility from Freeman-Teresa Software");
      otc->appendroot(q);

      q = new TMyOptNode("Adobe PhotoShop",           0, 1, 1);
      q->setdesc("A very popular image processor");
      otc->appendroot(q);

      q = new TMyOptNode("Delphi",                    0, 0, 1);
      q->setdesc("A very high level client-server database development tool");
      otc->appendroot(q);

      q = new TMyOptNode("DOOM",                      0, 1, 1);
      q->setdesc("An exciting 3D action game from ID Software");
      otc->appendroot(q);

      q = new TMyOptNode("PagePlus",                  0, 1, 1);
      q->setdesc("A FREE DTP program");
      otc->appendroot(q);

      q = new TMyOptNode("AusTax",                    0, 0, 1);
      q->setdesc("Helps you reduce your tax payment");
      otc->appendroot(q);

      q = new TMyOptNode("CIM",                       0, 1, 1);
      q->setdesc("CompuServe Information Manager");
      otc->appendroot(q);

      otc->endappendroot();
   }
   else
   {
      int i;
      char b[10];

      otc->begappendroot();

      for (i = 0; i < 10000; i++)
      {
         wsprintf(b, "Node %d", i);
         q = new TMyOptNode(b, 0, 1, 1);
         otc->appendroot(q);
      }
      otc->endappendroot();
   }
}

void TDlgTest2::SetupWindow()
{
   TDialog::SetupWindow();
   otc->create(102, 101);
   SetWindowText("Test2 - Option List");
}

void TDlgTest2::CleanupWindow()
{
   otc->freeallnodes();

   TDialog::CleanupWindow();
}

TDlgTest3::TDlgTest3(TWindow *parent, TResID id, int cap):TDialog(parent, id)
{
   TMyOptNode *p;
   TMyOptNode *q;
   TMyOptNode *r;
   TMyOptNode *s;

   otc = new TMyOptTree(this, 1);        /* will be deleted by the dlg */

   if (!cap)                                                /* default */
   {
      p = new TMyOptNode("Software Products", 0, 1);
      p->setdesc("All software products available are listed here");
      p->begappendkid();
      {
         q = new TMyOptNode("Lotus 123 for Windows", 0, 0, 2);
         q->setdesc("Spreadsheet program from Lotus Corp.");
         p->appendkid(q);

         q = new TMyOptNode("Microsoft Word",        0, 1, 2);
         q->setdesc("Word Processor from Microsoft");
         p->appendkid(q);

         q = new TMyOptNode("Borland C++",           0, 1, 2);
         q->setdesc("C++ compiler with edge leading C++ features");
         p->appendkid(q);

         q = new TMyOptNode("Choose One Utility", 0, 0);
         q->setdesc("You can choose one of the utilities listed below");
         q->begappendkid();
         {
            r = new TMyOptNode("Visual Calendar",           1, 1, 2);
            r->setdesc("Utility keeping track of your appointments");
            q->appendkid(r);

            r = new TMyOptNode("Norton Desktop", 1, 0);
            r->setdesc("A set of powerful utilities from Symantec");
            r->begappendkid();
            {
               s = new TMyOptNode("Norton Disk Doctor", 0, 0, 2);
               s->setdesc("Program checking and/or fixing your hard disk");
               r->appendkid(s);

               s = new TMyOptNode("Virtual Desktop",    0, 0, 2);
               s->setdesc("Manages your desktop");
               r->appendkid(s);

               s = new TMyOptNode("INI Assistant",      0, 0, 2);
               s->setdesc("Helps you understand the profound Windows INI settings");
               r->appendkid(s);
            }
            r->endappendkid();
            q->appendkid(r);

            r = new TMyOptNode("Business Card for Windows", 1, 0, 2);
            r->setdesc("A simple free form database");
            q->appendkid(r);

            r = new TMyOptNode("MicroHelp Uninstaller",     1, 0, 2);
            r->setdesc("Uninstalls all the nasty Windows applications");
            q->appendkid(r);
         }
         q->endappendkid();
         p->appendkid(q);

         q = new TMyOptNode("Visual C++",        0, 1, 2);
         q->setdesc("C++ compiler from Microsoft");
         p->appendkid(q);
      }
      p->endappendkid();
      otc->begappendroot();
      otc->appendroot(p);
      otc->endappendroot();
   }
   else
   {
      int i;
      int j;
      char b[20];

      otc->begappendroot();

      for (i = 0; i < 10; i++)
      {
         wsprintf(b, "%5d-%5d", i*1000, (i+1)*1000-1);

         p = new TMyOptNode(b, 0, 0);

         p->begappendkid();

         for (j = 0; j < 1000; j++)
         {
            wsprintf(b, "%5d", i*1000+j);

            q = new TMyOptNode(b, 0, 1, 2);

            p->appendkid(q);
         }
         p->endappendkid();

         otc->appendroot(p);
      }
      otc->endappendroot();
   }
}

void TDlgTest3::SetupWindow()
{
   TDialog::SetupWindow();
   otc->create(102, 101);
   SetWindowText("Test3 - Tree View");
}

void TDlgTest3::CleanupWindow()
{
   otc->freeallnodes();

   TDialog::CleanupWindow();
}

TDlgTest4::TDlgTest4(TWindow *parent, TResID id, int cap):TDialog(parent, id)
{
   TMyOptNode *q;

   otc = new TMyOptTree(this, 0);

   if (!cap)
   {
      otc->begappendroot();

      q = new TMyOptNode("Lotus 123 for Windows",     0, 0, 2);
      q->setdesc("Spreadsheet program from Lotus Corp.");
      otc->appendroot(q);

      q = new TMyOptNode("Microsoft Word",            0, 0, 2);
      q->setdesc("Word Processor from Microsoft");
      otc->appendroot(q);

      q = new TMyOptNode("Borland C++",               0, 0, 2);
      q->setdesc("C++ compiler with edge leading C++ features");
      otc->appendroot(q);

      q = new TMyOptNode("Visual Calendar",           0, 0, 2);
      q->setdesc("Utility keeping track of your appointments");
      otc->appendroot(q);

      q = new TMyOptNode("Business Card for Windows", 0, 0, 2);
      q->setdesc("A simple free form database");
      otc->appendroot(q);

      q = new TMyOptNode("Visual C++",                0, 0, 2);
      q->setdesc("C++ compiler from Microsoft");
      otc->appendroot(q);

      q = new TMyOptNode("Freeman Installer",         0, 0, 2);
      q->setdesc("A powerful install utility from Freeman-Teresa Software");
      otc->appendroot(q);

      q = new TMyOptNode("Adobe PhotoShop",           0, 0, 2);
      q->setdesc("A very popular image processor");
      otc->appendroot(q);

      q = new TMyOptNode("Delphi",                    0, 0, 2);
      q->setdesc("A very high level client-server database development tool");
      otc->appendroot(q);

      q = new TMyOptNode("DOOM",                      0, 0, 2);
      q->setdesc("An exciting 3D action game from ID Software");
      otc->appendroot(q);

      q = new TMyOptNode("PagePlus",                  0, 0, 2);
      q->setdesc("A FREE DTP program");
      otc->appendroot(q);

      q = new TMyOptNode("AusTax",                    0, 0, 2);
      q->setdesc("Helps you reduce your tax payment");
      otc->appendroot(q);

      q = new TMyOptNode("CIM",                       0, 0, 2);
      q->setdesc("CompuServe Information Manager");
      otc->appendroot(q);

      otc->endappendroot();
   }
   else
   {
      int i;
      char b[10];

      otc->begappendroot();

      for (i = 0; i < 10000; i++)
      {
         wsprintf(b, "Node %d", i);
         q = new TMyOptNode(b, 0, 0, 2);
         otc->appendroot(q);
      }
      otc->endappendroot();
   }
}

void TDlgTest4::SetupWindow()
{
   TDialog::SetupWindow();
   otc->create(102, 101);
   SetWindowText("Test4 - List Box");
}

void TDlgTest4::CleanupWindow()
{
   otc->freeallnodes();

   TDialog::CleanupWindow();
}

void ottestApp::CmTest1 ()
{
    // INSERT>> Your code here.
   TDlgTest1(GetMainWindow(), "dlgtest", 0).Execute();
}


void ottestApp::CmTest2 ()
{
    // INSERT>> Your code here.
   TDlgTest2(GetMainWindow(), "dlgtest", 0).Execute();
}


void ottestApp::CmTest3 ()
{
    // INSERT>> Your code here.
   TDlgTest3(GetMainWindow(), "dlgtest", 0).Execute();

}


void ottestApp::CmTest4 ()
{
    // INSERT>> Your code here.
   TDlgTest4(GetMainWindow(), "dlgtest", 0).Execute();
}


void ottestApp::CmTest5 ()
{
    // INSERT>> Your code here.
   TDlgTest1(GetMainWindow(), "dlgtest", 1).Execute();
}

void ottestApp::CmTest6 ()
{
    // INSERT>> Your code here.
   TDlgTest2(GetMainWindow(), "dlgtest", 1).Execute();
}


void ottestApp::CmTest7 ()
{
    // INSERT>> Your code here.
   TDlgTest3(GetMainWindow(), "dlgtest", 1).Execute();

}


void ottestApp::CmTest8 ()
{
    // INSERT>> Your code here.
   TDlgTest4(GetMainWindow(), "dlgtest", 1).Execute();

}


