Define DosColInitCreate() {
    Print(`Define DosColInit() {
	if (temp^init^col)
		return;
	temp^init^col = 1;
`);
    for (i = 0; i < argc; i += 1) {
        if (i < 8)
            Print(
`	temp^bg^["`><argv[i]><`"] =
`);
        Print(
`	temp^fg^["`><argv[i]><`"] = `><i><`;
	temp^col^[`><i><`] = "`><argv[i]><`";

`); }
    Print(`}
`);
}
DosColInitCreate(black,
                 blue,
                 green,
                 cyan,
                 red,
                 magenta,
                 brown,
                 light grey,
                 dark grey,
                 light blue,
                 light green,
                 light cyan,
                 light red,
                 light magenta,
                 yellow,
                 white)
Define DosColFieldDefine(title, name, row, value)
/*
    generate the code to decode the attribute byte into
    foreground and background, and to create the prompt
    and the foreground and background combo boxes for one row
*/
{
    Print(
`	`><name><`fg = temp^col^[StrToAscii(parm^screen^colour^`><value><`) % 16];
	`><name><`bg = temp^col^[StrToAscii(parm^screen^colour^`><value><`) / 16];
	SdPrompt(scr, `><row><`, 2, "`><title><`");
	SdPrompt(scr, `><row><`,12, ":");
	SdCombo(scr, "`><name><`fg",  1, `><row><`, 14, 18, 18, &`><name><`fg, "temp^fg^", , , , "Lowercase");
	SdPrompt(scr, `><row><`,33, "on");
	SdCombo(scr, "`><name><`bg",  1, `><row><`, 36, 16, 10,  &`><name><`bg, "temp^bg^", , , , "Lowercase");
`);
}
Define DosColFieldValidate(name, value)
/*
    generates the code to validate the colour attribute variable
    using the foreground and background components
*/
{
    Print(
        `if (!temp^col^[temp^fg^[`><name><`fg]])
			cursor = "`><name><`fg";
		else if (!temp^col^[temp^bg^[`><name><`bg]])
			cursor = "`><name><`bg";
		else `);
}
Define DosColFieldUpdate(name, value)
/*
    generates the code to update the colour attribute variable
    using the foreground and background components
*/
{
    Print(
`		
		parm^screen^colour^`><value><` = StrFromAscii(temp^bg^[`><name><`bg] * 16 + temp^fg^[`><name><`fg]);
`);
}
Define DosColScreen(name, title)
/*
    generates the code for a DOS colour screen
*/
{
    rows = (argc - 2) / 3;
 Print(
`Define DosCol`><name><`() {
	DosColInit();
	scr = SdCreate(, -2, -2, `><rows + 4><`, 54, "`><title><`");

`);
    for (row = 0; row < rows; row += 1) {
        DosColFieldDefine(argv[2 + row * 3], 
                          argv[3 + row * 3],
                          row + 1,
                          argv[4 + row * 3]);
Print(`
`);
    }
Print(
`	SdButton(scr, "", 1,	`><rows + 2><`, 13, 10, "OK",     "", 1);
	SdButton(scr, "", 1,	`><rows + 2><`, 30, 10, "Cancel", "", 2);
	while ((cmd = SdEdit(scr, cursor)) == 1) {
		SdUpdate(scr);
		cursor = "";

		`);

    for (row = 0; row < rows; row += 1) {
        DosColFieldValidate(argv[3 + row * 3],
                          argv[4 + row * 3]);
    }
Print(
        ` {};
		if (cursor) {
			MsgWait("DOS Colours", "Invalid colour");
			continue;
		}
		temp^col^modded = 1;
`);

    for (row = 0; row < rows; row += 1) {
        DosColFieldUpdate(argv[3 + row * 3],
                          argv[4 + row * 3]);
    }
Print(
`
		break;
	}
	SdDestroy(scr);
}`);
}
If(0)
    Following statements generate the code for the colour screens, 
    one for area, second for prompt fields and so on.
Endif
DosColScreen(Area, Area Colours,
            Original, o, area^orig,
            Grey,     g, area^grey,
            Focus,    f, area^focus,
            Shadow,   s, area^shadow)

DosColScreen(Prompt, Prompt Colours,
            Grey,       g, prompt^grey,
            Enable,     e, prompt^enable,
            Enable Hi,  eh, prompt^enable^hi)

DosColScreen(Field, Field Colours,
            Grey,       g, field^grey,
            Enable,     e, field^enable,
            Enable Hi,  eh, field^enable^hi,
            Focus,      f, field^focus,
            Focus Hi,   fh, field^focus^hi)

DosColScreen(SelBox, Selection Box Colours,
            Grey,       g, select^grey,
            Enable,     e, select^enable,
            Enable Hi,  eh, select^enable^hi,
            Focus,      f, select^focus,
            Focus Hi,   fh, select^focus^hi)

DosColScreen(Menu, Menu Colours,
            Grey,       g, menu^grey,
            Enable,     e, menu^enable,
            Enable Hi,  eh, menu^enable^hi,
            Focus,      f, menu^focus,
            Focus Hi,   fh, menu^focus^hi)

Define DosCharInit()
/*
    generate the temp variables used for the char combo box
*/
{
    if (temp^init^ch)
        return;
    temp^init^ch = 1;

    for (i = 0; i < 256; i += 1)
        temp^ch^[StrFromAscii(i)] = i;
}
Define DosCharFieldDefine(title, name, row, value)
{
    Print(
`	`><name><`ch = parm^screen^char^`><value><`;
	SdPrompt(scr, `><row><`, 7, "`><title><`");
	SdPrompt(scr, `><row><`,23, ":");
	SdCombo(scr, "`><name><`ch",  1, `><row><`, 25, 10, 22, &`><name><`ch, "temp^ch^");
`);
}
Define DosCharFieldUpdate(name, value)
{
    Print(
`		parm^screen^char^`><value><` = `><name><`ch;
`);
}
Define DosCharScreen(name, title)
{
    rows = (argc - 2) / 3;
Print(
`Define DosChar`><name><`() {
	DosCharInit();
	scr = SdCreate(, -2, -2, `><rows + 4><`, 42, "`><title><`");

`);
    for (row = 0; row < rows; row += 1) {
        DosCharFieldDefine(argv[2 + row * 3], 
                          argv[3 + row * 3],
                          row + 1,
                          argv[4 + row * 3]);
Print(`
`);
    }
Print(
`	SdButton(scr, "", 1,	`><rows + 2><`, 8, 10, "OK",     "", 1);
	SdButton(scr, "", 1,	`><rows + 2><`, 24, 10, "Cancel", "", 2);
	if ((cmd = SdEdit(scr)) == 1) {
		SdUpdate(scr);
		temp^col^modded = 1;

`);

    for (row = 0; row < rows; row += 1) {
        DosCharFieldUpdate(argv[3 + row * 3],
                          argv[4 + row * 3]);
    }
Print(
`
	}
	SdDestroy(scr);
}`);
}
DosCharScreen(Area, Area Characters,
            Original, o, area^orig,
            Fill,     f, area^fill,
            Close,    c, area^close)

DosCharScreen(Border, Border Characters,
            Top Left,       a, area^tlc,
            Top Right,      b, area^trc,
            Top Horiz,      c, area^thl,
            Left Vert,      d, area^lvl,
            Right Vert,     e, area^rvl,
            Bottom Left,    f, area^blc,
            Bottom Right,   g, area^brc,
            Bottom Horiz,   h, area^bhl)

DosCharScreen(BorderFocus, Focus Border Characters,
            Top Left,       a, area^focus^tlc,
            Top Right,      b, area^focus^trc,
            Top Horiz,      c, area^focus^thl,
            Left Vert,      d, area^focus^lvl,
            Right Vert,     e, area^focus^rvl,
            Bottom Left,    f, area^focus^blc,
            Bottom Right,   g, area^focus^brc,
            Bottom Horiz,   h, area^focus^bhl)

DosCharScreen(Button, Button Characters,
            Default Left,   a,  button^def^l,
            Default Right,  b,  button^def^r,
            Default Fill,   c,  button^def^fill,
            Left,           d,  button^l,
            Right,          e,  button^r,
            Fill,           f,  button^fill)

Define DosScreenAttr()
/*
    The main program
*/
{
    SymOpen("temp");
    scr = SdCreate("DosColMenu", 3, 5, 10, 60, "DOS Screen Attributes");

    SdMenu(scr, "main", 1, "Colours",       "c", 120,
                        1, "Characters",    "a", 121,
                        1, "Misc",          "m", 122,
                        1, "Restart",       "r", 123);

    SdPopup(scr, "col", 120, 1, "Area",             "a", 151,
                             1, "Prompt",           "p", 152,
                             1, "Field",            "f", 153,
                             1, "Select Box",       "s", 154,
                             1, "Menu",             "m", 155);

    SdPopup(scr, "ch", 121, 1, "Area",              "a", 171,
                            1, "Border",            "b", 172,
                            1, "Focus Border",      "f", 173,
                            1, "Button",            "u", 174);

    SdPopup(scr, "misc", 122, 1, "Options",         "o", 161,
                              1, "Jim's Pref",      "j", 162);

    temp^col^modded = 0;
    while ((cmd = SdEdit(scr)) > 3) {
        switch (cmd) {
        case 123:
            Signal("");
        case 151:
            DosColArea();
            break;
        case 152:
            DosColPrompt();
            break;
        case 153:
            DosColField();
            break;
        case 154:
            DosColSelBox();
            break;
        case 155:
            DosColMenu();
            break;
        case 161:
            DosScreenOptions();
            break;  
        case 162:
            if (MsgYesNo("DOS Screen Attributes",
                         "Restore Jim's colour preferences ?")) {
                DosScreenJimsPref();
                MsgWait("DOS Screen Attributes", 
                        "Jim's colour preferences restored");
                temp^col^modded = 1;
            }
            break;  
        case 171:
            DosCharArea();
            break;
        case 172:
            DosCharBorder();
            break;
        case 173:
            DosCharBorderFocus();
            break;
        case 174:
            DosCharButton();
            break;
        }
    }
    SdDestroy(scr);
    if (temp^col^modded)
        Signal("Restarting system to initialize selected colours");
    SymClose("temp");
}
Define DosScreenOptions() {
    scr = SdCreate(, -2, -2, 5, 42, "Screen Options");

    SdCheck (scr, "", 1, 1, 7, 16, &parm^screen^option^area^shadow, "Shadow Areas", "s");

    SdButton(scr, "", 1,    3, 8, 10, "OK",     "", 1);
    SdButton(scr, "", 1,    3, 24, 10, "Cancel", "", 2);
    if ((cmd = SdEdit(scr)) == 1) {
        SdUpdate(scr);
        temp^col^modded = 1;
    }
    SdDestroy(scr);
}
Define DosScreenJimsPref() {                // sets to Jims preferences
    pre = "parm^screen^char^area";
    [pre]^orig          = "\xb2";           // fill block
    [pre]^fill          = " ";
    [pre]^close         = "\xfe";

    parm^screen^option^area^shadow  = "s";  // shadow areas

    pre = "parm^screen^char^area";
    [pre]^focus^tlc     = "\xd5";           // border lines
    [pre]^focus^trc     = "\xb8";
    [pre]^focus^thl     = "\xcd";
    [pre]^focus^lvl     = "\xb3";
    [pre]^focus^rvl     = "\xb3";
    [pre]^focus^blc     = "\xc0";
    [pre]^focus^brc     = "\xd9";
    [pre]^focus^bhl     = "\xc4";

    [pre]^tlc           = "\xda";
    [pre]^trc           = "\xbf";
    [pre]^thl           = "\xc4";
    [pre]^lvl           = "\xb3";
    [pre]^rvl           = "\xb3";
    [pre]^blc           = "\xc0";
    [pre]^brc           = "\xd9";
    [pre]^bhl           = "\xc4";

    pre = "parm^screen^char^button";
    [pre]^def^l         = "[";              // button chars the same
    [pre]^def^r         = "]";
    [pre]^def^fill      = " ";
    [pre]^l             = "[";
    [pre]^r             = "]";
    [pre]^fill          = " ";

    pre = "parm^screen^colour^area";
    [pre]^orig          = "\x70";       // area black on white
    [pre]^grey          = "\x78";
    [pre]^focus         = "\x70";
    [pre]^shadow        = "\x08";

    pre = "parm^screen^colour^prompt";
    [pre]^grey          = "\x78";
    [pre]^enable        = "\x70";
    [pre]^enable^hi     = "\x7f";

    pre = "parm^screen^colour^field";
    [pre]^grey          = "\x78";   // field bright white on blue
    [pre]^enable        = "\x17";
    [pre]^enable^hi     = "\x1f";
    [pre]^focus         = "\x1f";
    [pre]^focus^hi      = "\x1f";

    pre = "parm^screen^colour^select";
    [pre]^grey          = "\x78";   // select white on blue
    [pre]^enable        = "\x17";
    [pre]^enable^hi     = "\x71";
    [pre]^focus         = "\x17";
    [pre]^focus^hi      = "\x71";

    pre = "parm^screen^colour^menu";
    [pre]^grey          = "\x18";   // menu white on blue
    [pre]^enable        = "\x17";
    [pre]^enable^hi     = "\x1f";
    [pre]^focus         = "\x71";
    [pre]^focus^hi      = "\x7f";
}
