Define TestProcess() 
/*
    demonstrate the ability to compile and run code on the fly (as they say)
    with the Process intrinsic function.

    Sample input to Expression could be :-
        DateToday() - "4/10/1993"
    This would return the number of days since this comment was first 
    entered.

    Sample input to Process string, or Expression could be :-
        TestMultiEd()
    This will run the multi line edit demonstration.

    Note that as an expression, 
        TestMultiEd 
    and 
        TestMultiEd()
    are different.  The first returns the value of a local variable, which
    is the null string, the second will perform the TestMultiEd function, 
    passing no arguments.
*/
{
    scr = SdCreate(, -1, -1, 13, 72, "Process String Demo");
    rad = "e";              /* variable holds value of radio button */
    SdPrompt(scr, 0,  1, "Enter Expression:");
    SdMultiLine(scr, "exp", 1, 1, 1, 70, 4, &expr, 250, "Caret");
    SdPrompt(scr, 5,  1, "Result :");
    SdMultiLine(scr, "res", 0, 6, 1, 70, 4,, 250);

    SdRadio(scr, "r0", 1, 10, 48, 20, &rad, "Expression", "e", 131);
    SdRadio(scr, "r1", 1, 11, 48, 20, &rad, "Process", "p", 132);

    SdButton(scr, "ok",   1, 11,  8, 10, "OK", "", 1);
    SdButton(scr, "can",  1, 11, 24, 10, "Cancel", "", 2);

    while ((cmd = SdEdit(scr)) != 2 && cmd != 3) {
        SdUpdate(scr);
        switch (cmd) {
        case 1:
            procstr = (rad == "e") ? "Eval(" . expr : expr;
            if (errTxt = Process(procstr, &outstr))
                MsgWait("TestProcess", errTxt);
            SdFieldSet(scr, "res", outstr);
            break;

        case 131:
            SdPrompt(scr, 0,  1, "Enter Expression:");
            break;

        case 132:
            SdPrompt(scr, 0,  1, "Enter String to Process:");
            break;
        }
    }
    SdDestroy(scr);
}
