If(0)
0----+----1----+----2----+----3----+----4----+----5---
                                                        0
  [ ] univ                               [   OK   ]     1
  [ ] mdat                                              2
  [ ] parm                               [ Cancel ]     3
  [ ] data                                              4
                                                        5
  Data Filename : xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx    6
                                                        7
  Output File   : xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx    8
                                                        9
  Block Size    : 9999                                  10
                                                        11
  Report every  : 999  Symbols                          12

Endif
Define UnloadSetup()
{
    glob^table^letter^["univ"] = "u";
    glob^table^letter^["mdat"] = "m";
    glob^table^letter^["parm"] = "p";

    glob^table^name^["u"] = "univ";
    glob^table^name^["m"] = "mdat";
    glob^table^name^["p"] = "parm";
    glob^table^name^["d"] = "data";
}
Define UnloadSymbolsScreen(type, title, 
                           tableLetter, tableName, dmpName, blkSize, repCnt)
/*
    type = 0 for unload, = 1 for load
*/
{
    scr = SdCreate(, -1, -1, type ? 14 : 12, 54, title);
    SdRadio (scr, "rad", 1, 1, 2, 12, &tableLetter, "Univ", "u", 131);
    SdRadio (scr, "", 1, 2, 2, 12, &tableLetter, "Mdat", "m", 131);
    SdRadio (scr, "", 1, 3, 2, 12, &tableLetter, "Parm", "p", 131);
    SdRadio (scr, "", 1, 4, 2, 12, &tableLetter, "Data", "d", 132);
    SdPrompt(scr, 6, 2, "Data Filename");
    SdPrompt(scr, 6,16, ":");
    SdString(scr, "inf",  tableLetter == "d",  6, 18, 33, &tableName, 64);
    SdPrompt(scr, 8, 2, type ? "Input File" : "Output File");
    SdPrompt(scr, 8,16, ":");
    SdString(scr, "out",  1,  8, 18, 33, &dmpName, 64);
    if (type) {
        SdPrompt(scr,10, 2, "Block Size");
        SdPrompt(scr,10,16, ":");
        SdInt   (scr, "bsiz",  1, 10, 18,  4, &blkSize);
        row = 12;
    }
    else
        row = 10;

    SdPrompt(scr,row, 2, "Report every");
    SdPrompt(scr,row,16, ":");
    SdInt   (scr, "rev",  1, row, 18,  3, &repCnt);
    SdPrompt(scr,row,23, "symbols");

    SdButton(scr, "", 1,    1, 41, 10, "OK",     "", 1);
    SdButton(scr, "", 1,    3, 41, 10, "Cancel", "", 2);

    while (1) {
        if ((cmd = SdEdit(scr, cursor)) == 2 || cmd == 3) {
            break;
        }
        else if (cmd == 1) {
            SdUpdate(scr);
            if (!tableLetter) {
                MsgWait(title, "Must choose source Symbol Table");
                cursor = "sym";
            }
            else if (tableLetter == "d" && !tableName) {
                MsgWait(title, "For Data, must specify a Data Filename");
                cursor = "inf";
            }
            else if (!dmpName) {
                MsgWait(title, "Must specify an " . 
                               (type ? "Input" : "Output") . " Filename");
                cursor = "out";
            }
            else {
                break;              /* every thing validates */
            }
        }
        else if (cmd == 131) {
            SdModeSet(scr, 0, "inf");
            cursor = "rad";
        }
        else if (cmd == 132) {
            SdModeSet(scr, 1, cursor = "inf");
            cursor = "rad";
        }
    }
    SdDestroy(scr);
    return cmd;
}
Define UnloadSymbols()
{
    title = "Unload Symbol Table";

    UnloadSetup();

    repCnt = 100;           /* default reporting count */

    while (1) {
        if (UnloadSymbolsScreen(0, title, &tableLetter, &tableName, 
                                &dmpName, &blkSize, &repCnt) != 1)
            return;
        if (!(dmpFile = FileOpen(dmpName, "write"))) {
            MsgWait(title, "Could not open Output File " . dmpName);
            continue;
        }
        table = glob^table^name^[tableLetter];
        if (tableLetter == "d" && SymOpen("data", tableName)) {
            MsgWait(title, "Could not open Symbol Table " . tableName);
            continue;
        }
        break;  
    }
    SymUnload(table, dmpName, , repCnt, &symCnt);
    MsgWait("Unload Symbols " . table, symCnt . " symbols unloaded");
    if (tableLetter == "d")
        Signal("");             // to restart system
}
Define LoadSymbols()
{
    title = "Load Symbol Table";

    UnloadSetup();
    repCnt = 100;           /* default reporting count */
    blkSize = 512;

    while (1) {
        if (UnloadSymbolsScreen(1, title, &tableLetter, &tableName, 
                                &dmpName, &blkSize, &repCnt) != 1)
            return;
        if (!(dmpFile = FileOpen(dmpName, "read"))) {
            MsgWait(title, "Could not open Input File " . dmpName);
            continue;
        }
        FileClose(dmpFile);
        table = glob^table^name^[tableLetter];
        if (tableLetter == "d" && SymOpen("data", tableName, , 8) &&
            SymCreate("data", tableName, "Excl", blkSize, 12)) {
            MsgWait(title, "Could not open or create Symbol Table " . tableName);
            continue;
        }
        break;  
    }
    SymLoad(table, dmpName, , repCnt, &symCnt);
    MsgWait("Load Symbols " . table, symCnt . " symbols loaded");
    if (tableLetter == "d")
        Signal("");             // to restart system
}
Define UnloadTable(tableName, dmpName)
/*
    This is a non interactive one that could be used from the command line.
    eg
        n -p"UnloadTable(univ.dat,\tmp\univ.dmp)"
*/
{
    SymClose("univ");               /* close all files */
    SymClose("parm");               /* we may be unloading one of them */
    SymClose("mdat");
    SymClose("mlib");
    SymClose("data");

    if (SymOpen("data", tableName))
        Signal("Could not open Symbol Table " . tableName);

    SymUnload("data", dmpName, , 100, &symCnt);
    Print(symCnt, " symbols unloaded\n");
    Signal("");                     /* restart the system */
}
Define LoadTableReport(name, symCnt)
{
    Print(symCnt, "\r");
}
Define LoadTable(tableName, dmpName, blkSize)
{
    SymClose("univ");               /* close all files */
    SymClose("parm");               /* we may be loading one of them */
    SymClose("mdat");
    SymClose("mlib");
    SymClose("data");

    if (!blkSize)
        blkSize = 512;              /* The default block size */

    if (SymOpen("data", tableName, , 8)
        && SymCreate("data", tableName, "Excl", blkSize, 8))
        Signal("Could not open or create Symbol Table " . tableName);

    SymLoad("data", dmpName, , 100, &symCnt);
    Print(symCnt, " symbols loaded\n");
}
