//  Project leowl_4
//  xor@hawk.usr.pu.ru
//  Copyright  1996. Andrey B. Yastrebov. All Rights Reserved.
//
//  SUBSYSTEM:    leowl_4.exe Application
//  FILE:         leowl_4e.cpp
//  AUTHOR:       Andrey B. Yastrebov
//
//
//  OVERVIEW
//  ========
//  Source file for implementation of leowl_4Edit (TEditFile).
//
//  Comments are turned to single-line in order LEdit doesn't support
//  multiline comments yet.

#include <owl\owlpch.h>
#pragma hdrstop

#include "leowl_4.h"
#include "leowl_4e.h"

// Small subset of C++ keywords that may be found in this file
static LPSTR CPPWords[] = {
  "switch","case","default","break","return","if","else","while","for",
  "const","char","far","static","sizeof","new","void"
  };
static int CPP_WORDS = sizeof(CPPWords) / sizeof(LPSTR);
static char MsgBuf[2048];

//{{leowl_4Edit Implementation}}


//////////////////////////////////////////////////////////
// leowl_4Edit
// ==========
// Construction/Destruction handling.
leowl_4Edit::leowl_4Edit (TWindow* parent,
                          const char far* text,
                          TModule* module)
    : TLEdit(parent, 0, text, 0, 0, 0, 0, ES_HIGHLIGHT
    | ES_SMALLINDENT | ES_SMALLSPACING, module)
{
	 // Change a little LEdit behavour
	 lpFont = new TFont((HFONT) GetStockObject(DEVICE_DEFAULT_FONT));

         // Set small subset of C++ syntax
	 SetSyntax(
           "2\"\\2\'\\2//2/*2*/1(1)1[1]1{1}1+1-1*1/1\\1,1;1=1:1%1|1!1&2||2&&2==1<1>2. 2::");

         // Change default colors. So we make sure highlighting is
         // visible
         ForeColor = RGB(128,128,128);
         BackColor = RGB(192,192,192);
         ControlColors = true;

}

leowl_4Edit::~leowl_4Edit ()
{
    Destroy();
}


void leowl_4Edit::SetupWindow ()
{
    TLEdit::SetupWindow();
    LoadFromFile("leowl_4e.cpp");
}

WORD leowl_4Edit::ControlHighlight (const WORDDESC& wordDesc,
                                    COLORREF& /*cBk*/,
                                    COLORREF& cText )
{
  switch ( wordDesc.wCode )
    {
      case WD_SIMPLEWORD:
	{
           // Set default text color for words
	   cText = RGB(0,0,0);

           // Check for # at the beginning of the word
           // This surely doesn't reflect C++ syntax, but
           // #define and #include become highlighted
           if (wordDesc.caWord[0] == '#')
             {
                cText = RGB(0,0,128);
                return EOCH_TEXT;
             }


           // Mark C++ keywords if this is CPP window
           int i;
	   for (i = 0; i < CPP_WORDS; i++)
	     {
	       if ( lstrcmp(wordDesc.caWord,CPPWords[i]) == 0)
		  {
		     cText = RGB(0,0,255);
                     return EOCH_TEXT;
                  }
	     }

	   return EOCH_TEXT;
        }
      case WD_SYNTAXITEM:
	{
           // Set text color for syntax words
	   cText = RGB(0,0,192);
           return EOCH_TEXT;
	}
      case WD_BADLYQUOTEDTEXT:
      case WD_QUOTEDTEXT:
	{
           // Set text color for quoted text
           if (HIWORD(wordDesc.dwValue))
	       cText = RGB(0,128,0);
	   else
               cText = RGB(255,0,0);
           return EOCH_TEXT;
	}
      default:
	// Set text color for the rest of words, that is
        // for numbers
        cText = RGB(0,128,0);
    }
  return EOCH_TEXT;
}

WORD leowl_4Edit::WordClick(const WORDDESC& wordDesc)
{
  if (&wordDesc)
    {
       // Show message about word supplied if it exists
       lstrcpy(MsgBuf,wordDesc.caWord);
       lstrcat(MsgBuf,"\r\n");
       if ( wordDesc.wCode == WD_SYNTAXITEM )
	 {
           WORD SyntaxIndex = HIWORD(wordDesc.dwValue);
	   wvsprintf(MsgBuf+lstrlen(MsgBuf),"Syntax: %d",&SyntaxIndex);
	 }
       else if ( wordDesc.wCode & WDF_INTEGER )
	 {
	   wvsprintf(MsgBuf+lstrlen(MsgBuf),"Integer: %ld",&wordDesc.dwValue);
	 }
       MessageBox(MsgBuf,"Click",MB_OK | MB_ICONINFORMATION);
    }
  else
    // Show "White space" message
    MessageBox("White space","Click",MB_OK | MB_ICONINFORMATION);
  return 1;
}

WORD leowl_4Edit::OnFindBrace(WORDDESC& wordDesc)
{
  if ( wordDesc.wCode == WD_SYNTAXITEM )
    {
      // Indicate braces for parantheises, brackets etc.
      WORD SyntaxIndex = HIWORD(wordDesc.dwValue);
      if ( SyntaxIndex > 10 )
	return EMF_NOBRACE;
      WORD Result;
      if ( SyntaxIndex % 2)
        {
	  SyntaxIndex++;
	  Result = EMF_HASRIGHT;
        }
      else
        {
	   SyntaxIndex--;
	   Result = EMF_HASLEFT;
        }
      wordDesc.dwValue = MAKELONG(0,SyntaxIndex);
      return Result;
    }
  else
    return EMF_NOBRACE;
}

