// =========================================================================
//       LEdit wrapper for Borland OWL 2.5 (Windows 3.1)
//       ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
//       Version 1.01
//       (c) 1996-1996 Andrey B. Yastrebov
//       Nobody can modify this file without written permission of author
//
//       Limitations of current version:
//       Summary length of all editing files: min(ca 60M,your memory)
//       Maximum line length: 8K
//
//       This file containts full definitions and documentation on constants
//       and functions needed to deal with LEdit OWL wrapper
//       !!! Many things have different meaning than in stanard "TEdit" !!!
//       ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
//
//       Windows      is a trademark of Microsoft corp.
//
//       If you have some questions please contact:  xor@hawk.usr.pu.ru
// =========================================================================
//
//   Defines TLEdit classes:
//
//
//  TView --------------------|
//                            |---> TLEditView
//                        |---|
//  TWindow ---> TLEdit --|
//                        |-------> TLEditFile
//
// You may use the following constants to disable some components.
// This will exclude them from LEOWL.H
//
//#define LEDIT_NO_FILE
//#define LEDIT_NO_VIEW
//
//
//  When working with these objects you may use ES_* constants for
//  LEdit styles. See them in file LEDIT.H
//
//  File LEDIT.H also contains description of all structures
//  and options very important while using LEdit.
//
//----------------------------------------------------------------------------
#if !defined(BI_DATA_FAR)
#error Sorry, LEdit OWL wrapper works with LARGE memory model only
#endif

#if !defined(OWL_LEDIT_H)
#define OWL_LEDIT_H

#include "ledit.h"

//***** In no cases can you change these definitions
#define SIZE_FILEMASK 255
#define SIZE_SYNTAX 253

//
//  class TLEdit
//  ----- ------
//
class _OWLCLASS TLEdit : public TWindow {
  public:
	 TLEdit(TWindow*        parent,
			  const char far* title,
			  long extraStyle = 0, // Additional styles. See the list in LEDIT.H
			  TModule*        module = 0);

	 TLEdit(TWindow*        parent,
			  int             id,
			  const char far* title,
			  int x = 0, int y = 0, int w = 0, int h = 0,
			  long extraStyle = 0, // Additional styles. See the list in LEDIT.H
			  TModule*        module = 0);

	 TLEdit(TWindow*   parent,
			  int        resourceId,
			  TModule*   module = 0);

	 //
	 // This data member determines wether Memory DC or actual
	 // LEdit DC will be passed to Paint virtual function
	 // It makes sense only if LEdit has ES_Transparent style
	 //
	 bool UseMemoryDC;

	 //
	 // Colors to be used with highlight selection
	 // Initially set to default in constructor
	 //
	 COLORREF BackColorSelected;
	 COLORREF ForeColorSelected;

         //
         // Colors to be used with standard text.
         // You may coose them and then act as in case of EM_CTLCOLOR
         // To do this set ControlColors to true, or otherwise to
         // false in which case color control will be tracked by
         // your parent
         //
         bool ControlColors;
         COLORREF BackColor;
         COLORREF ForeColor;

	 //
	 // LEDITPOSITION Structure to be used in default operations
	 //
	 LEDITPOSITION SelPos;

	 //
	 // WORDDESC Structure to be used when asking for words
	 //
	 WORDDESC WordDesc;

	 //
	 // Object to store font data. It automatically maintains font
	 // used in LEdit, so if changed SetFont() must be called.
	 //
	 TFont far* lpFont;

	 //
	 // Sets font using HFONT works only when control exists
	 // It's left here only for compatibility with standards
	 //
	 void SetFont(HFONT font)
		{HandleMessage(WM_SETFONT,(WPARAM) font);}
	 void SetFont(LOGFONT& font)
		{HandleMessage(EM_SETLOGFONT,0,(LPARAM) &font);}
	 void SetFont(TFont& font);
	 void SetFont()
		{SetFont(*lpFont);}

	 //
	 // Sets syntax. May be used at any time. See LEDIT.H for
	 // detailed information. Or alternative form as in VBX
	 // or Delphi VCL wrappers may be used with string supplied
	 // to function.
	 //
	 void SetSyntax(SYNTAX far* syntax, int syntaxLength);
	 void SetSyntax(char far* syntax);

	 //******* The following functions constitute syntax parser ***************

	 //
	 // Starts parsing process and move pointer position (PP) to the
	 // beginning of the text
	 //
	 void SetScan()
		{HandleMessage(EM_SETSCAN);}

	 //
	 // Retrieves current word from PP and move PP to the end of it.
	 // Return status of the operation
	 //
	 int GetWord(WORDDESC& wordDesc, bool skipLines = true)
		{return LOWORD(HandleMessage(EM_GETWORD,skipLines,(LPARAM) &wordDesc));}
	 int GetWord(bool skipLines = true)
		{return GetWord(WordDesc,skipLines);}

	 //
	 // Moves PP to the begin of the next line
	 //
	 int NextLine()
		{return LOWORD(HandleMessage(EM_NEXTLINE));}

	 //
	 // Gets the rest of line from PP to the next of line. Doesn't
	 // move PP.
	 // In the second form allocates memory using new and pass
	 // returns its address
	 //
	 int GetRestOfLine(char far* buf)
		{return LOWORD(HandleMessage(EM_GETRESTOFLINE,0,(LPARAM) buf));}
	 char far* GetRestOfLine();


	 //
	 // Retrieves position of last word read by GetWord() or start of
	 // new line set by NewLine()
	 //
	 int GetScan(LEDITPOSITION& Pos)
		{return LOWORD(HandleMessage(EM_GETSCAN,0,(LPARAM) &Pos));}
	 int GetScan()
		{return GetScan(SelPos);}

	 //******* End of syntax parser *****************************************

	 //
	 // Retrieves current word from the caret position.
	 // Return status of the operation
	 //
	 int GetCurrentWord(WORDDESC& wordDesc)
		{return LOWORD(HandleMessage(EM_GETCURRENTWORD,0,(LPARAM) &wordDesc));}
	 int GetCurrentWord()
		{return GetCurrentWord(WordDesc);}

	 //
	 // returns the length of the control's caption
	 //
	 int GetCaptionLen()
		{return ::GetWindowTextLength(HWindow);}

	 //
	 // fills the passed string with the text of the associated
	 // control's caption.  returns the number of characters copied
	 //
	 bool GetCaption(char far* str, int maxChars)
		{return (maxChars == EMP_ALLTEXT) ? false :
		 ::GetWindowText(HWindow, str, maxChars);}

	 //
	 // sets the contents of the associated control's caption to
	 // the passed string
	 //
	 void SetCaption(const char far* str)
		{::SetWindowText(HWindow, str);}

	 //
	 // Returns number of lines in LEdit
	 //
	 long GetNumLines()
		{return HandleMessage(EM_GETLINECOUNT);}

	 //
	 // Returns the length of specified line
	 //
	 long GetLineLength(long lineNumber)
		{return HandleMessage(EM_LINELENGTH,0,lineNumber);}

	 //
	 // Returns specified line. Buffer str must be large enough.
	 // Returns the length of the line.
	 // In the second form allocates memory using new and pass
	 // returns its address
	 //
	 long GetLine(char far* str, long lineNumber);
	 char far* GetLine(long lineNumber);

	 //
	 // Returns Selected position
	 //
	 void GetSelection(LEDITPOSITION& Pos)
		{HandleMessage(EM_GETSEL,0,(LPARAM) &Pos);}
	 void GetSelection() {GetSelection(SelPos);}

	 //
	 // Sets selected position
	 //
	 void SetSelection(const LEDITPOSITION& Pos)
		{HandleMessage(EM_SETSEL,0,(LPARAM) &Pos);}
	 void SetSelection(long StartLine, int StartPosition, long EndLine,
		int EndPosition);
	 void SetSelection() {SetSelection(SelPos);}

	 //
	 // Moves caret
	 //
	 void MoveCaret(long Line, int Position);

	 //
	 // Returns text length
	 //
	 long GetTextLength()
		{return HandleMessage(EM_GETTEXTLENGTH,EMP_ALLTEXT);}

	 //
	 // Returns text
	 //
	 bool GetText(char huge* str)
		{return ! HandleMessage(EM_GETTEXT,EMP_ALLTEXT,(LPARAM) str);}
	 bool GetText(char huge* str, long maxChars)
		{return ( maxChars > GetTextLength()) ? GetText(str) : false; }
	 HANDLE GetText();

	 //
	 // Replaces text
	 //
	 void SetText(const char huge* str)
		{HandleMessage(EM_SETTEXT,EMP_ALLTEXT,(LPARAM) str);}
	 void SetText(HANDLE hGlobal);

	 //
	 // Returns Selected text length
	 //
	 long GetSelLength()
		{return HandleMessage(EM_GETSELTEXTLENGTH);}

	 //
	 // Returns Selected text
	 //
	 bool GetSelText(char huge* str)
		{return ! HandleMessage(EM_GETSELTEXT,0,(LPARAM) str);}
	 bool GetSelText(char huge* str, long maxChars)
		{return ( maxChars > GetSelLength()) ? GetSelText(str) : false;}
	 HANDLE GetSelText();

	 //
	 // Replaces Selected text
	 //
	 void SetSelText(const char huge* str)
		{HandleMessage(EM_REPLACESEL,0,(LPARAM) str);}
	 void SetSelText(HANDLE hGlobal);

	 //
	 // Verifies if the text was modified since last ClearModify()
	 //
	 bool IsModified(int flagNumber = 2)
		{return LOWORD(HandleMessage(EM_GETMODIFY,flagNumber));}

	 //
	 // Sets or Clears modify flag
	 //
	 void SetModify(int fSetOrClear, int flagNumber = 2)
		{HandleMessage(EM_SETMODIFY,fSetOrClear,flagNumber);}

	 //
	 // Clears modify flag
	 //
	 void ClearModify(int flagNumber = 2)
		{SetModify(EMP_CLEAR,flagNumber);}

	 //
	 // Deletes all text
	 //
	 void DeleteText()
		{HandleMessage(EM_CLEAR,EMP_ALLTEXT);}

	 //
	 // Deletes specified part of the text
	 //
	 void DeleteSubText(const LEDITPOSITION& Pos);
	 void DeleteSubText(long StartLine, int StartPosition, long EndLine,
		int EndPosition);
	 void DeleteSubText() {DeleteSubText(SelPos);}

	 //
	 // Deletes specified line
	 //
	 void DeleteLine(int lineNumber);

	 //
	 // The same as SetSelText - exists only for compatibility.
	 //
	 void Insert(const char far* str)
		{SetSelText(str);}

	 //
	 // Set number of cahrs equivalent to one tab (1 - 40)
	 // May be used before window creation
	 //
	 void SetTabStops(int numTabs);

	 //
	 // Returns handle of pop-up menu
	 //
	 HMENU GetPopUpMenu()
		{return (HMENU) HIWORD(HandleMessage(EM_GETHANDLE,EMP_MENU));}

	 //
	 // Returns handle of main menu if ES_HASMENU
	 //
	 HMENU GetMenu()
		{return (HMENU) LOWORD(HandleMessage(EM_GETHANDLE,EMP_MENU));}

	 //
	 // Returns number of first visible line
	 //
	 long GetFirstVisibleLine()
		{return HandleMessage(EM_GETFIRSTVISIBLELINE);}

	 //
	 // Returns number of leftmost visible position in units that
	 // may be retrieved with GetUnitsHorizontal()
	 //
	 int GetFirstVisiblePos()
		{return LOWORD(HandleMessage(EM_GETHORZPOSITION));}

	 //
	 // Gets line height in pixels
	 //
	 int GetUnitsVertical()
		{return HIWORD(HandleMessage(EM_GETUNITS));}

	 //
	 // Gets horizontl scrolling unit in pixels
	 //
	 int GetUnitsHorizontal()
		{return LOWORD(HandleMessage(EM_GETUNITS));}

	 //
	 // Sets/Clears read-only flag
	 //
	 void SetReadOnly(bool readOnly = true);

	 //
	 // Gets ReadOnly status. Won't work if this status is
	 // changed directly by sending EM_SETREADONLY
	 //
	 bool GetReadOnly()
		{return HIWORD(Attr.Style & ES_READONLY);}

	 //
	 // Sets insert mode
	 //
#define IM_INSERT    false
#define IM_OVERWRITE true
	 void SetInsertMode(bool insertMode = false);

	 //
	 // Toggles insert mode
	 //
	 void ToggleInsertMode()
		{SetInsertMode(!InsertMode);}

	 //
	 // Gets insert mode
	 //
	 bool GetInsertMode()
		{return InsertMode;}

	 //
	 // Sets AutoIndent
	 //
	 void SetAutoIndent(bool autoIndent = true);

	 //
	 // Gets AutoIndent State
	 //
	 bool GetAutoIndent()
		{return AutoIndent;}

	 //
	 // Sets DefaultSelection
	 //
	 void SetDefaultSelection(bool defaultSelection = true);

	 //
	 // Gets DefaultSelection State
	 //
	 bool GetDefaultSelection()
		{return DefaultSelection;}

	 //
	 // Gets maximum possible depth of Undo. Works only
	 // when window exists
	 //
	 int GetUndoMaxBuffer()
		{return LOWORD(HandleMessage(EM_GETMAXUNDOBUFFER));}

	 //
	 // Sets the depth of undo. -1 means maximum possible depth
	 //
	 void SetUndoDepth(int undoDepth = -1);

	 //
	 // Fill in the control with text from file
	 //
	 bool LoadFromFile(const char far* fileName)
		{return !LOWORD(HandleMessage(EM_SETTEXTFROMFILE,0,(LPARAM) fileName));}


	 //
	 // Stores control containt into the file
	 //
	 bool StoreToFile(const char far* fileName)
		{return !LOWORD(HandleMessage(EM_GETTEXTTOFILE,0,(LPARAM) fileName));}

#define MENU_COMMAND(MC_fn,MC_cmd) \
	  void MC_fn() {HandleMessage(WM_COMMAND,MC_cmd);}
	 //
	 // Edit operations
	 //
	 bool CanUndo()
		{return LOWORD(HandleMessage(EM_CANUNDO,EMP_UNDO));}
	 bool CanRedo()
		{return LOWORD(HandleMessage(EM_CANUNDO,EMP_UNDO));}
	 bool IsSelection();

	 void Undo()
		{HandleMessage(WM_UNDO,EMP_UNDO);}
	 void Redo()
		{HandleMessage(WM_UNDO,EMP_REDO);}
	 void Cut()
		{HandleMessage(WM_CUT);}
	 void Copy()
		{HandleMessage(WM_COPY);}
	 void Paste()
		{HandleMessage(WM_PASTE);}
	 MENU_COMMAND(Duplicate,EC_EDITDUPLICATE)
	 void DeleteSelection()
		{HandleMessage(EM_CLEAR,EMP_SELECTION);}
	 MENU_COMMAND(SelectAll,EC_EDITSELECTALL)

	 //
	 // Search operations
	 //
	 bool CanFindNext()
		{return LOWORD(HandleMessage(EM_CANFINDNEXT));}

	 MENU_COMMAND(ShowFindDialog,EC_SEARCHFIND)
	 MENU_COMMAND(FindNext,EC_SEARCHNEXT)
	 MENU_COMMAND(ShowReplaceDialog,EC_SEARCHREPLACE)
	 MENU_COMMAND(FindBrace,EC_SEARCHBRACE)
	 MENU_COMMAND(ShowGotoLineDialog,EC_SEARCHLINE)
	 MENU_COMMAND(FindBookmark,EC_SEARCHBOOKMARK)
	 MENU_COMMAND(SetBookmark,EC_SEARCHSETBOOKMARK)

	 //
	 // Tools operations
	 //
	 MENU_COMMAND(ShowFontDialog,EC_TOOLSCHANGEFONT)
	 void EmptyUndoBuffer()
		{HandleMessage(EM_EMPTYUNDOBUFFER);}
	 void Clear()
		{HandleMessage(WM_CLEAR,EMP_ALLTEXT);}

	 //
	 // Return TRUE if this is LEditWindow
	 //
	 bool IsLEdit()
		{return (HandleMessage(EM_ISLEDITWINDOW,0,543210L) == 543211L);}

	 //
	 // Override TWindow virtual member functions.
	 //
	 // Transfers nothing
	 //
	 virtual uint Transfer(void* buffer, TTransferDirection direction);

	 //
	 // Sends several notifications. See LEDIT.H for details.
	 //
	 virtual bool CanClose();

  protected:
	 //
	 // Indicates if LEdit window is functional. Don't write!!!
	 //
	 bool Run;

	 //
	 // command response functions. Commands EC_* are responded
	 // directly. Only responses to IDs with existing CM_*
	 // constants are provided to make CM_* commands work
	 // the same way as EC_* ones. All constants are listed below
	 // as comments to the functions.
	 //
	 void CmEC_Command(WPARAM wp)
		{DefWindowProc(WM_COMMAND,wp,0L);}       // Any EC_*

	 void CmEditUndo() {Undo();}                // CM_EDITUNDO
															  // EC_EDITUNDO

															  // EC_EDITREDO

	 void CmEditCut() {Cut();}                  // CM_EDITCUT
															  // EC_EDITCUT

	 void CmEditCopy() {Copy();}                // CM_EDITCOPY
															  // EC_EDITCOPY

	 void CmEditPaste() {Paste();}              // CM_EDITPASTE
															  // EC_EDITPASTE

															  // EC_DUPLICATE

	 void CmEditDelete() {DeleteSelection();}   // CM_EDITDELETE
															  // EC_EDITCLEAR

															  // EC_EDITSELECTALL

	 void CmEditFind() {ShowFindDialog();}      // CM_EDITFIND
															  // EC_SEARCHFIND

	 void CmEditFindNext() {FindNext();}        // CM_EDITFINDNEXT
															  // EC_SEARCHNEXT

	 void CmEditReplace() {ShowReplaceDialog();}// CM_EDITREPLACE
															  // EC_SEARCHREPLACE

															  // EC_SEARCHBRACE
															  // EC_SEARCHLINE
															  // EC_SEARCHBOOKMARK
															  // EC_SEARCHSETBOOKMARK
															  // EC_TOOLSCHANGEFONT
															  // EC_TOOLSCLEARUNDOBUFFER

	 void CmEditClear() {Clear();}              // CM_EDITCLEAR
															  // EC_TOOLSCLEARALL



	 //
	 // command enabler functions
	 //
	 void CmDirectEnable(TCommandEnabler& commandHandler);
	 void CmTranslateEnable(TCommandEnabler& commandHandler);

	 //
	 // Virtual functions to handle events. LEdit can't use normal RESPONSE
	 // TABLE Mechanism because its notifications may be answered. So, all
	 // events generated by LEdit lead to call to some of the follofing
	 // virtual functions. By default they all sends notification about
	 // the event and then return zero as default answer.
	 //
	 // Some events generate notifications that weren't generated by LEdit
	 // On the other hand some events, which are results of LEdit nofification
	 // does not generate notifications by itself.
	 //
	 // File handling events are also included here though they make sense
	 // only in TLEditFile
	 //
	 // The following virtual functions do send notifications
	 // If you override them you need to call prototypes to ensure
	 // notification processing
	 //
	 virtual void OnChange()
		{SendNotification(Attr.Id,EN_CHANGE,HWindow);}

	 virtual void OnChangeMode()
		{SendNotification(Attr.Id,EN_INSERTMODE + InsertMode,HWindow);}

	 virtual LRESULT OnClipboardError()
		{SendNotification(Attr.Id,EN_CLIPBOARD,HWindow);
		 return 0;}

	 virtual LRESULT OnFileError()
		{SendNotification(Attr.Id,EN_FILEERROR,HWindow);
		 return 0;}

	 virtual LRESULT OnSpaceError()
		{SendNotification(Attr.Id,EN_ERRSPACE,HWindow);
		 return 0;}

	 virtual LRESULT OnMaxLine()
		{SendNotification(Attr.Id,EN_MAXTEXT,HWindow);
		 return 0;}

	 virtual LRESULT OnGoingToClose()
		{SendNotification(Attr.Id,EN_GOINGTOCLOSE,HWindow);
		 return 0;}

	 virtual void OnGotFocus()
		{SendNotification(Attr.Id,EN_SETFOCUS,HWindow);}

	 virtual void OnLostFocus()
		{SendNotification(Attr.Id,EN_KILLFOCUS,HWindow);}

	 virtual void OnHorzScroll()
		{SendNotification(Attr.Id,EN_HSCROLL,HWindow);}

	 virtual void OnVertScroll()
		{SendNotification(Attr.Id,EN_VSCROLL,HWindow);}

	 virtual void OnNewFile()
		{SendNotification(Attr.Id,EN_NEWFILE,HWindow);}

	 virtual void OnNewFont()
		{SendNotification(Attr.Id,EN_NEWFONT,HWindow);}

	 //
	 // This function is called from EM_CTLCOLOR handler
	 // You may change BackColorSelected and ForeColorSelected
	 // when receiving the notification. Default handler of EM_CTLCOLOR
	 // uses them to set colors of selected text.
	 //
#define EN_CTLSELCOLOR 30000
	 virtual void OnCtlSelColor()
		{SendNotification(Attr.Id,EN_CTLSELCOLOR,HWindow);}

         //
	 // This function is called from WM_CTLCOLOR handler
	 // You may change BackColor and ForeColor
	 // when receiving the notification. Default handler of WM_CTLCOLOR
	 // uses them to set colors of selected text.
	 //
         // This function works only if ControlColors == true, otherwise
         // colors are intended to be controlled by parent Window, that
         // gives default LEdit behaviour.
         //
#define EN_CTLTXTCOLOR 30001
	 virtual void OnCtlTxtColor()
		{SendNotification(Attr.Id,EN_CTLTXTCOLOR,HWindow);}



	 //
	 // This one should be used for informational purposes
	 // only and is called from EM_WORDCLICK handler
#define EN_WORDCLICK   30002
	 virtual void OnWordClick()
		{SendNotification(Attr.Id,EN_WORDCLICK,HWindow);}

	 //
	 // OnCreated is called much after creation, from SetupWindow()
	 // virtual method
	 //
	 virtual void OnCreated()
		{SendNotification(Attr.Id,EN_CREATED,HWindow);}

	 //
	 // EN_DESTROY notification becomes obsolete in OWL because
	 // Destroy() virtual function may always be called
	 //

	 //
	 // These virtual functions don't send any notifications
	 //
	 virtual LRESULT OnAskIfStoreFile()
		{return 0;}

	 //
	 // Does Highlight if ES_HIGHLIGHT style is set
	 //
	 virtual WORD ControlHighlight(const WORDDESC& WordDesc,
											 COLORREF& BkColor,
											 COLORREF& TextColor)
		{ BkColor = 0; TextColor = 0; return 0;}
#define EOCH_NONE  0
#define EOCH_TEXT  1
#define EOCH_BKGND 2
#define EOCH_BOTH  3

	 //
	 // Brace definition function called on EM_FINDBRACE
	 //
	 virtual WORD OnFindBrace(WORDDESC& WordDesc)
		{ return EMF_NOBRACE; }

	 //
	 // This function is called on EM_WORDCLICK that is when
	 // user doubleclick some word.
	 //
	 virtual WORD WordClick(const WORDDESC& WordDesc)
		{ return 0; }

	 //
	 // Does Background drawing if ES_TRANSPARENT style is set
	 // Receives actual LEdit or Memory DC depending on UseMemoryDC member
	 //
	 virtual void Paint(TDC& hDC, bool erase, TRect& rect)
		{}

	 //
	 // Override TWindow virtual member functions
	 //
	 virtual void SetupWindow();
	 virtual char far* GetClassName();
	 virtual LRESULT EvCommand(uint Id, HWND hWndCtl, uint notifyCode);
	 virtual void EvPaint();
	 virtual void EvSetFont(HFONT hfont, bool redraw);
	 virtual void EvDestroy();

	 //
	 // Create new response-table functions
	 //
	 virtual LRESULT EvControlSColor(WPARAM, LPARAM);
         virtual LRESULT EvControlTColor(WPARAM, LPARAM);
	 virtual LRESULT EvControlHighlight(WPARAM, LPARAM);
	 virtual LRESULT EvDraw(WPARAM, LPARAM);
	 virtual LRESULT EvFindBrace(WPARAM, LPARAM);
	 virtual LRESULT EvWordClick(WPARAM, LPARAM);

  private:
	 //
	 // hidden to prevent accidental copying or assignment
	 //
	 bool StreamInit;
	 bool InsertMode;
	 bool AutoIndent;
	 bool DefaultSelection;
	 int UndoDepth;
	 int TabStops;
	 SYNTAX Syntax[SIZE_SYNTAX];
	 int SyntaxLength;

    void Init();

	 TLEdit(const TLEdit&);
	 TLEdit& operator =(const TLEdit&);

  DECLARE_STREAMABLE(_OWLCLASS, TLEdit, 1);
  DECLARE_RESPONSE_TABLE(TLEdit);
};

//
//  class TLEditFile
//  ----- ----------
//
#if !defined (LEDIT_NO_FILE)
class _OWLCLASS TLEditFile : public TLEdit {
  public:
	 TLEditFile(TWindow*        parent,
					const char far* title,
					long extraStyle = 0, // Additional styles. See the list in LEDIT.H
					TModule*        module = 0);

	 TLEditFile(TWindow*        parent,
					int             id,
					const char far* title,
					int x = 0, int y = 0, int w = 0, int h = 0,
					long extraStyle = 0, // Additional styles. See the list in LEDIT.H
					TModule*        module = 0);

	 TLEditFile(TWindow*   parent,
					int        resourceId,
					TModule*   module = 0);

	 //
	 // Returns file name. Buffer fileName must be large enough.
	 // Returns the length of the line.
	 // In the second form allocates memory using new and pass
	 // returns its address
	 //
	 long GetFileName(char far* fileName)
		{return HandleMessage(EM_GETFILENAME,0,(LPARAM) fileName);}
	 char far* GetFileName();

	 //
	 // Sets File Mask/Filter (see EM_SETFILEMASK)
	 //
	 void SetFileMask(char far* fileMask);

	 //
	 // Gets File Mask/Filter
	 //
	 char far* GetFileMask(char far* fileMask)
		{return lstrcpy(fileMask, FileMask);}

	 //
	 // File operations
	 //
	 bool CanExecute(WORD commandId)
		{return LOWORD(HandleMessage(EM_CANEXECUTECOMMAND,commandId));}
	 MENU_COMMAND(NewFile,EC_FILENEW)
	 MENU_COMMAND(OpenFile,EC_FILEOPEN)
	 MENU_COMMAND(ReloadFile,EC_FILEREOPEN)
	 MENU_COMMAND(SaveFile,EC_FILESAVE)
	 MENU_COMMAND(SaveFileAs,EC_FILESAVEAS)

  protected:
	 //
	 // command response functions. Commands EC_* are responded
	 // directly. Only responses to IDs with existing CM_*
	 // constants are provided to make CM_* commands work
	 // the same way as EC_* ones. All constants are listed below
	 // as comments to the functions.
	 //
	 // All commands are automatically enabled/disabled except
	 // CM_FILENEW and CM_FILEOPEN {Not EC_FILENEW/EC_FILEOPEN}
	 //
	 // CmFileNew and CmFileOpen don't have any entries
	 // in Response Table, but may be added in descendents
	 //
	 void CmFileNew() {NewFile();}              // CM_FILENEW
															  // EC_FILENEW

	 void CmFileOpen() {OpenFile();}            // CM_FILEOPEN
															  // EC_FILEOPEN

	 void CmFileReOpen() {ReloadFile();}        // CM_FILEREVERT
															  // EC_FILEREOPEN

	 void CmFileSave() {SaveFile();}            // CM_FILESAVE
															  // EC_FILESAVE

	 void CmFileSaveAs() {SaveFileAs();}        // CM_FILESAVEAS
															  // EC_FILESAVEAS

    //
	 // Override TWindow virtual member functions
	 //
	 virtual void SetupWindow();

	 //
	 // Create new response-table functions
	 //
	 virtual LRESULT EvSetFileMask(WPARAM, LPARAM);

  private:
	 //
	 // hidden to prevent accidental copying or assignment
	 //
	 char FileMask[SIZE_FILEMASK];

	 void Init();

	 TLEditFile(const TLEditFile&);
	 TLEditFile& operator =(const TLEditFile&);

  DECLARE_STREAMABLE(_OWLCLASS, TLEditFile, 1);
  DECLARE_RESPONSE_TABLE(TLEditFile);
};
#endif // TLEditFile

//
//  class TLEditView
//  ----- ----------
//
#if !defined(LEDIT_NO_VIEW)
class _OWLCLASS TLEditView : public TLEdit, public TView {
  public:
	 TLEditView(TDocument& doc,
					TWindow* parent = 0,
					TModule* module = 0);

	 //
	 // Returns view name
	 //
	 static const char far* StaticName()
		{return "Large Edit View";}

	 //
	 // overrides virtual functions from TView
	 //
	 virtual const char far*   GetViewName()
		{return StaticName();}
	 virtual TWindow* GetWindow()
		{return (TWindow*) this;}
	 virtual bool SetDocTitle(const char far* docname, int index)
		{return TLEdit::SetDocTitle(docname, index);}

	 //
	 // overrides virtual functions from TLEditControl
	 //
	 virtual bool CanClose()
		{return TLEdit::CanClose() && Doc->CanClose();}

  protected:
	 virtual bool Create();
	 bool   LoadData();
	 //
	 // message response functions
	 //
	 virtual bool VnCommit(bool force);
	 virtual bool VnRevert(bool clear);
	 virtual bool VnIsWindow(HWND hWnd)
		{return (HWindow == hWnd) && IsLEdit();}
	 virtual bool VnIsDirty()
		{return TLEdit::IsModified(15);}
	 virtual bool VnDocClosed(int omode);

  private:
	 //
	 // hidden to prevent accidental copying or assignment
	 //
	 bool weWrite;

	 TLEditView(const TLEditView&);
	 TLEditView& operator =(const TLEditView&);

  DECLARE_STREAMABLE(_OWLCLASS, TLEditView,1);
  DECLARE_RESPONSE_TABLE(TLEditView);
};
#endif // TLEditView

#endif // OWL_LEDIT_H
