unit Ledlp_5a;

interface

uses
  SysUtils, WinTypes, WinProcs, Messages, Classes, Graphics, Controls,
  Forms, Dialogs, Ledlp;

type
  TCppPasForm = class(TForm)
    WndCPP: TLEdit;
    WndPAS: TLEdit;
    procedure WndPASControlHighlight(Sender: TObject; WordType: Word;
      WordValue: Longint; WordStr: String; var ForeClr, BackClr: TColor);
    procedure WndCPPControlHighlight(Sender: TObject; WordType: Word;
      WordValue: Longint; WordStr: String; var ForeClr, BackClr: TColor);
    procedure WndCPPWordClick(Sender: TObject; WordType: Word;
      WordValue: Longint; WordStr: String; var WordHandled: Boolean);
    procedure WndPASWordClick(Sender: TObject; WordType: Word;
      WordValue: Longint; WordStr: String; var WordHandled: Boolean);
    procedure WndPASFindBrace(Sender: TObject; WordType: Word;
      WordValue: Longint; WordStr: String; var BraceType: TLEBraceStyle);
    procedure WndCPPFindBrace(Sender: TObject; WordType: Word;
      WordValue: Longint; WordStr: String; var BraceType: TLEBraceStyle);
  private
  public
  end;

const
  CPP_WORDS      = 11;
  PAS_WORDS      = 29;
  PAS_LEFT_BRACE = 'begin';
  PAS_RIGHT_BRACE= 'end';
  { Actually "end" has multiple braces such as "case" or      }
  { "record", but multiple braces aren't supported now        }
  { Pascal source is written without such words and therefore }
  { Find Brace will work properly on it                       }

  CPPWords: array[0..CPP_WORDS-1] of String = (
    { Small subset of C++ keywords }
    'switch','case','default','break','return','if','else','while','for',
    '#define','#include');

  PASWords: array[0..PAS_WORDS-1] of String = (
    { Small subset of Pascal keywords }
    'begin','end','case','break','exit','if','then','while','for','do',
    'uses','type','const','var','function','class','private','public',
    'published','procedure','implementation','interface','or','and','div',
    'unit','mod','shl','shr');

var
  CppPasForm: TCppPasForm;

implementation

{$R *.DFM}

procedure TCppPasForm.WndPASControlHighlight(Sender: TObject;
  WordType: Word; WordValue: Longint; WordStr: String; var ForeClr,
  BackClr: TColor);
var
  MyWord: TWordDesc;
  i: Integer;
begin
  MyWord := WndPAS.WordDesc;
  if WordType = WD_SIMPLEWORD then
  begin
    { Set default text color for words }
    ForeClr := clBlack;
    BackClr := WndPAS.Color;

    { Mark Pascal keyword if this is PAS window }
    for i := 0 to PAS_WORDS -1 do
    begin
      if CompareText(WordStr,PASWords[i]) = 0 then
      begin
        ForeClr := clBlue;
        exit;
      end;
    end;
  end
  else if WordType = WD_SYNTAXITEM then
  begin
    { Set text color for syntax words }
    ForeClr := RGB(0,0,192);
    exit;
  end
  else if (WordType = WD_BADLYQUOTEDTEXT) or
          (WordType = WD_QUOTEDTEXT) then
  begin
    { Set text color for quoted text }
    if HiWord(WordValue) = 1 then
      ForeClr := RGB(0,128,0)
    else
      ForeClr := clRed;
    exit;
  end
  else
    { Set text color for the rest of words, that is }
    { for numbers                                   }
    ForeClr := RGB(0,128,0);
end;

procedure TCppPasForm.WndCPPControlHighlight(Sender: TObject;
  WordType: Word; WordValue: Longint; WordStr: String; var ForeClr,
  BackClr: TColor);
var
  MyWord: TWordDesc;
  i: Integer;
begin
  MyWord := WndPAS.WordDesc;
  if WordType = WD_SIMPLEWORD then
  begin
    { Set default text color for words }
    ForeClr := clBlack;
    BackClr := WndPAS.Color;

    { Mark C++ keywords if this is CPP window }
    for i := 0 to CPP_WORDS -1 do
    begin
      if CompareText(WordStr,CPPWords[i]) = 0 then
      begin
        ForeClr := clBlue;
        exit;
      end;
    end
  end
  else if WordType = WD_SYNTAXITEM then
  begin
    { Set text color for syntax words }
    ForeClr := RGB(0,0,192);
    exit;
  end
  else if (WordType = WD_BADLYQUOTEDTEXT) or
          (WordType = WD_QUOTEDTEXT) then
  begin
    { Set text color for quoted text }
    if HiWord(WordValue) = 1 then
      ForeClr := RGB(0,128,0)
    else
      ForeClr := clRed;
    exit;
  end
  else
    { Set text color for the rest of words, that is }
    { for numbers                                   }
    ForeClr := RGB(0,128,0);
end;

procedure TCppPasForm.WndCPPWordClick(Sender: TObject; WordType: Word;
  WordValue: Longint; WordStr: String; var WordHandled: Boolean);
var
  MsgStr: String;
  SyntaxIndex: Word;
begin
  { Show message about word supplied if it exists }
  MsgStr := WordStr;
  MsgStr := MsgStr + #13 + #10;
  if WordType = WD_SYNTAXITEM then
  begin
    SyntaxIndex := HiWord(WordValue);
    MsgStr := MsgStr + 'Syntax: ' + IntToStr(SyntaxIndex);
  end
  else if (WordType and WDF_INTEGER) > 0 then
    MsgStr := MsgStr + 'Integer: ' + IntToStr(WordValue);

  { Display the Message Dialog }
  MessageDlg(MsgStr, mtInformation, [mbOk], 0);
end;

procedure TCppPasForm.WndPASWordClick(Sender: TObject; WordType: Word;
  WordValue: Longint; WordStr: String; var WordHandled: Boolean);
var
  MsgStr: String;
  SyntaxIndex: Word;
begin
  { Show message about word supplied if it exists }
  MsgStr := WordStr;
  MsgStr := MsgStr + #13 + #10;
  if WordType = WD_SYNTAXITEM then
  begin
    SyntaxIndex := HiWord(WordValue);
    MsgStr := MsgStr + 'Syntax: ' + IntToStr(SyntaxIndex);
  end
  else if (WordType and WDF_INTEGER) > 0 then
    MsgStr := MsgStr + 'Integer: ' + IntToStr(WordValue);

  { Display the Message Dialog }
  MessageDlg(MsgStr, mtInformation, [mbOk], 0);
end;

procedure TCppPasForm.WndPASFindBrace(Sender: TObject; WordType: Word;
  WordValue: Longint; WordStr: String; var BraceType: TLEBraceStyle);
var
  SyntaxIndex: Word;
  MyWord: TWordDesc;
begin
  MyWord.wCode := 0;
  MyWord.dwValue := 0;
  StrPCopy(MyWord.caWord, '');
  if WordType = WD_SYNTAXITEM then
  begin
    { Indicate braces for parantheses, brackets etc. }
    SyntaxIndex := HiWord(WordValue);
    if SyntaxIndex > 10 then
    begin
      BraceType := bsNone;
    end;
    if (SyntaxIndex mod 2) = 1 then
    begin
      Inc(SyntaxIndex);
      BraceType := bsRightBrace;
    end
    else
    begin
      Dec(SyntaxIndex);
      BraceType := bsLeftBrace;
    end;
    MyWord.dwValue := MakeLong(0, SyntaxIndex);
  end
  else
  begin
    { Look for "begin" }
    if CompareText(WordStr,PAS_LEFT_BRACE) = 0 then
    begin
      StrPCopy(MyWord.caWord, PAS_RIGHT_BRACE);
      BraceType := bsNoCaseLeftBrace;
    end;

    { Also look for "end" }
    if CompareText(WordStr,PAS_RIGHT_BRACE) = 0 then
    begin
      StrPCopy(MyWord.caWord, PAS_LEFT_BRACE);
      BraceType := bsNoCaseRightBrace;
    end;
  end;
  WndPAS.WordDesc := MyWord;
end;

procedure TCppPasForm.WndCPPFindBrace(Sender: TObject; WordType: Word;
  WordValue: Longint; WordStr: String; var BraceType: TLEBraceStyle);
var
  SyntaxIndex: Word;
  MyWord: TWordDesc;
begin
  MyWord.wCode := 0;
  MyWord.dwValue := 0;
  StrPCopy(MyWord.caWord, '');
  if WordType = WD_SYNTAXITEM then
  begin
    { Indicate braces for parantheses, brackets etc. }
    SyntaxIndex := HiWord(WordValue);
    if SyntaxIndex > 10 then
    begin
      BraceType := bsNone;
    end;
    if (SyntaxIndex mod 2) = 1 then
    begin
      Inc(SyntaxIndex);
      BraceType := bsLeftBrace;
    end
    else
    begin
      Dec(SyntaxIndex);
      BraceType := bsRightBrace;
    end;
    MyWord.dwValue := MakeLong(0, SyntaxIndex);
  end
  else
  begin
    { No more braces for CPP }
    BraceType := bsNone;
  end;
  WndCPP.WordDesc := MyWord;
end;

end.
