// File from page 616 in "Thinking in C++" by Bruce Eckel
//////////////////////////////////////////////////
// From the compressed package ECKELT01.ZIP 2/21/95
// Copyright (c) Bruce Eckel, 1995 
// Source code file from the book "Thinking in C++", 
// Prentice Hall, 1995, ISBN: 0-13-917709-4
// All rights reserved EXCEPT as allowed by the following 
// statements: You may freely use this file for your own 
// work, including modifications and distribution in 
// executable form only. You may copy and distribute this 
// file, as long as it is only distributed in the complete 
// (compressed) package with the other files from this 
// book and you do not remove this copyright and notice. 
// You may not distribute modified versions of the source 
// code in this package. This package may be freely placed 
// on bulletin boards, internet nodes, shareware disks and 
// product vendor disks. You may not use this file in 
// printed media without the express permission of the 
// author. Bruce Eckel makes no 
// representation about the suitability of this software 
// for any purpose. It is provided "as is" without express 
// or implied warranty of any kind. The entire risk as to 
// the quality and performance of the software is with 
// you. Should the software prove defective, you assume 
// the cost of all necessary servicing, repair, or 
// correction. 
// If you think you've found an error, please 
// email all modified files with loudly commented changes 
// to: eckel@aol.com (please use the same 
// address for non-code errors found in the book).
//////////////////////////////////////////////////

//: ASSOC.CPP -- Test of associative array
#include "..\14\assoc.h"
#include "..\14\sstring.h"
#include "..\14\integer.h"
#include "..\allege.h"
#include <fstream.h>
#include <ctype.h>

main() {
  const char* delimiters =
    " \t;()\"<>:{}[]+-=&*#.,/\\";
  assoc_array<SString<80>, integer> strcount;
  ifstream source("assoc.cpp");
  allegefile(source);
  ofstream out("assoc.out");
  allegefile(out);
  const bsz = 255;
  char buf[bsz];
  while(source.getline(buf, bsz)) {
    char* s = strtok(buf, delimiters);
    while(s) {
      strcount[s]++; // Count word
      s = strtok(0, delimiters);
    }
  }
  for(int i = 0; i < strcount.length(); i++) {
    out << strcount.in_value(i) << " : "
         << strcount.out_value(i) << endl;
  }

  // The "shopping list" problem:
  assoc_array<SString<>, integer> shoplist;
  ifstream list("shoplist.txt");
  allegefile(list);
  ofstream olist("shoplist.out");
  allegefile(olist);
  while(list.getline(buf, bsz)) {
    int i = strlen(buf) - 1; // Last char
    while(isspace(buf[i]))
      i--; // Find nonzero char at end
    while(!isspace(buf[i]))
      i--; // Back up to space or tab
    int count = atoi(&buf[i+1]); // Use value
    while(isspace(buf[i]))
      i--; // Back up to non-whitespace
    buf[i+1] = 0; // Mark end of description
    i = 0;
    while(isspace(buf[i]))
      i++; // Find start of first word
    shoplist[&buf[i]] += count;
  }
  for(int j = 0; j < shoplist.length(); j++) {
    olist << shoplist.in_value(j) << " : "
          << shoplist.out_value(j) << endl;
  }
}
