/**************************************************************************************************

    SPELTEST
    Program to test spelling checker.

    Written and copyright by Brian J Quinion 1995.

    Version for Microsoft Windows.
    Version:  0.01 (Production)
    Date:     19 Feb 1995
    Module:   ST-WND-M.C

**************************************************************************************************/

    /* include files common to all modules */
#define EXTERN extern
	#include "speltest.h"

	/* include files for this module only */
	#pragma  hdrstop
	/* NONE */

/***************************************************************************************************

	RegisterSPELTEST_MAIN
	---------------------
	Register window class 'SPELTEST_MAIN'

	Parameters : None
	Called by  : WinMain on initialisation
	Calls      : Nothing
	Modifies   : Nothing
	Returns    : Nothing

***************************************************************************************************/
void RegisterSPELTEST_MAIN(void)
{
    WNDCLASS    wndclass;

    wndclass.style         = CS_HREDRAW | CS_VREDRAW;
    wndclass.lpfnWndProc   = (WNDPROC)SPELTEST_MAINWndProc;
    wndclass.cbClsExtra    = 0;
    wndclass.cbWndExtra    = 0;
    wndclass.hInstance     = g.hInst;
    wndclass.hIcon         = LoadIcon(g.hInst, "SPELTEST_MAIN");
    wndclass.hCursor       = LoadCursor(NULL, IDC_ARROW);
    wndclass.hbrBackground = CreateSolidBrush(RGB(0,0,0));
    wndclass.lpszMenuName  = "SPELTEST_MAIN";
    wndclass.lpszClassName = "SPELTEST_MAIN";
    RegisterClass(&wndclass);
}

/***************************************************************************************************

	SPELTEST_MAINWndProc
	-----------------
	To handle messages to 'SPELTEST_MAIN' class

	Parameters : WND standard
	Called by  : Windows
	Calls      : 
	Modifies   : 
	Returns    : Depends on calling parameters

***************************************************************************************************/
#pragma argsused
long FAR PASCAL SPELTEST_MAINWndProc(HWND hWnd, UINT wMsg, WORD wParam, LONG lParam)
{
    PAINTSTRUCT			ps;

// Quick
    HINSTANCE                   hModSpelledt;
    BOOL (WINAPI FAR * LINK_SPEDT_CheckEdit)(HWND);
    void (WINAPI FAR * LINK_SPEDT_SetupBox)(HWND);

// Full - see how much more of it there is! :-)
    static HWND                 hWndEdit;
    CHECKWORD                   CheckWord;
    LPCUSTDIC                   lpCustDic;
    char			GetCustPath[]="Path???";
    char			GetCustName[]="Name???";
    char			GetCustOpts[]="Opts???";
    int                         Count;
    HINSTANCE                   hModSpellchk;
    BOOL (WINAPI FAR * LINK_SPCHK_CheckWord)(LPCHECKWORD);
    void (WINAPI FAR * LINK_SPCHK_Options)(LPCHECKWORD);

    static char                 Words[6][15]={"thiss",
                                            "poeple",
                                            "aggrivation",
                                            "enviromental",
                                            "wheight",
                                            "nohting"};
    LPCHECKWORD                 lpchkw;
    WORD                        wIndex;
    char                        Text[100];
    static BOOL                 bCanUndo;
    static HUNDO                hUndoHandle;
    static WORD                 wUndoIndex;
    static char                 szPreviousWord[MAXSPELL];

// Shared
    char                        FileName[MAXPATH];

    switch(wMsg)
    {
    case WM_CREATE:
        hWndEdit=CreateWindow("EDIT", NULL, ES_LEFT | ES_MULTILINE | ES_AUTOVSCROLL | ES_NOHIDESEL | ES_OEMCONVERT | ES_WANTRETURN | WS_CHILD | WS_VISIBLE | WS_VSCROLL | WS_TABSTOP,
	                         0, 0, 400, 200, hWnd, -1, g.hInst, NULL);
        break;
        
    case WM_PAINT:
        // kill paint messages to stop them looping
	BeginPaint(hWnd, &ps);
	EndPaint(hWnd, &ps);
	return 0;

    case WM_SYSCOLORCHANGE:
	return 0;

    case WM_COMMAND:
	switch(wParam)
	{
// Quick 
        case MLC_CHECKEDIT:
            // Load the checkedt module - done like this so that the program
            // could run without having the spelledt module available
            // Loading a Lib file in the project would result in an error
            // if the module was no available.

            // Get the path and try to load the module
            GetPrivateProfileString("Modules", "spelledt", "spelledt.dll", FileName, MAXPATH, "Spelledt.ini");
            hModSpelledt=LoadLibrary(FileName);
            if (hModSpelledt<HINSTANCE_ERROR)
            {
                MessageBox(hWnd, "Unable to load the module 'spelledt.dll'", "Spell setup", MB_ICONSTOP);
                return 0;
            }

            // Get the address of the function and call it
            (FARPROC)LINK_SPEDT_CheckEdit=GetProcAddress(hModSpelledt, "SPEDT_CheckEdit");
            if (LINK_SPEDT_CheckEdit==NULL)
                MessageBox(hWnd, "Unable to load the function 'SPEDT_CheckEdit', progably due to an incompatable version.  Please check your system for multiple versions of 'spelledt.dll'.", "Spell setup", MB_ICONSTOP);
            else
                (LINK_SPEDT_CheckEdit)(hWndEdit); // spell check the edit box

            // Free the module and finish
            FreeModule(hModSpelledt);
            return 0;

        case MLC_SETUPEDIT:
            // Load the checkedt module, but for a different function.

            // Get the path and try to load the module
            GetPrivateProfileString("Modules", "spelledt", "spelledt.dll", FileName, MAXPATH, "Spelledt.ini");
            hModSpelledt=LoadLibrary(FileName);
            if (hModSpelledt<HINSTANCE_ERROR)
            {
                MessageBox(hWnd, "Unable to load the module 'spelledt.dll'", "Spell setup", MB_ICONSTOP);
                return 0;
            }

            // Get the address of the function and call it
            (FARPROC)LINK_SPEDT_SetupBox=GetProcAddress(hModSpelledt, "SPEDT_SetupBox");
            if (LINK_SPEDT_SetupBox==NULL)
                MessageBox(hWnd, "Unable to load the function 'SPEDT_SetupBox', probably due to an incompatable version.  Please check your system for multiple versions of 'spelledt.dll'.", "Spell setup", MB_ICONSTOP);
            else
                (LINK_SPEDT_SetupBox)(hWnd); // spell check the edit box

            // Free the module and finish
            FreeModule(hModSpelledt);
            return 0;

// Full
        case MLC_CHECKWORDS:
            // Build the checkword block
	    CheckWord.wSizeOfBlock     = sizeof(CHECKWORD);
	    CheckWord.hWndParent       = hWnd;  // window that msg are sent to
	    CheckWord.hInstance        = g.hInst;
	    CheckWord.lpOptionsDlg     = "SPELTEST_OPTIONSBOX";
	    CheckWord.CheckWordOptions = CWO_ALLOWCHANGE    // Do display the box if a word not found
                                       | CWO_CHECKMULTIPLE  // Send GETNEXT messages
                                       | CWO_USEOPTIONSHOOK // Do use the options hook
                                       | CWO_USECUSTOMOPTIONSDLG // and use our dialog box 
                                       | CWO_NOHELP         // No help available
                                       | CWO_UNDO           // Undo is handled
                                       | CWO_AUTOSUGGEST;    // Please auto suggest
	    CheckWord.dwCustData  = 0; // Index of the first word to check
	    CheckWord.fpOptionsHook  = (DLGPROC)MakeProcInstance(DLG_OptionsBox, g.hInst);

            // Get the current language from the one selected by spelledt
	    GetPrivateProfileString("Options", "Language", "", CheckWord.szLanguage, 13, "spelledt.ini");

	    // Load custom dictionaries, in this case we will share the ones that are used by
            // spelledt (i.e. the edit box one).
	    CheckWord.NumCustom=GetPrivateProfileInt("Custom", "Number", 0, "spelledt.ini");
	    CheckWord.CurCustom=GetPrivateProfileInt("Custom", "Current", 0, "spelledt.ini");
	    if (CheckWord.NumCustom!=0)
            {
		CheckWord.hCustomDics = GlobalAlloc(GHND | GMEM_DDESHARE, sizeof(CUSTDIC)*CheckWord.NumCustom);
		lpCustDic = (LPCUSTDIC)GlobalLock(CheckWord.hCustomDics);
		for (Count=0; Count<CheckWord.NumCustom; Count++)
	        {
		    itoa(Count, GetCustPath+4, 10);
		    itoa(Count, GetCustName+4, 10);
		    itoa(Count, GetCustOpts+4, 10);
		    GetPrivateProfileString("Custom", GetCustPath, "custom.dic", (lpCustDic+Count)->DicFile, MAXPATH, "spelledt.ini");
		    GetPrivateProfileString("Custom", GetCustName, "Custom", (lpCustDic+Count)->DicTitle, MAXDICTITLE, "spelledt.ini");
		    (lpCustDic+Count)->Options=GetPrivateProfileInt("Custom", GetCustOpts, CD_CHANGED, "spelledt.ini");
		}
		GlobalUnlock(CheckWord.hCustomDics);
            }

            // Reset the undo pointer
            bCanUndo=FALSE;

            // Load the checkchk module.

            // Get the path and try to load the module
            GetPrivateProfileString("Modules", "spellchk", "spellchk.dll", FileName, MAXPATH, "Spelledt.ini");
            hModSpellchk=LoadLibrary(FileName);
            if (hModSpellchk<HINSTANCE_ERROR)
            {
                MessageBox(hWnd, "Unable to load the module 'spellchk.dll'", "Spell setup", MB_ICONSTOP);
                return 0;
            }

            // Get the address of the function and call it
            (FARPROC)LINK_SPCHK_CheckWord=GetProcAddress(hModSpellchk, "SPCHK_CheckWord");
            if (LINK_SPCHK_CheckWord==NULL)
                MessageBox(hWnd, "Unable to load the function 'SPCHK_CheckWord', probably due to an incompatable version.  Please check your system for multiple versions of 'spellchk.dll'.", "Spell setup", MB_ICONSTOP);
            else
                (LINK_SPCHK_CheckWord)(&CheckWord); // spell check the edit box

            // Free the module
            FreeModule(hModSpellchk);

	    // Free ProcInstance for the options hook
	    FreeProcInstance(CheckWord.fpOptionsHook);

            // Store the language
	    WritePrivateProfileString("Options", "Language", CheckWord.szLanguage, "spelledt.ini");

	    // Save any changes to the custom dics
	    lpCustDic = (LPCUSTDIC)GlobalLock(CheckWord.hCustomDics);
	    WritePrivateProfileInt("Custom", "Number", CheckWord.NumCustom, "spelledt.ini");
	    WritePrivateProfileInt("Custom", "Current", CheckWord.CurCustom, "spelledt.ini");
	    for (Count=0; Count<CheckWord.NumCustom; Count++)
	    {
		itoa(Count, GetCustPath+4, 10);
		itoa(Count, GetCustName+4, 10);
		itoa(Count, GetCustOpts+4, 10);
		WritePrivateProfileString("Custom", GetCustPath, (lpCustDic+Count)->DicFile, "spelledt.ini");
		WritePrivateProfileString("Custom", GetCustName, (lpCustDic+Count)->DicTitle, "spelledt.ini");
		WritePrivateProfileInt("Custom", GetCustOpts, (lpCustDic+Count)->Options, "spelledt.ini");
            }
	    GlobalUnlock(CheckWord.hCustomDics);
	    GlobalFree(CheckWord.hCustomDics);

            // finish
            return 0;

        case MLC_SETUPWORDS:
            // Build the checkword block
	    CheckWord.wSizeOfBlock     = sizeof(CHECKWORD);
	    CheckWord.hWndParent       = hWnd;  // window that msg are sent to
	    CheckWord.hInstance        = g.hInst;
	    CheckWord.lpOptionsDlg     = "SPELTEST_OPTIONSBOX";
	    CheckWord.CheckWordOptions = CWO_ALLOWCHANGE    // Do display the box if a word not found
                                       | CWO_CHECKMULTIPLE  // Send GETNEXT messages
                                       | CWO_USEOPTIONSHOOK // Do use the options hook
                                       | CWO_USECUSTOMOPTIONSDLG // and use our dialog box
                                       | CWO_NOHELP         // No help available
                                    // | CWO_UNDO           // not needed
                                       | CWO_AUTOSUGGEST;    // Please auto suggest
	    CheckWord.dwCustData  = 0; // not used (by this prog, it is still there is you want it)
	    CheckWord.fpOptionsHook  = (DLGPROC)MakeProcInstance(DLG_OptionsBox, g.hInst);

            // Get the current language from the one selected by spelledt
	    GetPrivateProfileString("Options", "Language", "", CheckWord.szLanguage, 13, "spelledt.ini");

	    // Load custom dictionaries, in this case we will share the ones that are used by
            // spelledt (i.e. the edit box one).
	    CheckWord.NumCustom=GetPrivateProfileInt("Custom", "Number", 0, "spelledt.ini");
	    CheckWord.CurCustom=GetPrivateProfileInt("Custom", "Current", 0, "spelledt.ini");
	    if (CheckWord.NumCustom!=0)
            {
		CheckWord.hCustomDics = GlobalAlloc(GHND | GMEM_DDESHARE, sizeof(CUSTDIC)*CheckWord.NumCustom);
		lpCustDic = (LPCUSTDIC)GlobalLock(CheckWord.hCustomDics);
		for (Count=0; Count<CheckWord.NumCustom; Count++)
	        {
		    itoa(Count, GetCustPath+4, 10);
		    itoa(Count, GetCustName+4, 10);
		    itoa(Count, GetCustOpts+4, 10);
		    GetPrivateProfileString("Custom", GetCustPath, "custom.dic", (lpCustDic+Count)->DicFile, MAXPATH, "spelledt.ini");
		    GetPrivateProfileString("Custom", GetCustName, "Custom", (lpCustDic+Count)->DicTitle, MAXDICTITLE, "spelledt.ini");
		    (lpCustDic+Count)->Options=GetPrivateProfileInt("Custom", GetCustOpts, CD_CHANGED, "spelledt.ini");
		}
		GlobalUnlock(CheckWord.hCustomDics);
            }

            // Load the checkchk module.
            // Get the path and try to load the module
            GetPrivateProfileString("Modules", "spellchk", "spellchk.dll", FileName, MAXPATH, "Spelledt.ini");
            hModSpellchk=LoadLibrary(FileName);
            if (hModSpellchk<HINSTANCE_ERROR)
            {
                MessageBox(hWnd, "Unable to load the module 'spellchk.dll'", "Spell setup", MB_ICONSTOP);
                return 0;
            }

            // Get the address of the function and call it
            (FARPROC)LINK_SPCHK_Options=GetProcAddress(hModSpellchk, "SPCHK_Options");
            if (LINK_SPCHK_Options==NULL)
                MessageBox(hWnd, "Unable to load the function 'SPCHK_Options', probably due to an incompatable version.  Please check your system for multiple versions of 'spellchk.dll'.", "Spell setup", MB_ICONSTOP);
            else
                (LINK_SPCHK_Options)(&CheckWord); // spell check the edit box

            // Free the module
            FreeModule(hModSpellchk);

	    // Free ProcInstance for the options hook
	    FreeProcInstance(CheckWord.fpOptionsHook);

            // Store the language
	    WritePrivateProfileString("Options", "Language", CheckWord.szLanguage, "spelledt.ini");

	    // Save any changes to the custom dics
	    lpCustDic = (LPCUSTDIC)GlobalLock(CheckWord.hCustomDics);
	    WritePrivateProfileInt("Custom", "Number", CheckWord.NumCustom, "spelledt.ini");
	    WritePrivateProfileInt("Custom", "Current", CheckWord.CurCustom, "spelledt.ini");
	    for (Count=0; Count<CheckWord.NumCustom; Count++)
	    {
		itoa(Count, GetCustPath+4, 10);
		itoa(Count, GetCustName+4, 10);
		itoa(Count, GetCustOpts+4, 10);
		WritePrivateProfileString("Custom", GetCustPath, (lpCustDic+Count)->DicFile, "spelledt.ini");
		WritePrivateProfileString("Custom", GetCustName, (lpCustDic+Count)->DicTitle, "spelledt.ini");
		WritePrivateProfileInt("Custom", GetCustOpts, (lpCustDic+Count)->Options, "spelledt.ini");
            }
	    GlobalUnlock(CheckWord.hCustomDics);
	    GlobalFree(CheckWord.hCustomDics);

            // finish
            return 0;
	}
        break;

    case SPELL_GETNEXT:
        // Get the pointer
        lpchkw = (LPCHECKWORD)lParam;
        wIndex = (WORD)lpchkw->dwCustData;

        // Have we done all the words?
        if (wIndex>5)
            return FALSE;

        // Copy over the word
        lstrcpy(lpchkw->ToCheck, Words[wIndex]);

        // increment the count
        lpchkw->dwCustData++;
        return TRUE;

    case SPELL_WORDNOTFOUND:
        // Get the pointer
        lpchkw = (LPCHECKWORD)lParam;

        // Display the word not found
        wsprintf(Text, "The word %s was not found", lpchkw->ToCheck);
        MessageBox(hWnd, Text, "Test Word", MB_ICONINFORMATION);
        return 0;

    case SPELL_WORDCHANGED:
        // Get the pointer
        lpchkw = (LPCHECKWORD)lParam;
        wIndex = (WORD)lpchkw->dwCustData;

        // Change the word
        lstrcpy(Words[wIndex-1], lpchkw->Changed);

        // Display the word changed
        wsprintf(Text, "The word %s has been changed to %s",
                   lpchkw->ToCheck, lpchkw->Changed);
        MessageBox(hWnd, Text, "Test Word", MB_ICONHAND);
        return 0;

    case SPELL_CANUNDO:
        // Just return the bUndo flag
        return bCanUndo;

    case SPELL_STOREUNDO:
        // Get the pointer
        lpchkw = (LPCHECKWORD)lParam;

        // Yes we can now undo
        bCanUndo=TRUE;

        // Store the handle provided by spellchk
        hUndoHandle=(HUNDO)wParam;

        // Store the current word being checked
        wUndoIndex=lpchkw->dwCustData-1;
        lstrcpy(szPreviousWord, lpchkw->ToCheck);
        return 0;

    case SPELL_UNDOLAST:
        // Get the pointer
        lpchkw = (LPCHECKWORD)lParam;

        // Do the undo if we can - see the full example app for
        // more details
        if (bCanUndo)
        {
            // Do the undo
            lstrcpy(Words[wUndoIndex], szPreviousWord);

            // Reposition the index to restart at the pervious position
            lpchkw->dwCustData=wUndoIndex;

            // Store the undo handle in the dialog result register
            SetWindowLong(lpchkw->hWndDlg, DWL_MSGRESULT, hUndoHandle);

            // Since we have undone once we can't do it again
            bCanUndo=FALSE;
        
            // Return a positive answer
            return FALSE;
        }
        return TRUE;

    case SPELL_GETCUSTOMDEFPATH:
	lstrcpy((LPSTR)lParam, g.szProgDir);
	return TRUE;

    case WM_CLOSE:
	break;

    case WM_DESTROY:
	PostQuitMessage(0);
        break;
    }
return DefWindowProc(hWnd, wMsg, wParam, lParam);
}

/***************************************************************************************************

	DLG_OptionsBox
	--------------
	Function to handle hooking the options box

	Parameters : DLG standard
	Called by  : Windows OS
	Calls      : Nothing
	Modifies   : Nothing
	Returns    : Nothing

***************************************************************************************************/
#pragma argsused
BOOL FAR PASCAL _export DLG_OptionsBox(HWND hDlg, UINT msg, WORD wParam, LONG lParam)
{
    switch(msg)
    {
    case WM_COMMAND:
        switch(wParam)
        {
        case ST_DEMOBUTTON:
            MessageBox(hDlg, "You have hit the test button", "Test Word", MB_ICONINFORMATION);
            return FALSE;
	}
    }
return FALSE;
}
