// cktblctr.cpp : implementation file
//

#include "stdafx.h" 
#include "cktblctr.h"
          
#ifdef _DEBUG
#undef THIS_FILE
static char BASED_CODE THIS_FILE[] = __FILE__;
#endif
     
struct CKTBLPrintStruct {
	CFont	cellFont,labelFont;
	CPoint	cellInset;
	int		thinlinex;
	int		thinliney; 
	int		logpixelSX;
	int		logpixelSY;
	};                
       
IMPLEMENT_DYNCREATE( CCKTBLControl, CWnd )
                                    
/////////////////////////////////////////////////////////////////////////////
// CCKTBLControl

CCKTBLControl::CCKTBLControl()
{
}

CCKTBLControl::~CCKTBLControl()
{
	DestroyWindow();
}  
   
BOOL CCKTBLControl::Create(DWORD dwStyle, const RECT& rect, CWnd* pParentWnd )
{
	return CWnd::Create(CKTBL_CLASS, NULL, dwStyle, rect, pParentWnd, NULL);
}

WNDPROC* CCKTBLControl::GetSuperWndProcAddr()
{   
	static WNDPROC NEAR pfnSuper;
	return &pfnSuper;
}          
  
/////////////////////////////////////////////////////////////////////////////
// High Level CCKTBLControl Operations
                                  
void CCKTBLControl::AddFlags( DWORD flags )
{                
	SetFlags( GetFlags() | flags );
}

void CCKTBLControl::RemoveFlags( DWORD flags )
{
	SetFlags( GetFlags() & ~flags );
}
     
void CCKTBLControl::SetFlagsTo( DWORD flags, BOOL value )
{
	if(value)
		AddFlags(flags);
	else
		RemoveFlags(flags);
}
     
void CCKTBLControl::GetText( int row, int col, CString * text )
{                 
	int length;
	LPSTR buffer;
	                                
	length = GetTextLength(row,col)+1;
	buffer = text->GetBuffer( length );
	GetText( row, col, buffer, length );
	text->ReleaseBuffer();
}       

void CCKTBLControl::UpdateSelectionRowHeighths()
{   
	int sel, nsel, row, height;
	CRect rect;
	
	nsel = GetSelectionSize();
	for(sel=1; sel<=nsel; sel++) {
		GetSelection( &rect, sel );
		for( row=rect.top; row<=rect.bottom; row++) { 
			//UpdateRowHeight(row);
			height = GetRowTextHeight( row, -1 );
			if( GetRowHeight( row ) != height ) SetRowHeight( row, height );
		}

	}
}
                   
/////////////////////////////////////////////////////////////////////////////
//  CCKTBLControl Printing
                                  
 
void CCKTBLControl::OnPrint( CDC* pDC, CPrintInfo* pInfo )
{               
 	DrawTable( pDC, pInfo );
}   
  
void CCKTBLControl::OnBeginPrinting(CDC* pDC, CPrintInfo* pInfo)
{
	// page rectangle is not set when MFC calls OnBeginPrinting
         
	pInfo->m_rectDraw.SetRect( 0,0,pDC->GetDeviceCaps(HORZRES),pDC->GetDeviceCaps(VERTRES));
	pDC->DPtoLP(&pInfo->m_rectDraw);
  
}  

void CCKTBLControl::Paginate(CDC* pDC, CPrintInfo* pInfo)
{
	// Purpose: This routine paginates the table for the current CDC specified.
	// It stores the number of pages in pInfo

	int 		sx, sy, sxCKTBL, syCKTBL;
	CWindowDC 	tempDC(this); 				// nur um sxCKTBL,syCKTBL zu ermitteln
	CRect		cells;						// rectangle of cells to print
	int			row, col;   
	int			rows, cols;  
	int			currentx, currenty;  		// current pos when drawing in printer coordinates
	int			colSize, rowSize;          	// dimensions of current row and column in printer coordinates
	int			page;
	BOOL		morePages;
     
	// get dc capabilities of target and CKTBL dc
	        
	sx = pDC->GetDeviceCaps( LOGPIXELSX );
	sy = pDC->GetDeviceCaps( LOGPIXELSY ); 
	sxCKTBL = tempDC.GetDeviceCaps( LOGPIXELSX );
	syCKTBL = tempDC.GetDeviceCaps( LOGPIXELSY ); 
	                         
	rows = GetRows();
	cols = GetColumns();
	
	// paginate
	cells.SetRect( 0, 0, 0, 0 );
	row = 0; 
	col = 0; 

	for( page = 0,morePages = TRUE; morePages; page++ ) 
	{
        // go down one page from row 
        
   	    cells.top = row;
		currenty = pInfo->m_rectDraw.top; 
		for( ; row<=rows && currenty<pInfo->m_rectDraw.bottom; row++ ) {
	 		rowSize = GetRowHeight(row);
			rowSize = (int)((long)rowSize*sy/syCKTBL);	// convert from CKTBL to printer coord
    		currenty += rowSize;
		}                          
	    row--;        
	    if( currenty > pInfo->m_rectDraw.bottom ) {
	    	row--;	
	    } 
	    cells.bottom = min(row,rows); 
		row = cells.top;
	
		// go left one page from col
  
  		cells.left = col;	                      
   		currentx = pInfo->m_rectDraw.left;
    	for( ; col<=cols && currentx<pInfo->m_rectDraw.right; col++ ) { 
	    	colSize = GetColumnWidth(col);
			colSize = (int)((long)colSize*sx/sxCKTBL);	// convert from CKTBL to printer coord
          	currentx += colSize;
        }       
        col--;                         
 	    if( currentx > pInfo->m_rectDraw.right ) {
	    	col--;	
	    } 
	    cells.right = min(col,cols); 
		col = cells.right + 1;        	    	

		// move right one page
		// move down one page if at leftmost page
		// end printjob if at last page
		
		if(col>cols) {
			col = 0;
			row = cells.bottom+1;
			if( row>rows ) morePages = FALSE;
	    }
	}   	
	pInfo->SetMaxPage( page );	
}
    
void CCKTBLControl::SetMargins( CDC *pDC, CPrintInfo * pInfo, int left, int top, int right, int bottom )
{
	int sx = pDC->GetDeviceCaps( LOGPIXELSX );
	int sy = pDC->GetDeviceCaps( LOGPIXELSY );
	
	pInfo->m_rectDraw.left 		+= (int)((long)left * sx * 10 / 254);
	pInfo->m_rectDraw.top 		+= (int)((long)top * sy * 10 / 254);
	pInfo->m_rectDraw.right 	-= (int)((long)right * sx * 10 / 254);
	pInfo->m_rectDraw.bottom 	-= (int)((long)bottom * sy * 10 / 254);
}
              
void CCKTBLControl::DrawTable(CDC* pDC, CPrintInfo* pInfo )
{         
	int 		sx, sy, sxCKTBL, syCKTBL;
	CWindowDC 	tempDC(this); 				// nur um sxCKTBL,syCKTBL zu ermitteln
	CSize		pageSize;                   // size of page
	CRect		cells;						// rectangle of cells to print
	int			row, col;   
	int			rows, cols;  
	int			currentx, currenty;  		// current pos when drawing in printer coordinates
	int			colSize, rowSize;          	// dimensions of current row and column in printer coordinates
	CRect		cellRect;					// coordinates of current cell in printer coordinates
	CKTBLPrintStruct ps;     
	CPen		grayPen, blackPen, * oldPen;    
	CRect		pageRect;					// page excluding labels   
	int			page;
	BOOL		morePages;


	// get dc capabilities of target and CKTBL dc
	           
	sx = pDC->GetDeviceCaps( LOGPIXELSX );
	sy = pDC->GetDeviceCaps( LOGPIXELSY ); 
	sxCKTBL = tempDC.GetDeviceCaps( LOGPIXELSX );
	syCKTBL = tempDC.GetDeviceCaps( LOGPIXELSY ); 
	                         
	// create gdi objects and fill paint structure	                         
	                         
	ps.cellInset.x = 2 * sx / sxCKTBL;
	ps.cellInset.y = 2 * sy / syCKTBL;  
	ps.logpixelSX = sx;
	ps.logpixelSY = sy;
	ps.thinlinex =  (int)((long)sx / 254);		// 1/10 mm
	ps.thinliney = 	(int)((long)sy / 254);		// 1/10 mm
	         
	//	BOOL CreateFont( int nHeight, int nWidth, int nEscapement, 
	//		int nOrientation, int nWeight, BYTE bItalic, BYTE bUnderline, 
	//		BYTE cStrikeOut, BYTE nCharSet, BYTE nOutPrecision, 
	//		BYTE nClipPrecision, BYTE nQuality, BYTE nPitchAndFamily,  
	//		LPCSTR lpszFacename );                                
                                
	ps.cellFont.CreateFont( 10*sy/72,0,0,0,FW_NORMAL,0,0,0,0,OUT_TT_PRECIS,0,0,0,"MS Sans Serif");
	ps.labelFont.CreateFont( 10*sy/72,0,0,0,FW_BOLD,0,0,0,0,OUT_TT_PRECIS,0,0,0,"MS Sans Serif");
	        
	rows = GetRows();
	cols = GetColumns();
	
	// move to page to print by paginating
	
	cells.SetRect( 0, 0, 0, 0 );
	row = 0; 
	col = 0; 

	for( page = 0,morePages = TRUE;
		 page!=(int)pInfo->m_nCurPage && morePages;
		 page++ ) 
	{
        // go down one page from row 
        
   	    cells.top = row;
		currenty = pInfo->m_rectDraw.top; 
		for( ; row<=rows && currenty<pInfo->m_rectDraw.bottom; row++ ) {
	 		rowSize = GetRowHeight(row);
			rowSize = (int)((long)rowSize*sy/syCKTBL);	// convert from CKTBL to printer coord
    		currenty += rowSize;
		}                          
	    row--;        
	    if( currenty > pInfo->m_rectDraw.bottom ) {
	    	row--;	
	    } 
	    cells.bottom = min(row,rows); 
		row = cells.top;
	
		// go left one page from col
  
  		cells.left = col;	                      
   		currentx = pInfo->m_rectDraw.left;
    	for( ; col<=cols && currentx<pInfo->m_rectDraw.right; col++ ) { 
	    	colSize = GetColumnWidth(col);
			colSize = (int)((long)colSize*sx/sxCKTBL);	// convert from CKTBL to printer coord
          	currentx += colSize;
        }       
        col--;                         
 	    if( currentx > pInfo->m_rectDraw.right ) {
	    	col--;	
	    } 
	    cells.right = min(col,cols); 
		col = cells.right + 1;        	    	

		// move right one page
		// move down one page if at leftmost page
		// end printjob if at last page
		
		if(col>cols) {
			col = 0;
			row = cells.bottom+1;
			if( row>rows ) 	morePages = FALSE;
	    }
	}   
    
	// paint table
	// range of cells on this page is in 'cells'
	
	pageRect.SetRect( 0,0,0,0 );        
        
    currenty = pInfo->m_rectDraw.top;
	for( row=cells.top; row<=cells.bottom; row++ ) {
 		rowSize = GetRowHeight(row);
		rowSize = (int)((long)rowSize*sy/syCKTBL);	// convert from CKTBL to printer coord
    	 
	   	currentx = pInfo->m_rectDraw.left;
    	for( col=cells.left; col<=cells.right; col++ ) { 
    		colSize = GetColumnWidth(col);
			colSize = (int)((long)colSize*sx/sxCKTBL);	// convert from CKTBL to printer coord
 	        
			cellRect.SetRect( currentx, currenty, currentx+colSize, currenty+rowSize);
			DrawCell(pDC,row,col,&cellRect, &ps );

 	        currentx += colSize;
	    }
	    currenty += rowSize;
	}
	
	// Draw gridlines
                              
	pageRect.left = pInfo->m_rectDraw.left; // + (int)((long)(cktbl.GetColumnWidth(0))*sx/sxCKTBL);
	pageRect.top =  pInfo->m_rectDraw.top;	// + (int)((long)(cktbl.GetRowHeight(0))*sy/syCKTBL);
 	pageRect.right = currentx;                              	
   	pageRect.bottom = currenty;   
      
	grayPen.CreatePen( PS_SOLID, (ps.thinlinex+ps.thinliney)/2, RGB(0,0,0));
	blackPen.CreatePen( PS_SOLID,(ps.thinlinex+ps.thinliney)/2, RGB(0,0,0));
	oldPen = pDC->SelectObject( &grayPen );
	 
	currenty = pInfo->m_rectDraw.top;
	for( row=cells.top; row<=cells.bottom; row++ ) {
 		rowSize = GetRowHeight(row);
		rowSize = (int)((long)rowSize*sy/syCKTBL);	// convert from CKTBL to printer coord
		pDC->MoveTo( pageRect.left, currenty );
		pDC->LineTo( pageRect.right, currenty );
	   	currenty += rowSize;
	}  
	pDC->MoveTo( pageRect.left, currenty );
	pDC->LineTo( pageRect.right, currenty );
	
	currentx = pInfo->m_rectDraw.left;
	for( col=cells.left; col<=cells.right; col++ ) { 
		colSize = GetColumnWidth(col);
		colSize = (int)((long)colSize*sx/sxCKTBL);	// convert from CKTBL to printer coord
		pDC->MoveTo( currentx, pageRect.top );
		pDC->LineTo( currentx, pageRect.bottom  );
		currentx += colSize;
	}
	pDC->MoveTo( currentx, pageRect.top );
	pDC->LineTo( currentx, pageRect.bottom  );
	
	pDC->SelectObject( oldPen );	    
}     
  
void CCKTBLControl::DrawCell(CDC * pDC, int row, int col, CRect * rectArg, CKTBLPrintStruct * ps )
{        
	CKTBL_ATTRIB 	attrib;   
	CString 		text;         
	CFont	        *font;
	WORD			wFormat;      
	CRect			rect;
	int				x,y;
	HFONT			hFont,hOldFont;
	                  
	GetAttr( row, col, &attrib );
	GetText( row, col, &text );     
	   	 
 	rect.SetRect( rectArg->left, rectArg->top, rectArg->right, rectArg->bottom );	               
	rect.left 	+= ps->cellInset.x;
	rect.top 	+= ps->cellInset.x;
	rect.right	-= ps->cellInset.y;
	rect.bottom	-= ps->cellInset.y;

	font = (row==0 || col==0) ? &ps->labelFont : &ps->cellFont;     
	hFont = (HFONT)font->GetSafeHandle();
	hOldFont = (HFONT) ::SelectObject( pDC->m_hDC, hFont );
	
	if((attrib.format & CKTBL_FMT_MULTI_LINE)) {
		// multiline cells
		wFormat = DT_NOPREFIX;
		if( attrib.format & CKTBL_FMT_WORDBREAK ) wFormat |= DT_WORDBREAK;
		switch( attrib.format & CKTBL_MASK_HALIGN) {
			case CKTBL_FMT_CENTER:  wFormat |= DT_CENTER; break;
			case CKTBL_FMT_LEFT:    wFormat |= DT_LEFT;	break;
			case CKTBL_FMT_RIGHT: 	wFormat |= DT_RIGHT; break;
		}
		pDC->SetTextAlign( 0 );  			// DrawText or's this with wFormat
		pDC->SetBkMode( TRANSPARENT );
		pDC->DrawText( text, -1, &rect, wFormat);
	} else {
		// singleline cells
		if((attrib.format & CKTBL_MASK_VALIGN)==CKTBL_FMT_TOP) {
			wFormat = TA_TOP;
			y = rect.top;
		} else {
			wFormat = TA_BOTTOM;
			y = rect.bottom;
		}
		switch( attrib.format & CKTBL_MASK_HALIGN) {
			case CKTBL_FMT_CENTER:
				wFormat |= TA_CENTER;
				x = (rect.left + rect.right)/2;
				break;
			case CKTBL_FMT_RIGHT:
				wFormat |= TA_RIGHT;
				x = rect.right;
				break;
			case CKTBL_FMT_LEFT: default:
				wFormat |= TA_LEFT;
				x = rect.left;
				break;
		}   
		pDC->SetBkMode( TRANSPARENT );
		pDC->SetTextAlign( wFormat );
		pDC->ExtTextOut( x,y, ETO_CLIPPED, &rect, text, strlen(text), NULL );
	}
	::SelectObject( pDC->GetSafeHdc(), hOldFont );
}
    
     
/////////////////////////////////////////////////////////////////////////////
//  CArchiveReadStream reads tab delimited chunks from an archive 
//  
   
class CArchiveReadStream : public CObject {
public:   
	CArchiveReadStream();
	~CArchiveReadStream();
	    	
	void ResetOn( CArchive &ar );
	BOOL FillBuffer();
	BOOL AtEOF()	{ return lastBuffer && bp>=bufferTail; }
	BOOL GetNextChunk( char *chunk, int max ); 
	BOOL SkipToNextLine();
	
protected:   
	int bufferSize;
	char *buffer, *bufferTail, *bp;
	CArchive * ar;          
	int	lastBuffer;
};
           
CArchiveReadStream::CArchiveReadStream()
{             
	bufferSize = 8192;                  
	buffer=(char*)malloc(bufferSize); 
}

CArchiveReadStream::~CArchiveReadStream()
{
	free(buffer);
}        
        
void CArchiveReadStream::ResetOn( CArchive &theArchive )
{
	ar = &theArchive; 
	lastBuffer=FALSE;
	bp=bufferTail=buffer;
	FillBuffer(); 
}                             

BOOL CArchiveReadStream::FillBuffer()
{     
	int bytes;
	
	if(AtEOF()) return FALSE;
	bytes = ar->Read( buffer, bufferSize ); 
	bufferTail = buffer+bytes;
	bp = buffer;      
	lastBuffer=(bytes<bufferSize);
	return !AtEOF();
}

BOOL CArchiveReadStream::GetNextChunk( char *chunk, int max )
{
	char *src, *dst; 
	int copy;
	
	if(AtEOF()) return FALSE;               
	if(bp>=bufferTail && !FillBuffer()) return FALSE;
	if(*bp=='\r' || *bp=='\n') return FALSE;
	
	src = bp;
	dst = chunk;               
	
	while( *bp!='\t' && *bp!='\r' && *bp!='\n' ) {
		bp++;
		if(bp>=bufferTail) {  
			copy = min((bp-src),(max-(dst-chunk)));
			strncpy( dst, src, copy );
			dst+=copy;
			*dst=0;
			if(!FillBuffer()) return TRUE;
			src=bp;
		}
	}
	copy = min((bp-src),(max-(dst-chunk)));
	if(*bp=='\t') bp++;
	strncpy( dst,src,copy);
	dst+=copy;
	*dst=0;
	return TRUE;
}
  
  
BOOL CArchiveReadStream::SkipToNextLine()
{    
	if(AtEOF()) return FALSE;
	if(bp>=bufferTail && !FillBuffer()) return FALSE;
	
	while( *bp!='\n' ) {
		bp++;
		if(bp>=bufferTail && !FillBuffer()) return FALSE;
	}        
	bp++;
	return TRUE;
}    
 
/////////////////////////////////////////////////////////////////////////////
//  CCKTBLControl Archive support 
// these functions support reading and writing from tab separated ascii files
   
                   
void CCKTBLControl::ReadFromArchive(CArchive& ar)
{           
	CArchiveReadStream in;
	const int textSize = 32000;                              
	char	*text;
	int 	row, col, maxCols;
	
	ASSERT_VALID(this);
	
	text = (char*)malloc( textSize+1 );
	if(!text) AfxThrowMemoryException();

	maxCols = 1;                                  
	row = -1; 		// so that first row==0 for labels
	col = 0;
                             
	in.ResetOn(ar);
	while(!in.AtEOF()) {
		if(in.GetNextChunk(text, textSize)) {
			if(col==0) row++;
			SetText( row, ++col, text );		
		} else {     
			in.SkipToNextLine();
			maxCols = max( maxCols, col );
			col=0;
		}
	}   
	
	free(text); 
	SetSize(max(row,1),max(maxCols,1));
	                
	Invalidate();
	ASSERT_VALID(this);
}

void CCKTBLControl::WriteToArchive(CArchive& ar)
{
	static char	tab[] = "\t";
	static char	crlf[] = "\r\n";
	int 		row, col, maxCols, maxRows;
	CString 	text;
	
	ASSERT_VALID(this);
	        
	maxCols = GetColumns();	        
	maxRows = GetRows();
	
	for( row=0; row<=maxRows; row++) {
		for( col=1; col<=maxCols; col++) {
			GetText( row, col, &text );
			ar.Write( text, text.GetLength() );
			if(col<maxCols) ar.Write( tab, 1 );
		}
		ar.Write( crlf, 2 );
	}
	
	ASSERT_VALID(this);
}


void CCKTBLControl::SerializeRaw(CArchive& ar)
{
	ASSERT_VALID(this);
	if (ar.IsStoring())	{
		WriteToArchive(ar);
	} else {
		ReadFromArchive(ar );
	}
	ASSERT_VALID(this);
}
                 
        	       
/////////////////////////////////////////////////////////////////////////////
// Basic CCKTBLControl Operations (map directly to C API)
                                  
void CCKTBLControl::Clear()
{
	CKTBLClear( GetSafeHwnd() );
}

void CCKTBLControl::SetSize( int rows, int columns )
{   
	CKTBLSetSize( GetSafeHwnd(), rows, columns );
}

void CCKTBLControl::SetColumns( int columns )
{  
	CKTBLSetColumns( GetSafeHwnd(), columns );
}

void CCKTBLControl::SetRows( int rows )
{    
	CKTBLSetRows( GetSafeHwnd(), rows );
}
  
int CCKTBLControl::GetColumns( )
{   
	return CKTBLGetColumns( GetSafeHwnd() );
}                            

int CCKTBLControl::GetRows()
{   
	return CKTBLGetRows( GetSafeHwnd() );
}

void CCKTBLControl::SetFlags(DWORD flags )
{  
	CKTBLSetFlags( GetSafeHwnd(), flags );
}

long CCKTBLControl::GetFlags()
{ 
	return CKTBLGetFlags( GetSafeHwnd() );
}

int CCKTBLControl::GetCurrentRow()
{              
	return CKTBLGetCurrentRow( GetSafeHwnd() );
}

int CCKTBLControl::GetCurrentColumn()
{	
	return CKTBLGetCurrentColumn( GetSafeHwnd() );
}

void CCKTBLControl::SetCurrentCell(int row, int col )
{     
	CKTBLSetCurrentCell( GetSafeHwnd(), row, col );
}

int CCKTBLControl::GetTopRow()
{        
	return CKTBLGetTopRow( GetSafeHwnd() );
}

int CCKTBLControl::GetLeftColumn()
{      
	return CKTBLGetLeftColumn( GetSafeHwnd() );
}

void CCKTBLControl::SetLeftTop(int left, int top )
{      
	CKTBLSetLeftTop( GetSafeHwnd(), left, top );
}

BOOL CCKTBLControl::InEdit()
{           
	return CKTBLInEdit( GetSafeHwnd() );
}

void CCKTBLControl::StartEdit(int row, int column, LPSTR text )
{	
	CKTBLStartEdit( GetSafeHwnd(), row, column, text );
}

void CCKTBLControl::StartEditRequest(int row, int column, LPSTR text )
{  
	CKTBLStartEditRequest( GetSafeHwnd(), row, column, text );
}

BOOL CCKTBLControl::EndEdit(BOOL acceptChanges )
{  
	return CKTBLEndEdit( GetSafeHwnd(), acceptChanges );
}

void CCKTBLControl::ShowCell(int row, int col  )
{
	CKTBLShowCell( GetSafeHwnd(), row, col );
}
        
void CCKTBLControl::SetCellAttr( CKTBL_ATTRIB FAR* attrib )
{
	CKTBLSetCellAttr( GetSafeHwnd(), attrib );
}

void CCKTBLControl::GetCellAttr( CKTBL_ATTRIB FAR* attrib )
{
	CKTBLGetCellAttr( GetSafeHwnd(), attrib );
}
	                       
void CCKTBLControl::SetLabelAttr( CKTBL_ATTRIB FAR* attrib )
{
	CKTBLSetLabelAttr( GetSafeHwnd(), attrib );
}

void CCKTBLControl::GetLabelAttr( CKTBL_ATTRIB FAR* attrib )
{
	CKTBLGetLabelAttr( GetSafeHwnd(), attrib );
}
	
void CCKTBLControl::SetDefaultColumnWidth( int width )
{
	CKTBLSetDefaultColumnWidth( GetSafeHwnd(), width );
}

void CCKTBLControl::SetDefaultRowHeight( int height )
{
	CKTBLSetDefaultRowHeight( GetSafeHwnd(), height );
}

int CCKTBLControl::GetDefaultColumnWidth()
{
	return CKTBLGetDefaultColumnWidth( GetSafeHwnd() );
}

int CCKTBLControl::GetDefaultRowHeight()
{
	return CKTBLGetDefaultRowHeight( GetSafeHwnd() );
}

void CCKTBLControl::SetColumnWidth(int column, int width )
{ 
	CKTBLSetColumnWidth( GetSafeHwnd(), column, width );
}

void CCKTBLControl::SetRowHeight( int row, int height )
{ 	
	CKTBLSetRowHeight( GetSafeHwnd(), row, height );
}

int CCKTBLControl::GetColumnWidth( int column  )
{   
	return CKTBLGetColumnWidth( GetSafeHwnd(), column );
}

int CCKTBLControl::GetRowHeight( int row )
{   
	return CKTBLGetRowHeight( GetSafeHwnd(), row );
}
                         
int CCKTBLControl::GetTextHeight( int row, int col, LPCSTR text )
{  
	return CKTBLGetTextHeight( GetSafeHwnd(), row, col, text );
}
                            
int CCKTBLControl::GetRowTextHeight( int row, int skipColumn )
{  
	return CKTBLGetRowTextHeight( GetSafeHwnd(), row, skipColumn );
}
                            
void CCKTBLControl::UpdateRowHeight( int row )
{ 	
	CKTBLUpdateRowHeight( GetSafeHwnd(), row );
}
    
void CCKTBLControl::InsertRowsAfter( int row, int number )
{  
	CKTBLInsertRowsAfter( GetSafeHwnd(), row, number );
}
                            
void CCKTBLControl::InsertColumnsAfter( int column ,int number )
{   
	CKTBLInsertColumnsAfter( GetSafeHwnd(), column, number );
}
   
void CCKTBLControl::RemoveRows( int rowStart, int rowEnd )
{          
	CKTBLRemoveRows( GetSafeHwnd(), rowStart, rowEnd );
}
                            
void CCKTBLControl::RemoveColumns( int columnStart, int columnEnd)
{     
	CKTBLRemoveColumns( GetSafeHwnd(), columnStart, columnEnd );
}
   
void CCKTBLControl::SetText( int row, int column, LPCSTR text )
{  
	CKTBLSetText( GetSafeHwnd(), row, column, text );
}
                            
void CCKTBLControl::SetTextPrim( int row, int column, LPCSTR text )
{                                                    
	CKTBLSetTextPrim( GetSafeHwnd(), row, column, text );
}
                            
void CCKTBLControl::SetRowText( int row, LPCSTR text, int colSep, int lineSep )
{    
	CKTBLSetRowText( GetSafeHwnd(), row, text, colSep, lineSep );
}
    
int CCKTBLControl::GetTextLength( int row, int column )
{  
	return CKTBLGetTextLength( GetSafeHwnd(), row, column  );
}
                            
void CCKTBLControl::GetText( int row, int column, LPSTR text, int maxLength )
{
	CKTBLGetText( GetSafeHwnd(), row, column, text, maxLength );
}
         
int CCKTBLControl::GetRowTextLength( int row  ) 
{ 
	return CKTBLGetRowTextLength( GetSafeHwnd(), row );
}
                            
void CCKTBLControl::GetRowText( int row, LPSTR text, int maxLength, int colSep, int lineSep )
{     
	CKTBLGetRowText( GetSafeHwnd(), row, text, maxLength, colSep, lineSep );
}
                            
void CCKTBLControl::SetAttr( int row, int column, CKTBL_ATTRIB FAR* attrib )
{  
	CKTBLSetAttr( GetSafeHwnd(), row, column, attrib );			
}
                            
void CCKTBLControl::ModifyAttr( int row, int column, CKTBL_ATTRIB FAR* attrib, short fields, DWORD formatMask  ) 
{
	CKTBLModifyAttr( GetSafeHwnd(), row, column, attrib, fields, formatMask  ); 
}
                            
void CCKTBLControl::GetAttr( int row, int column, CKTBL_ATTRIB FAR* attrib )
{    
	CKTBLGetAttr( GetSafeHwnd(), row, column, attrib );
}
                            
void CCKTBLControl::SetRectText( RECT FAR* rect, LPSTR text )
{
	CKTBLSetRectText( GetSafeHwnd(), rect, text );
}
                            
void CCKTBLControl::SetRectAttr( RECT FAR* rect, CKTBL_ATTRIB FAR* attrib )
{      	
	CKTBLSetRectAttr( GetSafeHwnd(), rect, attrib );
}
                            
void CCKTBLControl::ModifyRectAttr( RECT FAR* rect, CKTBL_ATTRIB FAR* attrib, short fields, DWORD formatMask )
{
	 CKTBLModifyRectAttr( GetSafeHwnd(), rect, attrib, fields, formatMask );
}
                                           
void CCKTBLControl::SetSelAttr( CKTBL_ATTRIB FAR* attrib ) 	
{
	CKTBLSetSelAttr( GetSafeHwnd(), attrib ); 
}
                            
void CCKTBLControl::ModifySelAttr( CKTBL_ATTRIB FAR* attrib, short fields, DWORD formtMask )	
{
	CKTBLModifySelAttr( GetSafeHwnd(), attrib, fields, formtMask );	
}
                            
void CCKTBLControl::ClearSelection()
{       
	CKTBLClearSelection(GetSafeHwnd() );
}
                            
void CCKTBLControl::SetSelection( RECT FAR* cells ) 
{                  
	CKTBLSetSelection( GetSafeHwnd(), cells );
}
                            
void CCKTBLControl::ChangeSelection( RECT FAR* cells, int index )
{     
	CKTBLChangeSelection( GetSafeHwnd(), cells,  index );
}
                            
void CCKTBLControl::AddSelection( RECT FAR* cells )
{              
	CKTBLAddSelection( GetSafeHwnd(), cells );
}
                            
void CCKTBLControl::SetSelectionOrg( RECT FAR* cells, POINT FAR* origin )
{                                        
	CKTBLSetSelectionOrg( GetSafeHwnd(), cells, origin );
}
                            
void CCKTBLControl::AddSelectionOrg( RECT FAR* cells, POINT FAR* origin )
{                              	
	CKTBLAddSelectionOrg( GetSafeHwnd(), cells, origin );
}
                            
int CCKTBLControl::GetSelectionSize()
{       
	return CKTBLGetSelectionSize( GetSafeHwnd() );
}
                            
BOOL CCKTBLControl::GetSelection( RECT FAR * cells, int n )
{                            
	return CKTBLGetSelection( GetSafeHwnd(), cells, n );
}
        
/////////////////////////////////////////////////////////////////////////////
// CCKTBLControl Message Map
      

BEGIN_MESSAGE_MAP(CCKTBLControl, CWnd)
	//{{AFX_MSG_MAP(CCKTBLControl) 
	ON_MESSAGE( CKTBL_EDIT_START, 		OnMsgEditStart )
	ON_MESSAGE( CKTBL_EDIT_END, 		OnMsgEditEnd )
	ON_MESSAGE( CKTBL_EDIT_CANCELLED, 	OnMsgEditCancelled )
	                                                           	
	ON_MESSAGE( CKTBL_RESIZE_COLUMN_START, 	OnMsgResizeColumnStart )
	ON_MESSAGE( CKTBL_RESIZE_COLUMN_END, 	OnMsgResizeColumnEnd )
	ON_MESSAGE( CKTBL_RESIZE_ROW_START, 	OnMsgResizeRowStart )
	ON_MESSAGE( CKTBL_RESIZE_ROW_END, 		OnMsgResizeRowEnd )
	
	ON_MESSAGE( CKTBL_CHANGED_CURRENTCELL, 	OnMsgChangedCurrentCell )
	ON_MESSAGE( CKTBL_CHANGED_SELECTION, 	OnMsgChangedSelection )
	ON_MESSAGE( CKTBL_CLICKED_CELL, 		OnMsgClickedCell )
	ON_MESSAGE( CKTBL_DOUBLECLICKED_CELL, 	OnMsgDoubleClickedCell )
	
	ON_MESSAGE( CKTBL_CHANGE_CURSOR, 	OnMsgChangeCursor )
	 
	ON_MESSAGE( CKTBL_HSCROLL_BEGIN, 	OnMsgHScrollBegin )
	ON_MESSAGE( CKTBL_HSCROLL_END, 		OnMsgHScrollEnd )
	ON_MESSAGE( CKTBL_VSCROLL_BEGIN, 	OnMsgVScrollBegin )
	ON_MESSAGE( CKTBL_VSCROLL_END, 		OnMsgVScrollEnd )
	//}}AFX_MSG_MAP  

END_MESSAGE_MAP()
           
     
           
/////////////////////////////////////////////////////////////////////////////
// CCKTBLControl overridables (default implementations)
                                  
          
//----------------------------------------------------------------------------------- 
// Overridables that provide hooks for resizing rows and columns 
// return TRUE to use default behavior
// return FALSE to inhibit default behavior
 	              
BOOL CCKTBLControl::OnEditStart( int row, int col, CString text )
{               
    // called when a cell is to be edited
    // text contains the current contents of the cell 
    // return FALSE to inhibit editing of cell
    
	return TRUE;
}

BOOL CCKTBLControl::OnEditEnd( int row, int col, CString text)
{      
	// called when a cell has been successfully edited
	// return FALSE to inhibit storing of 'text' into cell
	
	return TRUE;
}

//----------------------------------------------------------------------------------- 
// Overridables that provide notification on editing of cells

void CCKTBLControl::OnEditCancelled(int row, int col )
{
	// called when user has cancelled editing of a cell
}
 	                    
       
//----------------------------------------------------------------------------------- 
// Overridables that provide hooks for resizing rows and columns 
// return TRUE to use default behavior
// return FALSE to inhibit default behavior
 	                    
BOOL CCKTBLControl::OnResizeColumnStart( int column )
{              
	// called when the user tries to adjust the width of a column 
	return TRUE;
}

BOOL CCKTBLControl::OnResizeColumnEnd( int column, long width )
{          
	// called after the user has changed the column width
	return TRUE;
}

BOOL CCKTBLControl::OnResizeRowStart( int row  )
{     
	// called when the user tries to adjust the height of a row 
	return TRUE;
}

BOOL CCKTBLControl::OnResizeRowEnd( int row, long height )
{
	// called after the user has changed the row height
	return TRUE;
}
	       
//----------------------------------------------------------------------------------- 
// Overridables that provide general notification on actions performed by the user
	       
void CCKTBLControl::OnChangedCurrentCell()
{              
	// called when current cell has changed
}

void CCKTBLControl::OnChangedSelection()
{
	// called when selection has changed
}

void CCKTBLControl::OnClickedCell( int row, int col )
{
	// called when user has clicked on a cell
}

void CCKTBLControl::OnDoubleClickedCell( int row, int col )
{ 
	// called when user has double clicked on a cell
}
	         
//----------------------------------------------------------------------------------- 
// Overridables that provide hooks for custom mouse cursors  
// return TRUE to use default behavior
// return FALSE to override default behavior
	         
BOOL CCKTBLControl::OnChangeCursor( int state )
{	
	// called when the mouse cursor is to be changed
	// return FALSE from this method if you want override the default behaviour and
	// set the mouse cursor according to following constants from cktbl.h
	//	CKTBL_CURSOR_NULL			0
	//	CKTBL_CURSOR_STD		 	Normal cursor over cells
	//	CKTBL_CURSOR_RESIZE_ROW	 	Cursor for resizing rows
	//	CKTBL_CURSOR_RESIZE_COL	 	Cursor for resizing columns
	  
	return TRUE;
}
         
//----------------------------------------------------------------------------------- 
// Overridables that provide hooks for dynamically extending the table
// when the user scrolls over the bounds
                 
void CCKTBLControl::OnHScrollBegin()
{     
	// called when use tries to scroll to the left of the leftmost column 
	// i.e. user presses cursor left in the leftmost column
}
void CCKTBLControl::OnHScrollEnd()
{ 
	// called when use tries to scroll to the right of the rightmost column
	// i.e. user presses cursor right in the rightmost column
}

void CCKTBLControl::OnVScrollBegin()
{	
	// called when use tries to scroll above first row
	// i.e. user presses cursor up in the first row
}                                 

void CCKTBLControl::OnVScrollEnd()
{
	// called when use tries to scroll below the last row  
	// i.e. user presses cursor right in the last row
}
         
           
           
/////////////////////////////////////////////////////////////////////////////
// CCKTBLControl message handlers
                                  

LRESULT CCKTBLControl::OnMsgEditStart( WPARAM wParam, LPARAM lParam )
{    
	CKTBL_EDITARG * editArg = (CKTBL_EDITARG*) lParam; 
	if( OnEditStart(editArg->row, editArg->column, editArg->text ))        
		Default();     
	return 0;
}
LRESULT CCKTBLControl::OnMsgEditEnd( WPARAM wParam, LPARAM lParam )
{                  
	CKTBL_EDITARG * editArg = (CKTBL_EDITARG*) lParam;         
	if( OnEditEnd( editArg->row, editArg->column, editArg->text ))        
		Default();
	return 0;
}
LRESULT CCKTBLControl::OnMsgEditCancelled( WPARAM wParam, LPARAM lParam )
{
	OnEditCancelled( wParam, (int) lParam );
	return 0;
}                                                                        
LRESULT CCKTBLControl::OnMsgResizeColumnStart( WPARAM wParam, LPARAM lParam )
{
	if(OnResizeColumnStart(wParam)) 
		return Default();
	else	
		return FALSE;
	return 0;
}
LRESULT CCKTBLControl::OnMsgResizeColumnEnd( WPARAM wParam, LPARAM lParam )
{
	if(OnResizeColumnEnd(wParam,lParam))
		Default();
	return 0;
}
LRESULT CCKTBLControl::OnMsgResizeRowStart( WPARAM wParam, LPARAM lParam )
{
	if(OnResizeRowStart(wParam))
		return Default();
	else
		return FALSE;
	return 0;
}                 
LRESULT CCKTBLControl::OnMsgResizeRowEnd( WPARAM wParam, LPARAM lParam )
{
	if(	OnResizeRowEnd(wParam,lParam))
		Default();
	return 0;
}
LRESULT CCKTBLControl::OnMsgChangedCurrentCell( WPARAM wParam, LPARAM lParam )
{
	OnChangedCurrentCell();
	return 0;
}
LRESULT CCKTBLControl::OnMsgChangedSelection( WPARAM wParam, LPARAM lParam )
{
	OnChangedSelection();
	return 0;
}
LRESULT CCKTBLControl::OnMsgClickedCell( WPARAM wParam, LPARAM lParam )
{
	OnClickedCell(wParam, (int)lParam);
	return 0;
}
LRESULT CCKTBLControl::OnMsgDoubleClickedCell( WPARAM wParam, LPARAM lParam )
{
	OnDoubleClickedCell(wParam, (int)lParam);
	return 0;
}
LRESULT CCKTBLControl::OnMsgChangeCursor( WPARAM wParam, LPARAM lParam )
{
	if(OnChangeCursor(wParam))
		Default();
	return 0;
}    
LRESULT CCKTBLControl::OnMsgHScrollBegin( WPARAM wParam, LPARAM lParam )
{
	OnHScrollBegin();
	return 0;
}
LRESULT CCKTBLControl::OnMsgHScrollEnd( WPARAM wParam, LPARAM lParam )
{
	OnHScrollEnd();
	return 0;
}
LRESULT CCKTBLControl::OnMsgVScrollBegin( WPARAM wParam, LPARAM lParam )
{
	OnVScrollBegin();
	return 0;
}
LRESULT CCKTBLControl::OnMsgVScrollEnd( WPARAM wParam, LPARAM lParam )
{         
	OnVScrollEnd();
	return 0;
}                               
