//***************************************************************
// From the book "Win32 System Services: The Heart of Windows NT"
// by Marshall Brain
// Published by Prentice Hall
//
// Copyright 1994, by Prentice Hall.
//
// This code retrieves the configuration information from a 
// service.
//***************************************************************

// getcon.cpp

#include <windows.h>
#include <iostream.h>

void ErrorHandler(char *s, DWORD err)
{
	cout << s << endl;
	cout << "Error number: " << err << endl;
	ExitProcess(err);
}

void main(int argc, char *argv[])
{
	SC_HANDLE service, scm;
	BOOL success;
	LPQUERY_SERVICE_CONFIG buffer;
	DWORD sizeNeeded;

	if (argc != 2)
	{
		cout << "Usage:\n";
		cout << "   getcon service_name\n";
		return;
	}
	
	// Open a connection to the SCM
	scm = OpenSCManager(0, 0,
		SC_MANAGER_ALL_ACCESS);
	if (!scm)
		ErrorHandler("In OpenScManager",
			GetLastError());

	// Get the service's handle
	service = OpenService(
		scm, argv[1],
		SERVICE_QUERY_CONFIG);
	if (!service)
		ErrorHandler("In OpenService",
			GetLastError());

	// Find out how big the buffer needs to be
	success = QueryServiceConfig(service, 0, 0,
		&sizeNeeded);
	
	// Allocate space for the buffer
	buffer = (LPQUERY_SERVICE_CONFIG) 
		LocalAlloc (LPTR, sizeNeeded);

	// Get the buffer
	success = QueryServiceConfig(service, buffer,
		sizeNeeded, &sizeNeeded);
	if (!success)
		ErrorHandler("In QueryServiceConfig",
			GetLastError());

	// Print the contents of the buffer
	cout << "Service type: " 
		<< buffer->dwServiceType << endl;
	cout << "Start type: " 
		<< buffer->dwStartType << endl;
	// and so on

	// Clean up
	LocalFree(buffer);
	CloseServiceHandle(service);
	CloseServiceHandle(scm);
}
