//***************************************************************
// From the book "Win32 System Services: The Heart of Windows NT"
// by Marshall Brain
// Published by Prentice Hall
//
// Copyright 1994, by Prentice Hall.
//
// This code sends a message to the mailslot monitored by the 
// logon service.
//***************************************************************

// announce.cpp

#include <windows.h>
#include <stdio.h>
#include <iostream.h>
#include <stdlib.h>

void ErrorHandler(char *s, DWORD err)
{
	cout << s << endl;
	cout << "Error number: " << err << endl;
	ExitProcess(err);
}

VOID main(int argc, char *argv[])
{
	HANDLE mailslot;
	DWORD numWrite;
	BOOL success;

	if (argc != 2)
	{
		cout << "Usage: announce message\n";
		cout << "  if message > 1 word, put it \
in quotes\n";
		return;
	}

	// create a mailslot to write to
	mailslot = CreateFile(
		"\\\\*\\mailslot\\logonann", 
		GENERIC_WRITE, FILE_SHARE_READ, 0, 
		OPEN_EXISTING, FILE_ATTRIBUTE_NORMAL, 0);
	if (mailslot == INVALID_HANDLE_VALUE)
		ErrorHandler("In CreateFile",
			GetLastError());

	// Write the message to the new slot
	success = WriteFile(mailslot, argv[1],
		strlen(argv[1]), &numWrite, 0);
	if (!success)
		ErrorHandler("In WriteFile", GetLastError());
	else
		cout << "success\n";

	CloseHandle(mailslot);
}
