//***************************************************************
// From the book "Win32 System Services: The Heart of Windows NT"
// by Marshall Brain
// Published by Prentice Hall
//
// Copyright 1994, by Prentice Hall.
//
// This code implements the RPC server body.
//***************************************************************

// autoserv.cpp

#include <windows.h>
#include <iostream.h>
#include <rpc.h>
#include "sum.h"
#include "memstub"

INT main(VOID)
{
  RPC_BINDING_VECTOR *bindVector;

  // use the protocols specified in the
  // IDL file for this interface
  if (RpcServerUseAllProtseqsIf(1,
    sumup_ServerIfHandle, NULL))
  {
    cerr << "ERROR: Could not specify protocols" 
      << endl;
    return(1);
  }

  // register the interface
  if (RpcServerRegisterIf(sumup_ServerIfHandle,
    NULL, NULL))
  {
    cerr << 
      "ERROR: Could not register interface handle"
      << endl;
    return(1);
  }

  // get binding handles for the interface
  if (RpcServerInqBindings(&bindVector))
  {
    cerr 
      << "ERROR: Could not inquire about bindings"
      << endl;
    return(1);
  }

  // add an entry in the name service 
  // for the interface
  if (RpcNsBindingExport(RPC_C_NS_SYNTAX_DEFAULT,
    (UCHAR *) "/.:/autorpc", 
    sumup_ServerIfHandle, bindVector, NULL))
  {
    cerr
      << "ERROR: Could not export binding" << endl;
    return(1);
  }

  // listen for and service RPC requests
  if (RpcServerListen(1, 5, FALSE))
  {
    cerr << 
      "ERROR: Server cant listen for RPC requests" 
      << endl;
    return(1);
  }

  return(0);
}
