//***************************************************************
// From the book "Win32 System Services: The Heart of Windows NT"
// by Marshall Brain
// Published by Prentice Hall
//
// Copyright 1994, by Prentice Hall.
//
// This code implements the RPC client.
//***************************************************************

// mandelc2.cpp

#include <afxwin.h>
#include <rpc.h>
#include "ccrpc2.h"
#include "menus.h"

const double left = -1.0;
const double right = 1.0;
const double top = -1.0;
const double bottom = 1.0;

DWORD colors[64];

typedef struct
{
	WORD height;
	WORD width;
} mandelParams;

// Define the application object class
class CManApp : public CWinApp
{
public:
	virtual BOOL InitInstance();
};

// Define the edit window class
class CManWindow : public CFrameWnd
{
private:
	HANDLE threadHandle;
	BOOL running;
	BOOL initialized;
	mandelParams params;
public:
	CManWindow();
	void RunMandel();
	void SetPix(int x, int y, WORD iter);
	afx_msg void OnPaint();
	afx_msg void OnStartStop();
	afx_msg void OnExit();
	DECLARE_MESSAGE_MAP()
};

// Create an instance of the application object
CManApp manApp;

// member function used to set pixel colors 
// in the window
void CManWindow::SetPix(int x, int y, WORD iter)
{
	CClientDC dc(this);
	dc.SetPixel(x, y, colors[iter]);
}

// the thread function which does the drawing
DWORD MandelThread(mandelParams *params)
{
	double ystep;
	double y;
	int i,j;
	short line[150];

	ystep = (double) (bottom - top) / 
		params->height;
	
	for (y=top, j=0; y <= bottom; y += ystep, j++)
	{
		RpcTryExcept
		{
			CalcLine(left, right, y, 
				params->width, line);
		}
		RpcExcept(1)
		{
			MessageBox(NULL,
				"Unable to call CalcLine( ).\n\
Click OK and then Exit.",
				"ERROR", MB_SETFOREGROUND | 
				MB_OK | MB_ICONSTOP);
			ExitThread(1);
		}
		RpcEndExcept;

		for (i=0; i<params->width; i++)
			((CManWindow *)manApp.m_pMainWnd)->
				SetPix(i, j, line[i]);
	}
	return(0);
}

// member function used to instigate 
// the drawing thread
void CManWindow::RunMandel()
{
	DWORD threadID;
	CRect r;

	GetClientRect(&r);
	params.height=r.Height();
	params.width=r.Width();

	threadHandle=CreateThread(NULL, 0,
		(LPTHREAD_START_ROUTINE) MandelThread,
		&params, 0, &threadID);

	running=TRUE;
}

// The message map
BEGIN_MESSAGE_MAP(CManWindow, CFrameWnd)
	ON_WM_PAINT()
	ON_COMMAND(IDM_STARTSTOP, OnStartStop)
	ON_COMMAND(IDM_EXIT, OnExit)
END_MESSAGE_MAP()

// Handler for the Start/Stop menu option
void CManWindow::OnStartStop()
{
	if(running)
		SuspendThread(threadHandle);
	else
		ResumeThread(threadHandle);

	running=!running;
}

// Handler for WM_PAINT messages
void CManWindow::OnPaint()
{
	ValidateRect(NULL);
	if (!initialized)
	{
		initialized=TRUE;
		RunMandel();
	}
	else
	if (running)
	{
		// stop the existing thread
		TerminateThread(threadHandle, 0);
		CloseHandle(threadHandle);
		// clear the window
		CClientDC dc(this);
		CRect r;
		GetClientRect(&r);
		dc.PatBlt(0, 0, r.Width(), r.Height(),
			WHITENESS);
		// start over again
		RunMandel();
	}
}

// Handler for the Exit menu option
void CManWindow::OnExit()
{
	SuspendThread(threadHandle);
	CloseHandle(threadHandle);
	RpcBindingFree(&calclineHandle);
	DestroyWindow();
}

// CManWindow constructor
CManWindow::CManWindow()
{
	WORD x;
	BYTE red=0, green=0, blue=0;
	UCHAR *stringBinding;
	CHAR serverName[MAX_PATH];

	Create( NULL, "RPC Mandel Example 2",
		WS_OVERLAPPED,
		CRect(0,0,150,150), NULL, "MainMenu" );
	for (x=0; x<64; x++)
	{
		colors[x] = RGB(red, green, blue);
		if (!(red += 64)) 
			if (!(green += 64)) 
				blue += 64;
	}
	colors[63] = RGB(255,255,255);

	if (strlen(manApp.m_lpCmdLine))
		strcpy(serverName, manApp.m_lpCmdLine);
	else
		strcpy(serverName, "\\\\.");

	RpcStringBindingCompose(NULL,
		(UCHAR *) "ncacn_np", (UCHAR *) serverName,
		(UCHAR *) "\\pipe\\ccrpc2", NULL,
			&stringBinding);

	RpcBindingFromStringBinding(stringBinding,
		&calclineHandle);

	RpcStringFree(&stringBinding);

	initialized=FALSE;
}

// Initialize the CManApp m_pMainWnd data member
BOOL CManApp::InitInstance()
{
	m_pMainWnd = new CManWindow();
	m_pMainWnd -> ShowWindow( m_nCmdShow );
	m_pMainWnd -> UpdateWindow();

	return TRUE;
}

