//***************************************************************
// From the book "Win32 System Services: The Heart of Windows NT"
// by Marshall Brain
// Published by Prentice Hall
//
// Copyright 1994, by Prentice Hall.
//
// This code implements the RPC server function.
//***************************************************************

// ccrpc2.cpp

#include <windows.h>
#include "ccrpc2.h"

#define NUM_ITERATIONS 64

void CalcLine(double left, double right, double y,
	long width, short line[])
{
	complex k, z;
	double x, xstep, real, imag, spread;
	WORD i, iter;

	xstep = (double) (right - left) / width;

	for (x=left, i=0; x<=right; x += xstep, i++)
	{
		k.real = x;
		k.imag = y;
		z.real=z.imag=0.0;

		for (iter=0; iter<NUM_ITERATIONS-1; iter++)
		{
			real = z.real + k.real;
			imag = z.imag + k.imag;
			z.real = real * real - imag * imag;
			z.imag = 2 * real * imag;
			spread = z.real * z.real + z.imag *
				z.imag;
			if (spread > 4.0)
				break;
		}
		line[i]=iter;
	}
	return;
}
