//***************************************************************
// From the book "Win32 System Services: The Heart of Windows NT"
// by Marshall Brain
// Published by Prentice Hall
//
// Copyright 1994, by Prentice Hall.
//
// This code implements a TCP server.
//***************************************************************

// msipserv.cpp

#include <windows.h>
#include <iostream.h>
#include <winsock.h>
#include <process.h>

#define NO_FLAGS_SET 0

#define PORT (u_short) 44965
#define MAXBUFLEN 256

VOID talkToClient(VOID *cs)
{
  char buffer[MAXBUFLEN];
  int status;
  int numsnt;
  int numrcv;
  SOCKET clientSocket=(SOCKET)cs;

  while(1)
  {
    numrcv=recv(clientSocket, buffer, 
      MAXBUFLEN, NO_FLAGS_SET);
    if ((numrcv == 0) || (numrcv == SOCKET_ERROR))
    {
      cout << "Connection terminated" << endl;
      break;
    }

    _strupr(buffer);

    numsnt=send(clientSocket, buffer, 
      strlen(buffer) + 1, NO_FLAGS_SET);
    if (numsnt != (int)strlen(buffer) + 1)
    {
      cout << "Connection terminated." << endl;
      break;
    }

  } /* while */

  /* terminate the connection with the client
     (disable sending/receiving) */
  status=shutdown(clientSocket, 2);
  if (status == SOCKET_ERROR)
    cerr << "ERROR: shutdown unsuccessful" << endl;

  /* close the socket */
  status=closesocket(clientSocket);
  if (status == SOCKET_ERROR)
    cerr << "ERROR: closesocket unsuccessful"
      << endl;
}

INT main(VOID)
{
  WSADATA Data;
  SOCKADDR_IN serverSockAddr;
  SOCKADDR_IN clientSockAddr;
  SOCKET serverSocket;
  SOCKET clientSocket;
  int addrLen=sizeof(SOCKADDR_IN);
  int status;
  DWORD threadID;

  /* initialize the Windows Socket DLL */
  status=WSAStartup(MAKEWORD(1, 1), &Data);
  if (status != 0)
  {
    cerr << "ERROR: WSAStartup unsuccessful" 
      << endl;
    return(1);
  }

  /* zero the sockaddr_in structure */
  memset(&serverSockAddr, 0,
    sizeof(serverSockAddr));
  /* specify the port portion of the address */
  serverSockAddr.sin_port=htons(PORT);
  /* specify the address family as Internet */
  serverSockAddr.sin_family=AF_INET;
  /* specify that the address does not matter */
  serverSockAddr.sin_addr.s_addr=htonl(INADDR_ANY);

  /* create a socket */
  serverSocket=socket(AF_INET, SOCK_STREAM, 0);
  if (serverSocket == INVALID_SOCKET)
  {
    cerr << "ERROR: socket unsuccessful"
      << endl;
    status=WSACleanup();
    if (status == SOCKET_ERROR)
      cerr << "ERROR: WSACleanup unsuccessful" 
        << endl;
    return(1);
  }

  /* associate the socket with the address */
  status=bind(serverSocket, 
    (LPSOCKADDR) &serverSockAddr,
    sizeof(serverSockAddr));
  if (status == SOCKET_ERROR)
    cerr << "ERROR: bind unsuccessful" << endl;

  /* allow the socket to take connections */
  status=listen(serverSocket, 1);
  if (status == SOCKET_ERROR)
    cerr << "ERROR: listen unsuccessful" << endl;

  while(1)
  {
    /* accept the connection request when 
       one is received */
    clientSocket=accept(serverSocket,
      (LPSOCKADDR) &clientSockAddr,
      &addrLen);
    if (clientSocket == INVALID_SOCKET)
    {
      cerr << "ERROR: Unable to accept connection."
        << endl;
      return(1);
    }

    threadID=_beginthread(talkToClient,
      0, (VOID *)clientSocket);
    if (threadID == -1)
    {
      cerr << "ERROR: Unable to create thread"
        << endl;
      /* close the socket */
      status=closesocket(clientSocket);
      if (status == SOCKET_ERROR)
        cerr << "ERROR: closesocket unsuccessful" 
          << endl;
    }

  } /* while */
}
