//***************************************************************
// From the book "Win32 System Services: The Heart of Windows NT"
// by Marshall Brain
// Published by Prentice Hall
//
// Copyright 1994, by Prentice Hall.
//
// This code implements a UDP sender for UNIX machines.
//***************************************************************

/* unixsend.c */

#include <stdio.h>
#include <netinet/in.h>
#include <sys/socket.h>

#define NO_FLAGS_SET 0

#define PORT (unsigned short) 44966

int main()
{
  struct sockaddr_in destSockAddr;
  int destSocket;
  int status;
  int numsnt;
  int enable=1;
  char *toSendtxt="Test String";

  /* specify the IP address */
  destSockAddr.sin_addr.s_addr=
    inet_addr("255.255.255.255");
  /* specify the port portion of the address */
  destSockAddr.sin_port=htons(PORT);
  /* specify the address family as Internet */
  destSockAddr.sin_family=AF_INET;

  /* create a socket */
  destSocket=socket(AF_INET, SOCK_DGRAM, 0);
  if (destSocket == -1)
    printf("Error creating socket\n");

  /* permit broadcasting on the socket */
  status=setsockopt(destSocket, SOL_SOCKET,
    SO_BROADCAST, (char *) &enable,
    sizeof(enable));
  if (status == -1)
    printf("Error setting socket opts\n");
   
  while(1)
  {
    printf("Sending...\n");
    numsnt=sendto(destSocket, toSendtxt,
      strlen(toSendtxt) + 1, NO_FLAGS_SET,
      &destSockAddr, sizeof(destSockAddr));
    if (numsnt != (int)strlen(toSendtxt) + 1)
    {
      printf("ERROR: sendto unsuccessful\n");
      status=close(destSocket);
      return(1);
    }

  /* Wait before sending the message again */
  sleep(5);
  } /* while */
}
