//***************************************************************
// From the book "Win32 System Services: The Heart of Windows NT"
// by Marshall Brain
// Published by Prentice Hall
//
// Copyright 1994, by Prentice Hall.
//
// This code shows normal implementations for a stack's push
// and pop operations that fail when used in a multi-threaded
// environment.
//***************************************************************

// prob2.cpp

#include <iostream.h>

typedef struct _NODE
{
  int data;
  _NODE *next;
} NODE;

NODE *top = 0;

void push(int value)
{
  NODE *temp;

  temp = new NODE;
  temp->data = value;
  temp->next = top;
  top = temp;
}

int pop()
{
  NODE *temp;
  int value;

  if (top == 0) 
    return 0;
  temp = top;
  value = top->data;
  top = top->next;
  delete temp;
  return value;
}

void main(void)
{
  push(5);
  push(2);
  push(9);
  cout << pop() << endl; 
  cout << pop() << endl; 
  cout << pop() << endl; 
}
