//***************************************************************
// From the book "Win32 System Services: The Heart of Windows NT"
// by Marshall Brain
// Published by Prentice Hall
//
// Copyright 1994, by Prentice Hall.
//
// This code shows how to efficiently integrate NT's 
// synchronization features into an MFC program without 
// interrupting the event loop.
//***************************************************************

// mfc.cpp

#include <afxwin.h>

#define IDB_BUTTON 100
#define FIND_MSG "find change message"

// Declare the application class
class CButtonApp : public CWinApp
{
public:
	virtual BOOL InitInstance();
};

// Create an instance of the application class
CButtonApp ButtonApp;  

// Declare the main window class
class CButtonWindow : public CFrameWnd
{ 
	CButton *button;
	static UINT findMsg;
public:
	CButtonWindow();
	~CButtonWindow();
	afx_msg void HandleButton();
	afx_msg LONG FindHandler( UINT param1,
		LONG param2 );

	DECLARE_MESSAGE_MAP()	 
};

// declare the static variable in CButtonWindow
UINT CButtonWindow::findMsg =
	::RegisterWindowMessage(FIND_MSG);

// The message handler function
void CButtonWindow::HandleButton()
{
	Beep(700,100);
	MessageBox("Button pushed", "Dialog", MB_OK);
}

// The message handler for file changes
LONG CButtonWindow::FindHandler( UINT wParam, 
	LONG lParam )
{
	Beep(500,500);
	MessageBox( "A file changed", 
		"Find Dialog", MB_ICONINFORMATION );
	return 0;
}

// The message map
BEGIN_MESSAGE_MAP(CButtonWindow, CFrameWnd)
	ON_COMMAND(IDB_BUTTON, HandleButton)
	ON_REGISTERED_MESSAGE( findMsg, FindHandler )
END_MESSAGE_MAP()

// The InitInstance function is called once
// when the application first executes
BOOL CButtonApp::InitInstance()
{
	m_pMainWnd = new CButtonWindow();
	m_pMainWnd->ShowWindow(m_nCmdShow);
	m_pMainWnd->UpdateWindow();

	return TRUE;
}

// The thread that waits for the file change 
// in the background
VOID FindThread(VOID)
{
	HANDLE changeHandle;
	UINT threadMsg;

	Beep(1000, 1000);
	
	// Register a custom message that the message
	// map will recognize
	threadMsg = RegisterWindowMessage(
		FIND_MSG );
	// wait for the first change
	changeHandle = FindFirstChangeNotification(".", 
		TRUE, FILE_NOTIFY_CHANGE_FILE_NAME);
	WaitForSingleObject(changeHandle, INFINITE);
	// inform the main event loop of the change
	::SendMessage( ButtonApp.m_pMainWnd->m_hWnd,
		threadMsg, 0, 0 );
}

// The constructor for the window class
CButtonWindow::CButtonWindow()
{ 
	CRect r;
	DWORD threadId;

	// Create the window itself
	Create(NULL, 
		"CButton Tests", 
		WS_OVERLAPPEDWINDOW,
		CRect(0,0,200,200));

	// Get the size of the client rectangle
	GetClientRect(&r);
	r.InflateRect(-20,-20);

	// Create a button
	button = new CButton();
	button->Create("Push me",
		WS_CHILD|WS_VISIBLE|BS_PUSHBUTTON,
		r,
		this,
		IDB_BUTTON);

	findMsg = RegisterWindowMessage(
		FIND_MSG );
	CreateThread(0, 0, 
		(LPTHREAD_START_ROUTINE)FindThread, 
		0, 0, &threadId);
}

// The destructor for the window class
CButtonWindow::~CButtonWindow()
{
	delete button;
	CFrameWnd::~CFrameWnd();
}
