//***************************************************************
// From the book "Win32 System Services: The Heart of Windows NT"
// by Marshall Brain
// Published by Prentice Hall
//
// Copyright 1994, by Prentice Hall.
//
// This code recursively traverses all directories below the 
// current directory
//***************************************************************

// dir2.cpp

#include <iostream.h> 
#include <windows.h>

// prints information about a file
void PrintFindData(WIN32_FIND_DATA *findData)
{	
	cout << "\t";
	cout << findData->cFileName;
	cout << "\t(" << findData->nFileSizeLow << ")";
	cout << endl;
}

// Recursively lists directories
void ListDirectoryContents(char *dirName, 
	char *fileMask)
{
	char *fileName;
	char curDir[ 256 ];
	char fullName[ 256 ];
	HANDLE fileHandle;
	WIN32_FIND_DATA findData;

	// save current dir so it can restore it
	if( !GetCurrentDirectory( 256, curDir) ) 
		return;
	
	// if the directory name is neither . or .. then
	// change to it, otherwise ignore it
	if( strcmp( dirName, "." ) && 
		strcmp( dirName, ".." ) )
	{
		if( !SetCurrentDirectory( dirName ) ) 
			return;
	}
	else 
		return;

	// print out the current directory name
	if( !GetFullPathName( fileMask, 256, fullName,
		&fileName ) ) 
		return;
	cout << endl << "Directory - " << fullName 
		<< endl;

	// Loop through all files in the directory
	fileHandle = FindFirstFile( fileMask, 
		&findData );
	while ( fileHandle != INVALID_HANDLE_VALUE )
	{
		// If the name is a directory,
		// recursively walk it. Otherwise print
		// print the file's data
		if( findData.dwFileAttributes &
			FILE_ATTRIBUTE_DIRECTORY )
		{
			ListDirectoryContents( findData.cFileName,
				fileMask );
		}
		else
			PrintFindData( &findData );

  		// loop thru remaining entries in the dir
		if (!FindNextFile( fileHandle, &findData ))
			break;
 	}
	
	// clean up and restore directory
	FindClose( fileHandle );
	SetCurrentDirectory( curDir );
}

int main(int argc, char *argv[])
{
	char	curDir[ 256 ];

	if( !GetCurrentDirectory( 256, curDir ) )
	{
		cerr << "Couldn't get the current directory." 
			<< endl;
		return( 1 );
	}

	// List all files, starting with the 
	// current directory
	ListDirectoryContents( curDir, "*.*" );
	return( 0 );
}
