//***************************************************************
// From the book "Win32 System Services: The Heart of Windows NT"
// by Marshall Brain
// Published by Prentice Hall
//
// Copyright 1994, by Prentice Hall.
//
// This code demonstrates the different time retrieval functions.
//***************************************************************

// timeshow.cpp

#include <windows.h>
#include <iostream.h>

VOID DumpTimeStruct(LPSYSTEMTIME st)
{
  cout << "Year        : "
    << st->wYear << endl;
  cout << "Month       : "
    << st->wMonth << endl;
  cout << "Day of Week : "
    << st->wDayOfWeek << endl;
  cout << "Day         : "
    << st->wDay << endl;
  cout << "Hour        : "
    << st->wHour << endl;
  cout << "Minute      : "
    << st->wMinute << endl;
  cout << "Second      : "
    << st->wSecond << endl;
  cout << "Milliseconds: "
    << st->wMilliseconds << endl;
}

VOID main(VOID)
{
  SYSTEMTIME st;
  HANDLE file;
  FILETIME ft;
  DWORD ret;
  TIME_ZONE_INFORMATION tzi;
  CHAR name[32];

  cout << "Tick Count is: "
    << GetTickCount() << endl << endl;

  // get UTC time
  GetSystemTime(&st);

  cout << "Current time (UTC):"
    << endl;
  DumpTimeStruct(&st);

  // get local time
  GetLocalTime(&st);

  cout << endl << "Current time (local):"
    << endl;
  DumpTimeStruct(&st);

  // get a file handle
  file=CreateFile("C:\\AUTOEXEC.BAT",
    GENERIC_READ, 0, NULL, OPEN_EXISTING,
    FILE_ATTRIBUTE_NORMAL, NULL);

  // get last write time
  GetFileTime(file, NULL, NULL, &ft);

  // close file handle
  CloseHandle(file);

  // convert file time to system time
  // structure
  FileTimeToSystemTime(&ft, &st);

  cout << endl
    << "Last write time (UTC) of AUTOEXEC.BAT:"
    << endl;
  DumpTimeStruct(&st);

  // get time zone info
  ret=GetTimeZoneInformation(&tzi);

  // report time zone
  switch(ret)
  {
    case TIME_ZONE_ID_UNKNOWN:
      cout << endl << "Time zone not known."
        << endl;
      break;

    case TIME_ZONE_ID_STANDARD:
      cout << endl
        << "It is currently Standard Time."
        << endl;
      break;

    case TIME_ZONE_ID_DAYLIGHT:
      cout << endl
        << "It is currently Daylight Savings Time."
        << endl;
      break;

    default:
      cerr << "Unable to get time zone "
        << "information." << endl;
      return;
  }

  // report info from time zone
  // structure
  cout << endl << "Time Zone Information:"
    << endl;
  cout << "Bias: " << tzi.Bias
    << endl << endl;
  cout << "Standard Time Data" << endl
    << "-----" << endl;
  WideCharToMultiByte(CP_ACP, NULL,
    tzi.StandardName, -1, name, 32,
    NULL, NULL);
  cout << "Standard Name: " << name
    << endl;
  cout << "Transition Date/Time:" << endl;
  DumpTimeStruct(&tzi.StandardDate);
  cout << "Standard Bias: "
    << tzi.StandardBias << endl;
  cout << "-----" << endl << endl;
  cout << "Daylight Savings Time Data" << endl
    << "-----" << endl;
  WideCharToMultiByte(CP_ACP, NULL,
    tzi.DaylightName, -1, name, 32,
    NULL, NULL);
  cout << "Daylight Name: " << name
    << endl;
  cout << "Transition Date/Time:" << endl;
  DumpTimeStruct(&tzi.DaylightDate);
  cout << "Daylight Bias: "
    << tzi.DaylightBias << endl;
  cout << "-----" << endl;
}
