//***************************************************************
// From the book "Win32 System Services: The Heart of Windows NT"
// by Marshall Brain
// Published by Prentice Hall
//
// Copyright 1994, by Prentice Hall.
//
// This code demonstrates the comm code needed to create a 
// bulletin board.
//***************************************************************

// bbs.cpp

#include <windows.h>
#include <iostream.h>

void ErrorHandler(char *message, DWORD error)
{
	cout << message << endl;
	cout << "Error number = " << error << endl;
	ExitProcess(1);
}

void main()
{
	HANDLE comHandle;
	BOOL success;
	char str[100];
	DCB dcb;
	char c;
	DWORD numWrite, numRead;
	COMMTIMEOUTS timeouts;
	char inputBuffer[1000];
	int inputBufferCntr = 0;
	BOOL connected = FALSE;

	// Open the comm port
	comHandle = CreateFile("COM2", 
		GENERIC_READ|GENERIC_WRITE, 
		0, 0, OPEN_EXISTING,
		FILE_ATTRIBUTE_NORMAL, 0);
	if (comHandle == INVALID_HANDLE_VALUE)
		ErrorHandler("In CreateFile",
			GetLastError());

	// Get the current COMM settings
	success = GetCommState(comHandle, &dcb);
	if (!success) 
		ErrorHandler("In GetCommState",
			GetLastError());

	// Set the baud rate, etc.
	dcb.BaudRate = 2400;
	dcb.ByteSize = 8;
	dcb.Parity = NOPARITY;
	dcb.StopBits = ONESTOPBIT;

	// Save the COMM settings
	success = SetCommState(comHandle, &dcb);
	if (!success) 
		ErrorHandler("In SetCommState",
			GetLastError());

	// Set the timeouts so ReadFile does
	// not return until it has data
	timeouts.ReadIntervalTimeout = 0; 
	timeouts.ReadTotalTimeoutMultiplier = 0 ;
	timeouts.ReadTotalTimeoutConstant = 0 ;
	timeouts.WriteTotalTimeoutMultiplier = 0 ;
	timeouts.WriteTotalTimeoutConstant = 0 ;
	SetCommTimeouts( comHandle, &timeouts ) ;

	// Set the DTR line
	EscapeCommFunction(comHandle, SETDTR);

	// Set modem to auto answer mode
	strcpy(str, "atq0&d1s0=2\r");
	success = WriteFile(comHandle, str, strlen(str),
		&numWrite, 0);
	if (!success) 
		ErrorHandler("In WriteFile", GetLastError());

	// Respond to incoming data
	do
	{
		// Get a character from the modem
		success = ReadFile(comHandle, &c, 1,
			&numRead, 0);
		if (!success) 
			ErrorHandler("In ReadFile",
				GetLastError());
    
		// if its not alphanumeric, discard it
		if (!isalnum(c) && c != 10 && c != 13) 
			continue;

		// if connected, echo it back
		if (connected)
		{
			success = WriteFile(comHandle, &c, 1,
				&numWrite, 0);
			if (!success) 
				ErrorHandler("In WriteFile",
					GetLastError());
		}
		// if it's CR or LF, then check for 
		// the word CONNECT. The word CONNECT 
		// means that it is time to start 
		// acting like a bulletin board
		else if (c == 10 || c == 13) 
		{
			inputBuffer[inputBufferCntr]='\0';
			cout << inputBuffer << endl;
			if (strncmp(inputBuffer, "CONNECT", 7)==0)
			{
				connected = TRUE;
				strcpy(str, "You're in...\r\n");
				cout << "You're in..." << endl;
				success = WriteFile(comHandle, str,
					strlen(str), &numWrite, 0);
				if (!success) 
					ErrorHandler("In WriteFile",
						GetLastError());
			}
			inputBufferCntr = 0;
		}
		// otherwise add to buffer
		else
			inputBuffer[inputBufferCntr++] = c;
	} while (c != 'X'); // Once user types 'X', done
	
	// Clear the DTR line
	EscapeCommFunction(comHandle, CLRDTR);

	CloseHandle(comHandle);  
}
