//***************************************************************
// From the book "Win32 System Services: The Heart of Windows NT"
// by Marshall Brain
// Published by Prentice Hall
//
// Copyright 1994, by Prentice Hall.
//
// This code shows how to register a handler function to trap
// ctrl-c, ctrl-break, etc. events.
//***************************************************************

// handler.cpp

#include <windows.h>
#include <iostream.h>
#include <string.h>

void ErrorHandler(char *s, DWORD err)
{
	cout << s << endl;
	cout << "Error number: " << err << endl;
	ExitProcess(err);
}

void ProcessIO(HANDLE consoleStdin, HANDLE stdout)
{
	char buffer[1000];
	DWORD numRead, numWrite;

	do
	{
		ReadFile(consoleStdin, buffer, 1000,
			&numRead, 0);
		buffer[numRead]='\0'; // will have CR/LF
		WriteFile(stdout, buffer, strlen(buffer),
			&numWrite, 0);
	} while  (strncmp(buffer, "exit", 4) != 0);
}

BOOL HandlerFunc(DWORD ctrlChar)
{
	switch (ctrlChar)
	{
		case CTRL_C_EVENT:
			Beep(100, 100);
			return FALSE;
		case CTRL_CLOSE_EVENT:
			Beep(200, 200);
			return FALSE;
		case CTRL_BREAK_EVENT:
			Beep(300, 300);
			return FALSE;
		case CTRL_LOGOFF_EVENT:
			Beep(400, 400);
			return FALSE;
		case CTRL_SHUTDOWN_EVENT:
			Beep(500, 500);
			return FALSE;
		default:
			Beep(2000, 2000);
			return FALSE;
	}
}

VOID main(void)
{
	HANDLE consoleStdout, consoleStdin;
	BOOL success;

	// Get handles for standard in and out
	consoleStdin = GetStdHandle(STD_INPUT_HANDLE);
	consoleStdout = GetStdHandle(STD_OUTPUT_HANDLE);
	// they must be invalid if equal
	if (consoleStdin == consoleStdout) 
		ErrorHandler("In GetStdHandle",
			GetLastError());

	success = SetConsoleCtrlHandler(
		(PHANDLER_ROUTINE)HandlerFunc, TRUE);
	if (!success)
		ErrorHandler("In SetConsoleCtrlHandler",
			GetLastError());

	// Process user I/O
	ProcessIO(consoleStdin, consoleStdout);
}
