//***************************************************************
// From the book "Win32 System Services: The Heart of Windows NT"
// by Marshall Brain
// Published by Prentice Hall
//
// Copyright 1994, by Prentice Hall.
//
// This code demonstrates how a console retrieves mouse, size
// and keystroke low-level events.
//***************************************************************

// events.cpp

#include <windows.h>
#include <iostream.h>

void ErrorHandler(char *s, DWORD err)
{
	cout << s << endl;
	cout << "Error number: " << err << endl;
	ExitProcess(err);
}

void ProcessIO(HANDLE consoleStdin,
	HANDLE consoleStdout)
{
	DWORD numRead, numWrite;
	int x=0;
	INPUT_RECORD inputRecord;
	char s[100];
	DWORD oldMode, newMode;
	
	GetConsoleMode(consoleStdin, &oldMode);
	newMode = oldMode | ENABLE_WINDOW_INPUT
		| ENABLE_MOUSE_INPUT;
	SetConsoleMode(consoleStdin, newMode);
	do
	{
		ReadConsoleInput(consoleStdin, &inputRecord,
			1, &numRead);
		switch (inputRecord.EventType)
		{
			case KEY_EVENT:
				strcpy(s, "keyboard event\n");
				break;
			case MOUSE_EVENT:
				strcpy(s, "mouse event\n");
				break;
			case WINDOW_BUFFER_SIZE_EVENT:
				strcpy(s, "resize event\n");
				break;
			default:
				strcpy(s, "other event\n");
				break;
		}
		WriteFile(consoleStdout, s, strlen(s),
			&numWrite, 0);
	} while  (x++ < 100);

	SetConsoleMode(consoleStdin, oldMode);

}

VOID main(void)
{
	DWORD oldMode, newMode;
	BOOL success;
	HANDLE consoleStdout, consoleStdin;

	// Get handles for standard in and out
	consoleStdin = GetStdHandle(STD_INPUT_HANDLE);
	consoleStdout = GetStdHandle(STD_OUTPUT_HANDLE);
	if (consoleStdin == consoleStdout)
		ErrorHandler("In GetStdHandle",
			GetLastError());

	// Get current console mode so can modify it
	success = GetConsoleMode(consoleStdin,
		&oldMode);
	if (!success)
		ErrorHandler("In GetConsoleMode",
			GetLastError());
	newMode = oldMode & ~ENABLE_LINE_INPUT &
		~ENABLE_ECHO_INPUT;
	success = SetConsoleMode(consoleStdin, newMode);
    	if (!success)
		ErrorHandler("In SetConsoleMode",
			GetLastError());

	// Process user I/O
	ProcessIO(consoleStdin, consoleStdout);

	// put the old mode back
	success = SetConsoleMode(consoleStdin, oldMode);
	if (!success)
		ErrorHandler("In SetConsoleMode",
			GetLastError());
}
