//***************************************************************
// From the book "Win32 System Services: The Heart of Windows NT"
// by Marshall Brain
// Published by Prentice Hall
//
// Copyright 1994, by Prentice Hall.
//
// This code implements a simple named pipe receiver.
//***************************************************************

// pipesec.cpp

#include <windows.h>
#include <iostream.h>

SECURITY_ATTRIBUTES sa;
SECURITY_DESCRIPTOR sd;
BYTE aclBuffer[1024];
PACL pacl=(PACL)&aclBuffer;
BYTE sidBuffer[100];
PSID psid=(PSID) &sidBuffer;
DWORD sidBufferSize = 100;
char domainBuffer[80];
DWORD domainBufferSize = 80;
SID_NAME_USE snu;
HANDLE file;

int main(void)
{
  InitializeSecurityDescriptor(&sd,
    SECURITY_DESCRIPTOR_REVISION);
  InitializeAcl(pacl, 1024, ACL_REVISION);
  LookupAccountName(0, "guest", psid,
    &sidBufferSize, domainBuffer,
    &domainBufferSize, &snu);
  AddAccessAllowedAce(pacl, ACL_REVISION,
    GENERIC_READ|GENERIC_WRITE, psid);
  SetSecurityDescriptorDacl(&sd, TRUE, pacl,
    FALSE);

  sa.nLength= sizeof(SECURITY_ATTRIBUTES);
  sa.bInheritHandle = FALSE;
  sa.lpSecurityDescriptor = &sd;

  // Print out the allowed connector
  char domainBuffer[80];
  DWORD domainBufferSize = 80;
  char name[80];
  DWORD nameSize= 80;
  LookupAccountSid(0, psid, name, &nameSize,
    domainBuffer, &domainBufferSize, &snu);
  cout << "allowing " << domainBuffer
    << "\\" << name 
    << " to access pipe" << endl; 

  char toDisptxt[80];
  HANDLE ssnpPipe;
  DWORD NumBytesRead;

  /* Create a named pipe for receiving messages */
  ssnpPipe=CreateNamedPipe("\\\\.\\pipe\\ssnp",
    PIPE_ACCESS_INBOUND, 
    PIPE_TYPE_MESSAGE | PIPE_WAIT,
    1, 0, 0, 150, &sa);

  /* Check and see if the named pipe was created */
  if (ssnpPipe == INVALID_HANDLE_VALUE)
  {
    cerr << "ERROR: Unable to create a named pipe."
      << endl;
    return (1);
  }

  /* Allow a client to connect to the name pipe, 
     terminate if unsuccessful */
  if(!ConnectNamedPipe(ssnpPipe, 
    (LPOVERLAPPED) NULL))
  {
    cerr << "ERROR: Unable to connect a named pipe"
      << endl;
    CloseHandle(ssnpPipe);
    return (1);
  }

  /* Repeatedly check for messages 
     until the program is terminated */
  while(1)
  {
    /* Read the message and check to see if read
       was successful */
    if (!ReadFile(ssnpPipe, toDisptxt,
      sizeof(toDisptxt),
      &NumBytesRead, (LPOVERLAPPED) NULL))
    {
      cerr << "ERROR: Unable to read from pipe"
        << endl;
      CloseHandle(ssnpPipe);
      return (1);
    }

    /* Display the Message */
    cout << toDisptxt << endl;

  } /* while */
}
