//***************************************************************
// From the book "Win32 System Services: The Heart of Windows NT"
// by Marshall Brain
// Published by Prentice Hall
//
// Copyright 1994, by Prentice Hall.
//
// This code demonstrates a simple MFC program.
//***************************************************************

// mfcsamp.cpp

#include <afxwin.h>

#define IDB_BUTTON 100

// Declare the application class
class CButtonApp : public CWinApp
{
public:
	virtual BOOL InitInstance();
};

// Create an instance of the application class
CButtonApp ButtonApp;  

// Declare the main window class
class CButtonWindow : public CFrameWnd
{ 
	CButton *button;
public:
	CButtonWindow();
	~CButtonWindow();
	afx_msg void HandleButton();

	DECLARE_MESSAGE_MAP()	 
};

// The message handler function
void CButtonWindow::HandleButton()
{
	Beep(700,500);
}

// The message map
BEGIN_MESSAGE_MAP(CButtonWindow, CFrameWnd)
	ON_COMMAND(IDB_BUTTON, HandleButton)
END_MESSAGE_MAP()

// The InitInstance function is called once
// when the application first executes
BOOL CButtonApp::InitInstance()
{
	m_pMainWnd = new CButtonWindow();
	m_pMainWnd->ShowWindow(m_nCmdShow);
	m_pMainWnd->UpdateWindow();
	return TRUE;
}

// The constructor for the window class
CButtonWindow::CButtonWindow()
{ 
	CRect r;

	// Create the window itself
	Create(NULL, 
		"CButton Tests", 
		WS_OVERLAPPEDWINDOW,
		CRect(0,0,200,200));

	// Get the size of the client rectangle
	GetClientRect(&r);
	r.InflateRect(-20,-20);

	// Create a button
	button = new CButton();
	button->Create("Push me",
		WS_CHILD|WS_VISIBLE|BS_PUSHBUTTON,
		r,
		this,
		IDB_BUTTON);
}

// The destructor for the window class
CButtonWindow::~CButtonWindow()
{
	delete button;
	CFrameWnd::~CFrameWnd();
}
