#ifndef _STATE_ERRORS

/****************************************************************/
/* classes utilisees pour les exceptions liees a l'utilisation  */
/* des etats pour controler l'evolution du comportement des     */
/* objets.                                                      */
/* La classe "StateError" ne sert qu'a une mise en facteur au   */
/*                        niveau des gestionaires d'exception   */
/* La classe "StateInternalError" sert a indiquer des erreurs   */
/*                        propres au mecanisme de controle      */
/* La classe "StateBehaviorError" sert a indiquer les erreurs   */
/*                        de comportement detectees.            */
/*                        Normalement ce sont les seules utiles */
/****************************************************************/

#define text_info_size 128  /* taille du message d'info accepte */


class StateError
{
  protected:
	 int  codeError;
  public:
		  StateError(int = 0);
		 ~StateError();
    virtual void  display();
};

class StateInternalError : public StateError
{
  public:
		  StateInternalError(int);
		 ~StateInternalError();
	    void  display();
};

class StateBehaviorError : public StateError
{
  protected:
	 static char textInfo[text_info_size];
                                    /* variable de classe afin d'eviter les problemes lies */
                                    /* a la destruction intempestive des objets exception  */
                                    /* AVANT leur exploitation dans un gestionnaire.       */
  public:
		  StateBehaviorError(int,char* = 0);
		 ~StateBehaviorError();
	    void  display();
};

#define _STATE_ERRORS
#endif
