##### Module Macro #####
NAME    = boyer
SRCS    = $(NAME).c
OBJS	=

##### C7 Macro #####
C7	= 1

##### Library Macros #####
LIBS    = libw llibcew
MOD     = -AL

##### Include Macro #####
INCLS   = $(NAME).h

##### Resource Macro #####
RCFILES =

##### DEBUG Defined #####
DEBUG	= 1

##### Build Option Macros #####
!if $(DEBUG)
DDEF	= -DDEBUG
CLOPT	= -Zid -Od
MOPT	= -Zi
LOPT	= /CO /LI /MAP
!else
DDEF	=
CLOPT	= -Os
LOPT	=
!endif

##### General Macros #####
DEF	=

##### Tool Macros #####
ASM	= masm -Mx $(MOPT) $(DDEF) $(DEF)
CC	= cl -nologo -c $(MOD) -G2sw -Zp -W3 $(CLOPT) $(DDEF) $(DEF)
LINK	= link /NOD /NOE $(LOPT)
LIB = lib $(NAME)
RC	= rc $(DDEF) $(DEF)
HC	= hc

##### Inference Rules #####
.c.obj:
    $(CC) $*.c

.asm.obj:
    $(ASM) $*.asm;

.rc.res:
    $(RC) -r $*.rc

##### Main (default) Target #####
goal: clean $(NAME).lib

##### Dependents For Goal and Command Lines #####
$(NAME).lib: $(SRCS:.c=.obj)
    $(LIB) $(SRCS:.c=.obj), boyer.lst

##### Dependents #####
$(SRCS:.c=.obj): $(INCLS)

##### Clean Directory #####
clean:
    -del *.obj
    -del *.map
    -del *.pdb
    -del *.sym
    -del *.lib
    -del *.lst
