/*
	DEMOTOOL.C -- program to demonstrate the abilities of
        Tool Bar and Status Bar  controls implemented in ESTOOLS.DLL 
	and ERROR.DLL
	Copyright (C) Eugene Sokolov 1992-93, (516)632-7892,
	esokolov@sbchm1.chem.sunysb.edu
        (SUNY at Stony Brook, NY 11794-3400)

	You can freely copy, change or redistribute this file as long
	as this notice remains intact.

	Last edition 11/29/94 (mm/dd/yy)
*/

#define STRICT	

#include <windows.h>
#include "estools.h"
#include "esdefs.h"


#define STATBAR_HEIGHT 22

UINT cmds[5]={ID_CMD1,ID_CMD2,ID_CMD3,ID_CMD4,ID_CMD5};

LRESULT CALLBACK 	MainWndProc	( HWND, UINT, WPARAM, LPARAM );

HINSTANCE hInst;

BOOL InitApplication(HINSTANCE hInstance)
{
   WNDCLASS  wc;

   wc.style 		= CS_HREDRAW | CS_VREDRAW;
   wc.lpfnWndProc 	= (long (FAR PASCAL*)())MainWndProc;
														// windows of this class.
   wc.cbClsExtra 	= 0;	
   wc.cbWndExtra 	= 0;	
   wc.hInstance 	= hInstance;
   wc.hIcon 		= LoadIcon( hInstance, MAKEINTRESOURCE(TBICON) );
   wc.hCursor 		= LoadCursor(NULL, IDC_ARROW);
   wc.hbrBackground 	= GetStockObject(WHITE_BRUSH);
   wc.lpszMenuName 	= MAKEINTRESOURCE(TBMENU);
   wc.lpszClassName 	= "ESDemoTools";


   return (RegisterClass(&wc));
}


/************************************************************************/
BOOL InitInstance(HINSTANCE hInstance, int nCmdShow)
{
	HWND	hWnd;
	char 	WndName[128];
	hInst = hInstance;

	wsprintf( WndName, "ES Toolbar Demo (DLL v.%X)", ESToolBarVers() );
	hWnd = CreateWindow(
		"ESDemoTools",	// See RegisterClass() call.
		WndName,	// Text for window title bar.
		WS_OVERLAPPEDWINDOW | WS_CLIPCHILDREN,	// Window style.
		CW_USEDEFAULT,			// Default horizontal position.
		CW_USEDEFAULT,			// Default vertical position.
		CW_USEDEFAULT,			// Default width.
		CW_USEDEFAULT,			// Default height.
		NULL,		
		NULL,
		hInstance,	
		NULL		
	);

	if (!hWnd)
		return (FALSE);

	ShowWindow(hWnd, nCmdShow);	// Show the window
	UpdateWindow(hWnd);		// Sends WM_PAINT message
	return (TRUE);		// Returns the value from PostQuitMessage

}


LRESULT CALLBACK MainWndProc( HWND hWnd, UINT message,
					 WPARAM wParam, LPARAM lParam )
{
	static HWND hwndTBar;
	static HWND hwndSBar;

	switch (message)
	{

	case WM_CREATE:
	{
	   RECT	rc;
	   GetClientRect( hWnd, &rc );
	   hwndTBar=CreateToolBar( hInst, (LPSTR)MAKEINTRESOURCE(TOOLBAR),
	      hWnd, 0, 0 );
	   if( !hwndTBar )
	   {
	      MessageBox( hWnd, "Could not create Tool Bar window", NULL, MB_OK );
	      PostMessage( hWnd, WM_CLOSE, 0, 0L );
	   }
	   hwndSBar=CreateStatusBar( WS_CHILD | WS_VISIBLE, 0, rc.bottom-STATBAR_HEIGHT,
   	      rc.right, STATBAR_HEIGHT, hWnd, hInst );

	   if( !hwndSBar )
	   {
	      MessageBox( hWnd, "Could not create Status Bar window", NULL, MB_OK );
	      PostMessage( hWnd, WM_CLOSE, 0, 0L );
	   }

           break;
        }
	case WM_SIZE:
	   MoveWindow( hwndSBar, 0, HIWORD(lParam)-STATBAR_HEIGHT,  //Position
						//the SB window on the
						//bottom of the parent
	      LOWORD(lParam), STATBAR_HEIGHT, TRUE );
	   break;

	case WM_COMMAND:

	/* The following WM_COMMAND message processing was NOT intended to be
	   nicely written and serves as an example only to show the abilities
	   of the Tool Bar control. */

	   switch( wParam )
	   {
	      case ID_CMD0:
	      case ID_CMD1:
	      case ID_CMD2:
	      case ID_CMD2_5:
	      case ID_CMD3:
	      case ID_CMD4:
	      case ID_CMD5:
	      case ID_CMD6:
	      {
	   /* This simply prints the wParam of the WM_COMMAND message
	      which is equal to the ID number of the pressed TB button
	   */
		 /* Old way: */
		 HDC hdc;
		 char buffer[64];
		 int i;

		 hdc = GetDC( hWnd );
		 wsprintf( buffer,"Message WM_COMMAND, wParam=0x%X (%u), button # %d",
		    wParam, wParam, GetButtonNumber( hwndTBar, wParam ) );
		 TextOut( hdc, 10, 20, buffer, lstrlen( buffer ) );
		 ReleaseDC( hWnd, hdc );

		 /* New way throught Status Bar, look how much simpler
		 it is */
		 PostText( hwndSBar, "Message WM_COMMAND, wParam=0x%X (%u), button # %d",
		    wParam, wParam, GetButtonNumber( hwndTBar, wParam ) );
		 /* PostText is an actual export from ESTOOLS.DLL */

		 /* And now a demonstration of the "Done" control */
		 if( wParam == ID_CMD2 )
		 {
		    DWORD j;
		    for( i=0;i<0x100;i+=5 )
		    {
		       for( j=0;j<100000;j++ );
			  DoneStatus( hwndSBar, SBS_NUMBERS, (DWORD)i, 0x100 );
		    }
		    /* 0x8000 is added to i in order to output the percentage
		       if i is bigger than 0x7FFF then DoneStatus subtracts 0x8000
		       from i and outputs percents. Try to remove 0x8000
		       and see the changes */
		 }
		 break;
	      }
	      case 1100:
	      case 1200:
	      case 1300:
	      case 1400:
	      case 1500:
	      /* Toggle disable/enable button */
	      {
		 int button=(wParam-1100)/100;
		 HMENU hm;
		 hm=GetMenu( hWnd );
		 CheckMenuItem( hm, wParam,
		    (GetMenuState( hm, wParam, MF_BYCOMMAND )&MF_CHECKED)?
		    MF_UNCHECKED:MF_CHECKED );
		 ES_TB_Toggle_Enable_Disable_Demo( hwndTBar, cmds[button] );
		 // This function actually calls SendMessage API which sends
		 // a message to hwndTBar window to change the corresponding
		 // style (explanation and source for these functions is sent to
		 // the registred users only).
		 //
		 // Of course you can try to 'Spy' the messages. But I do
		 // not think the effort would be worth $15. Anyway, you are
		 // not allowed to use it in your programs unless you are
		 // registered.
	      }
	      break;

	      case 1101:
	      case 1201:
	      case 1301:
	      case 1401:
	      case 1501:
	      /* Toggle standard/auto 2 state button */
	      {
		 int button=(wParam-1100)/100;
		 HMENU hm;
		 hm=GetMenu( hWnd );
		 CheckMenuItem( hm, wParam,
		    (GetMenuState( hm, wParam, MF_BYCOMMAND )&MF_CHECKED)?
		    MF_UNCHECKED:MF_CHECKED );
		 ES_TB_Toggle_Standard_Auto2State_Demo( hwndTBar, cmds[button] );
		 // you need to register to get the documentation on this
		 // option. Read the explanation above.
	      }
	      break;

	      case 1102:
	      case 1202:
	      case 1302:
	      case 1402:
	      case 1502:
	      /* Toggle standard/2 state button */
	      {
		 int button=(wParam-1100)/100;
		 HMENU hm;
		 hm=GetMenu( hWnd );
		 CheckMenuItem( hm, wParam,
		    (GetMenuState( hm, wParam, MF_BYCOMMAND )&MF_CHECKED)?
		    MF_UNCHECKED:MF_CHECKED );
		 ES_TB_Toggle_Standard_2State_Demo( hwndTBar, cmds[button] );
		 // you need to register to get the documentation on this
		 // option. Look up there 
		 break;
	      }

	      /* Add a button at run time: */
	      case 1600:
	      {
		 InsertButton( hwndTBar, 0, MF_BYPOSITION, ID_CMD0,
		    LoadBitmap( hInst, MAKEINTRESOURCE(BMP0)) );
		 /* No need to clean up -- TB will delete the bitmaps
		 on exit */
		 EnableMenuItem( GetMenu( hWnd ), 1600, MF_BYCOMMAND | MF_GRAYED );
		 InvalidateRect( hwndTBar, NULL, TRUE );
		 /* It is not going to adjust the window size !!! */
		 break;
	      }
	      case 1601:
		 InsertButton( hwndTBar, ID_CMD3, MF_BYCOMMAND, ID_CMD2_5,
		    LoadBitmap( hInst, MAKEINTRESOURCE( BMP2_5 )) );
		 EnableMenuItem( GetMenu( hWnd ), 1601, MF_BYCOMMAND | MF_GRAYED );
		 InvalidateRect( hwndTBar, NULL, TRUE );
		 /* It is not going to adjust the window size !!! */
		 break;

	      case 1602:
		 InsertButton( hwndTBar, -1, MF_BYPOSITION, ID_CMD6,
		    LoadBitmap( hInst, MAKEINTRESOURCE( BMP6 )) );
		 EnableMenuItem( GetMenu( hWnd ), 1602, MF_BYCOMMAND | MF_GRAYED );
		 InvalidateRect( hwndTBar, NULL, TRUE );
		 /* It is not going to adjust the window size !!! */
		 break;

	      case 2001:
	      case 2002:
	      case 2003:
	      case 2004:
	      case 2005:
	      case 2006:
	      case 2007:
	      case 2008:
	      /*
		 This function calls SendMessage which sends the corresponding
		 message to hwndTBar to set the number of buttons per row.
		 Although you could specify 0 in resource header to get horizontal
		 tool bar, here you have to supply the actual number, 0 does not
		 work - the call will be ignored
	      */
		 ES_TB_Set_Number_of_Controls_Demo( hwndTBar, wParam-2000 ); //Register!
		 ShowWindow( hwndTBar, SW_SHOW );
	      /*
		 Calls to this and following functions will hide the TB from
		 the screen. You need to show the window explicitly. I removed
		 this call to ShowWindow from DLL to give a programmer the
		 possibility to move the window after it's style was changed before
		 the window is displayed. Thus you can override the default
		 positions of window and so on.
	       */
		 break;
	       /*
	      case 2009:
		 I want to point out that there is no example on something
		 like
		 ES_TB_Toggle_Popup_Child_Demo( hwndTBar );
		 It is not because it is undocumented but because it is
		 not implemented. This simply does not work, Windows 3.x
		 cannot convert WS_POPUP to WS_CHILD and back. Or at least I
		 can say I do not know about this possibility. If you want
		 this, you need to destroy the TB with one style and create
		 with another. Or tell me how to make it work.
			I may include an additionla function to the ESTOOLS.DLL
		 to have this work done, but it won't be done throught a SendMessage
		 API but simply by destruction of one window and creation of another.
	      */
	      case 2010:
	      {
		 /* Toggles caption/no caption TB */
		 HMENU hm;
		 hm=GetMenu( hWnd );
		 CheckMenuItem( hm, wParam,
		    (GetMenuState( hm, wParam, MF_BYCOMMAND )&MF_CHECKED)?
		    MF_UNCHECKED:MF_CHECKED );

		 ES_TB_Toggle_Movable_Fixed_Demo( hwndTBar ); //Register!
		 ShowWindow( hwndTBar, SW_SHOW );
		 break;
	      }
	      case 2011:
	      {
                 /* Toggles border/no border TB styles */
		 HMENU hm;
		 hm=GetMenu( hWnd );
		 CheckMenuItem( hm, wParam,
		    (GetMenuState( hm, wParam, MF_BYCOMMAND )&MF_CHECKED)?
                    MF_UNCHECKED:MF_CHECKED );

		 ES_TB_Toggle_BorderStyle_Demo( hwndTBar );   //Register!
		 ShowWindow( hwndTBar, SW_SHOW );
                 break;
	      }
	      case 3000:
		 WinHelp( hWnd, "estools.hlp", HELP_CONTENTS, 0L );
		 break;
		 
	      default:;
	   }
	   break;
	case WM_CLOSE:
	   DestroyWindow(hWnd);
	   break;

	case WM_QUIT:
	case WM_DESTROY:
	   PostQuitMessage(0);
	   break;

	/*
	   The following two message control the style of TB caption
	   It is intended to be active always when the parent is active.
	   It cannot be done without a cooperation from parent's side.
	   It may have some bugs. Try, if you have problems, contact me.
	*/  
	case WM_NCACTIVATE:
	/* The following is required in order to prevent DefWindowProc
	   from redrawing the caption bar of this window in inactive style
	   when tool bar window is activated. Try to remove this and you
	   will see caption bar flashing when you click in TB window.
	   Whenever TB becomes active it passes the active state to it's
	   parent and becomes inactive, to look active it redraws it's caption
	   in the active style.

	   **********************************************************
	   *************LOOK HERE FOR CHANGES FROM v1.1**************
	   **********************************************************
	*/
	   if( (HWND)LOWORD(lParam)==hwndTBar )
	      return DefWindowProc( hWnd, message, TRUE, lParam );

	case WM_ACTIVATEAPP:
	/* This is necessary to draw a title bar of TB in inactive style
	   when the application becomes inactive. TB is never active and cannot
	   process this message by itself. If you remove this part TB will
	   remain looking 'active' even if another application is activated */
	   if( !wParam )
	      SendMessage( hwndTBar, WM_NCACTIVATE, FALSE, 0L );
	   else SendMessage( hwndTBar, WM_NCACTIVATE, TRUE, 0L );
	   //break;  -- DO NOT PUT IT HERE. Documentation states incorrectly that
	   // you can return 0 if you process this message. You cannot, if you
	   // return FALSE you prevent another application from activation.
	   // If you want you may try to return wParam for default processing.
	default:
	   return (DefWindowProc(hWnd, message, wParam, lParam));
   }
   return (NULL);
}

#pragma argsused
/**************************************************************/
int PASCAL WinMain(HINSTANCE hInstance, HINSTANCE hPrevInstance,
			 LPSTR lpCmdLine, int nCmdShow)
{
	MSG msg;		
	if( !hPrevInstance )	
	   if (!InitApplication(hInstance))
		return (FALSE);	

	if (!InitInstance(hInstance, nCmdShow))
	   return (FALSE);

	while( GetMessage( &msg, NULL, NULL, NULL ) )	
	{
		TranslateMessage(&msg);	
		DispatchMessage(&msg);	
	}
	return (msg.wParam);
}


