/*--------------------------------------------------------------------------/
 MorSetup.c

 AppMore Setup, Setup program for AppMore.exe.
 by
 GMP van kempen
 NEVERnever Software 1992

 history:
    1.0     initial release 

/--------------------------------------------------------------------------*/
#define STRICT
#include <windows.h>
#include <windowsx.h>
#include <shellapi.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include "morsetup.h"

/* usefull global things */

HINSTANCE	hInst;	 /* global instance handle */
char		szAppName[] = "AppMore Setup";
char		szSectionName[256];
HWND		hWnd;
HWND		hwndIcon[NUMICONS], hwndScroll, hwndEdit[NUMEDITS], hwndButton[NUMBUTTONS];
HWND		hwndText[NUMEDITS], hwndRadioButton[3], hwndCloseProg, hwndNext[2];
HWND		hwndButtonLook, hwndNoSound;
BOOL		bCurrentIcon[NUMICONS], bSave = FALSE, bSaveButton[MAXAPPS];
BOOL		bNewDir = FALSE;
int		iCurrent = 0, iBlackIcon = 0, iPrevBlackIcon = 0, cxChar, cyChar;
int		MaxIconNumber[MAXAPPS];
FOCUS		nFocus = ICONFOCUS;
HBITMAP 	hAppSetup;
HICON		hIcon[MAXAPPS], hBlank, hIconTemp;
FARPROC 	lpfnOldEdit[NUMEDITS];
APPBARBUTTONS	AppButton[MAXAPPS], AppButtonDefault, AppButtonTemp;
APPSYSTEM	AppSystem, AppSystemNew;
APPSOUND	AppSound, AppSoundNew;
char		Directory[256] = "c:", TempStr[256];
static int	SectionNumber;

/*------------ main window message handler ---------------------------------*/

int PASCAL WinMain(HINSTANCE hInstance, HINSTANCE hPrevInstance, LPSTR lpszCmdLine, int cmdShow)
{
    MSG msg;
    WNDCLASS wc;
    int	yCaption, xSize, ySize;

    lstrcpy(szSectionName, lpszCmdLine);
    AppSystem.SectionNumber = VerifySectionName(szSectionName);

    hInst = hInstance;
    if(!hPrevInstance)
	{
	wc.style	 = CS_HREDRAW | CS_VREDRAW;
	wc.lpfnWndProc	 = MainWndProc;
	wc.cbClsExtra	 = 0;
	wc.cbWndExtra	 = 0;
	wc.hInstance	 = hInstance;
	wc.hCursor	 = LoadCursor(NULL, IDC_ARROW);
	wc.hIcon	 = LoadIcon(hInstance,"Icon");
	wc.hbrBackground = GetStockObject(LTGRAY_BRUSH);
	wc.lpszMenuName	 = NULL;
	wc.lpszClassName = szAppName;

	RegisterClass(&wc);
	}
    else
	{
	OkMsgBox("AppMore Setup","AppMore Setup is already running");
	return TRUE;
	}

    Ctl3dRegister(hInst);
    Ctl3dAutoSubclass(hInst);

    yCaption = GetSystemMetrics(SM_CYCAPTION);
    xSize = 514;
    ySize = 360 + yCaption;

    hWnd = CreateWindow(szAppName, szAppName,
			WS_POPUP | WS_SYSMENU | WS_CAPTION |
			WS_MINIMIZEBOX | WS_VISIBLE,
			50, 50, xSize, ySize,
			(HWND)NULL, (HMENU)NULL, hInstance, (LPSTR)NULL);

    if (!hWnd)
	return TRUE;

    ShowWindow(hWnd, cmdShow);
    UpdateWindow(hWnd);

    hAppSetup = LoadBitmap(hInst, "AppSetup");
    hBlank = LoadIcon(hInst, "Blank");

    while (GetMessage(&msg, NULL, 0, 0))
	{
	TranslateMessage(&msg);
	DispatchMessage(&msg);
	}

    Ctl3dUnregister(hInst);
    return (msg.wParam);
}
    
/*************************************************************************/
long WINAPI MainWndProc(HWND hWnd, UINT message, WPARAM wParam, LPARAM lParam)
    {
    static DLGPROC   lpfnSystemDlgProc, lpfnInitDlgProc, lpfnExitDlgProc;
    static DLGPROC   lpfnSelectDirDlgProc, lpfnSoundDlgProc, lpfnSectionDlgProc;
    LPDRAWITEMSTRUCT lpIconDIS;
    TEXTMETRIC	     tm;
    static HBRUSH    hHighLightBrush, hWhiteBrush;
    HBRUSH	     hbrush;
    HDC 	     hDC;
    RECT	     rc;
    BOOL	     bChanged = FALSE;
    char	     szDropFile[MAXFILECHARS];
    POINT	     DropPoint;
    int 	     i, OffsetFromBlackIcon, iDroppedIcon;


    switch(message) {

    case WM_CREATE:
	InitDefaultButton();
	IniRead();
	SetCaption(hWnd, "AppMore Setup");

	hHighLightBrush = CreateSolidBrush(GetSysColor(COLOR_HIGHLIGHT));
	hWhiteBrush = GetStockBrush(WHITE_BRUSH);

	tm = RetrieveTextMetrics(hWnd);
	cxChar = tm.tmAveCharWidth;
	cyChar = tm.tmHeight;

	for(i=0;i<MAXAPPS;i++)
	     LoadIconFromFile(&hIcon[i], i);

	CreateAllChildWindows(hWnd, hInst);
	for(i=0;i<NUMICONS;i++)
	    bCurrentIcon[i] = FALSE;
	bCurrentIcon[iBlackIcon] = TRUE;
	SetScrollRange(hwndScroll, SB_CTL, 0, MAXAPPS-1, TRUE);
	SetScrollPos(hwndScroll, SB_CTL, 0, TRUE);
	UpdateScrollIcons(iBlackIcon);
	UpdateCheckBoxes(iCurrent);

	if(!AppSystem.Initialized)
	    {
	    lpfnInitDlgProc = (DLGPROC) MakeProcInstance(InitDlgProc, hInst);
	    DialogBox(hInst, "InitDlg", hWnd, lpfnInitDlgProc);
	    FreeProcInstance((FARPROC) lpfnInitDlgProc);
	    AppSystem.Initialized = 1;
	    sprintf(szBuffer,"%d",AppSystem.Initialized);
	    WritePrivateProfileString(INI_APPMORE, INITIALIZED, szBuffer, INI_FILE);
	    }
	DragAcceptFiles(hWnd, TRUE);
	bSave = FALSE;
	if(AppSystem.SectionNumber == 0)
	    SendMessage(hWnd, WM_COMMAND, IDC_BUTTONS+5, 0L);
	break;

    case WM_SYSCOLORCHANGE:
	Ctl3dColorChange();
	break;

    case WM_CTLCOLOR:
	hbrush = Ctl3dCtlColorEx(message, wParam, lParam);
	if(hbrush != (HBRUSH) FALSE)
	    return hbrush;
	else
	    return DefWindowProc(hWnd, message, wParam, lParam);

    case WM_VSCROLL:
	iPrevBlackIcon = iBlackIcon;
	switch(wParam)
	    {
	    case SB_LINEUP:
		iBlackIcon--;
		iCurrent--;
		break;

	    case SB_LINEDOWN:
		iBlackIcon++;
		iCurrent++;
		break;

	    case SB_PAGEUP:
		iCurrent -= NUMICONS;
		break;

	    case SB_PAGEDOWN:
		iCurrent += NUMICONS;
		break;

	    case SB_THUMBTRACK:
		iBlackIcon = LOWORD(lParam) % (MAXAPPS/NUMICONS);
		iCurrent = LOWORD(lParam);
		break;

	    default:
		break;
	    }
	iBlackIcon = max(0, min(iBlackIcon, NUMICONS-1));
	iCurrent = max(0, min(iCurrent, MAXAPPS-1));
	if(iCurrent < NUMICONS)
	    iBlackIcon = iCurrent;
	if(iCurrent > MAXAPPS-1 - NUMICONS)
	    iBlackIcon = NUMICONS-MAXAPPS+iCurrent;
	bCurrentIcon[iPrevBlackIcon] = FALSE;
	bCurrentIcon[iBlackIcon] = TRUE;
	UpdateEditWindows(iCurrent);
	UpdateRadioButtons(AppButton[iCurrent].ShowMode);
	UpdateNextButtons(iCurrent);
	UpdateCheckBoxes(iCurrent);
	if(iCurrent != GetScrollPos(hwndScroll, SB_CTL))
	    {
	    ScrollBar_SetPos(hwndScroll, iCurrent, TRUE);
	    for(i=0;i<NUMICONS;i++)
		InvalidateRect(hwndIcon[i], NULL, TRUE);
	    }
	break;

   case WM_SETFOCUS:
	SetFocus(hwndEdit[nFocus]);
	break;

    case WM_DRAWITEM:
	lpIconDIS = (LPDRAWITEMSTRUCT) lParam;
	OffsetFromBlackIcon = (int) (lpIconDIS->CtlID-IDC_ICONS) - iBlackIcon;
	// Draw an user-specified icon inside of the button
	CopyRect((LPRECT) &rc, &(lpIconDIS->rcItem));
	if(bCurrentIcon[lpIconDIS->CtlID-IDC_ICONS])
	    FillRect(lpIconDIS->hDC, (LPRECT) &rc, hHighLightBrush);
	else
	    FillRect(lpIconDIS->hDC, (LPRECT) &rc, hWhiteBrush);
	if(AppButton[iCurrent+OffsetFromBlackIcon].ButtonLook)
	    DrawIcon(lpIconDIS->hDC, rc.left+19, rc.top+18, hBlank);
	if(hIcon[iCurrent+OffsetFromBlackIcon] != NULL)
	    DrawIcon(lpIconDIS->hDC, rc.left+19, rc.top+18, hIcon[iCurrent+OffsetFromBlackIcon]);
	break;

    case WM_COMMAND:
	switch(wParam)
	    {
	    case IDC_ICONS:
		UpdateScrollIcons(0);
		break;

	    case IDC_ICONS+1:
		UpdateScrollIcons(1);
		break;

	    case IDC_ICONS+2:
		UpdateScrollIcons(2);
		break;

	    case IDC_ICONS+3:
		UpdateScrollIcons(3);
		break;

	    case IDC_ICONS+4:
		UpdateScrollIcons(4);
		break;

	    case IDC_RADIOS:
		UpdateRadioButtons(0);
		break;

	    case IDC_RADIOS+1:
		UpdateRadioButtons(1);
		break;

	    case IDC_RADIOS+2:
		UpdateRadioButtons(2);
		break;

	    case IDC_RADIOS+3:
		UpdateRadioButtons(3);
		break;

	    case IDC_CLOSEPROG:
		bSave = TRUE;
		bSaveButton[iCurrent] = TRUE;
		AppButton[iCurrent].Close = Button_GetCheck(hwndCloseProg);
		break;

	    case IDC_BUTTONLOOK:
		bSave = TRUE;
		bSaveButton[iCurrent] = TRUE;
		if(Button_GetCheck(hwndButtonLook))
		    AppButton[iCurrent].ButtonLook = 1;
		else
		    AppButton[iCurrent].ButtonLook = 0;
		InvalidateRect(hwndIcon[iBlackIcon], NULL, TRUE);
		UpdateWindow(hwndIcon[iBlackIcon]);
		break;

	    case IDC_NEXT:
		if(HIWORD(lParam) == BN_CLICKED)
		    Next(DOWN);
		break;

	    case IDC_NEXT+1:
		if(HIWORD(lParam) == BN_CLICKED)
		    Next(UP);
		break;

	    case IDC_EDITS: /* program edit */
		nFocus = EXEFOCUS;
		if(HIWORD(lParam) == EN_KILLFOCUS)
		    {
		    bSave = TRUE;
		    bSaveButton[iCurrent] = TRUE;
		    Edit_GetText(hwndEdit[0], AppButton[iCurrent].ProgName, MAXFILECHARS-1);
		    Edit_SetText(hwndEdit[0], AppButton[iCurrent].ProgName);
		    LoadExeIcon(&hIcon[iCurrent], iCurrent);
		    nFocus = EXEFOCUS;
		    }
		break;

	    case IDC_EDITS+1: /* parameter edit */
		nFocus = PARAMFOCUS;
		if(HIWORD(lParam) == EN_KILLFOCUS)
		    {
		    bSave = TRUE;
		    bSaveButton[iCurrent] = TRUE;
		    Edit_GetText(hwndEdit[1], AppButton[iCurrent].Params, MAXFILECHARS-1);
		    Edit_SetText(hwndEdit[1], AppButton[iCurrent].Params);
		    }
		break;

	    case IDC_EDITS+2: /* directory edit */
		nFocus = DIRFOCUS;
		if(HIWORD(lParam) == EN_KILLFOCUS)
		    {
		    bSave = TRUE;
		    bSaveButton[iCurrent] = TRUE;
		    Edit_GetText(hwndEdit[2], AppButton[iCurrent].StartDir, MAXFILECHARS-1);
		    Edit_SetText(hwndEdit[2], AppButton[iCurrent].StartDir);
		    }
		break;

	    case IDC_EDITS+3: /* icon edit */
		nFocus = ICONFOCUS;
		if(HIWORD(lParam) == EN_KILLFOCUS)
		    {
		    bSave = TRUE;
		    bSaveButton[iCurrent] = TRUE;
		    Edit_GetText(hwndEdit[3], AppButton[iCurrent].IcoName, MAXFILECHARS-1);
		    Edit_SetText(hwndEdit[3], AppButton[iCurrent].IcoName);
		    DestroyIcon(hIcon[iCurrent]);
		    LoadIconFromFile(&hIcon[iCurrent], iCurrent);
		    InvalidateRect(hwndIcon[iBlackIcon], NULL, TRUE);
		    UpdateNextButtons(iCurrent);
		    }
		break;

	    case IDC_BUTTONS: /* Save */
		if(stricmp(AppSystem.SectionName, "<none>") != 0)
		    {
		    IniSave();
		    bSave = FALSE;
		    }
		break;

	    case IDC_BUTTONS+1:  /* Exit */
		if(bSave)
		    {
		    lpfnExitDlgProc = (DLGPROC) MakeProcInstance(ExitDlgProc, hInst);
		    DialogBox(hInst, "ExitDlg", hWnd, lpfnExitDlgProc);
		    FreeProcInstance((FARPROC) lpfnExitDlgProc);
		    }
		else
		    SendMessage(hWnd, WM_DESTROY, 0, 0);
		break;

	    case IDC_BUTTONS+2:   /* Browse */
		switch(nFocus)
		    {
		    case DIRFOCUS:
			lpfnSelectDirDlgProc = (DLGPROC) MakeProcInstance(SelectDirDlgProc, hInst);
			DialogBox(hInst, "SelectDirDlg", hWnd, lpfnSelectDirDlgProc);
			FreeProcInstance((FARPROC) lpfnSelectDirDlgProc);
			if(bNewDir)
			    {
			    strcpy(AppButton[iCurrent].StartDir, Directory);
			    UpdateEditWindows(iCurrent);
			    bNewDir = FALSE;
			    }
			break;

		    case EXEFOCUS:
			if(BrowseFile(AppButton[iCurrent].ProgName, hWnd, EXEFILES))
			    {
			    UpdateEditWindows(iCurrent);
			    LoadExeIcon(&hIcon[iCurrent], iCurrent);
			    UpdateNextButtons(iCurrent);
			    }
			break;

		    case ICONFOCUS:
			if(BrowseFile(AppButton[iCurrent].IcoName, hWnd, ICONFILES))
			    {
			    DestroyIcon(hIcon[iCurrent]);
			    LoadIconFromFile(&hIcon[iCurrent], iCurrent);
			    InvalidateRect(hwndIcon[iBlackIcon], NULL, FALSE);
			    UpdateNextButtons(iCurrent);
			    UpdateEditWindows(iCurrent);
			    }
			break;
		    }
		break;

	    case IDC_BUTTONS+3: /* system */
		lpfnSystemDlgProc = (DLGPROC) MakeProcInstance(SystemDlgProc, hInst);
		DialogBox(hInst, "SystemDlg", hWnd, lpfnSystemDlgProc);
		FreeProcInstance((FARPROC) lpfnSystemDlgProc);
		break;

	    case IDC_BUTTONS+4: /* sound */
		lpfnSoundDlgProc = (DLGPROC) MakeProcInstance(SoundDlgProc, hInst);
		DialogBox(hInst, "SoundDlg", hWnd, lpfnSoundDlgProc);
		FreeProcInstance((FARPROC) lpfnSoundDlgProc);
		break;

	    case IDC_BUTTONS+5: /* sections */
		lpfnSectionDlgProc = (DLGPROC) MakeProcInstance(SectionDlgProc, hInst);
		DialogBox(hInst, "SectionDlg", hWnd, lpfnSectionDlgProc);
		FreeProcInstance((FARPROC) lpfnSectionDlgProc);
		SetCaption(hWnd, "AppMore Setup");
		break;

	    case IDC_BUTTONS+6: /* help */
		WinHelp(hWnd, "AppMore.hlp",HELP_CONTENTS, 0L);
		break;

	    case IDC_BUTTONS+7: /* insert */
		Insert();
		break;

	    case IDC_BUTTONS+8: /* delete */
		Delete();
		break;

	    case IDC_BUTTONS+9: /* move up */
		MoveUp();
		break;

	    case IDC_BUTTONS+10: /* move down */
		MoveDown();
		break;
	    }
	break;

    case WM_DROPFILES:
	DragQueryPoint((HANDLE) wParam, (LPPOINT) &DropPoint);
	DragQueryFile((HANDLE) wParam, 0, szDropFile, sizeof(szDropFile));
	if(DropPoint.x < 100)
	    {
	    // file dropped over icon scrollbar
	    iDroppedIcon = 0;
	    while((iDroppedIcon*68+78) <= DropPoint.y)
		{
		iDroppedIcon++;
		if(iDroppedIcon > 100)
		    break;
		}
	    iDroppedIcon += (iCurrent-iBlackIcon);
	    strcpy(AppButton[iDroppedIcon].IcoName, szDropFile);
	    LoadIconFromFile(&hIcon[iDroppedIcon],iDroppedIcon);
	    if(iDroppedIcon == iCurrent)
		UpdateScrollIcons(iBlackIcon);
	    else
		{
		iDroppedIcon -= (iCurrent-iBlackIcon);
		InvalidateRect(hwndIcon[iDroppedIcon], NULL, TRUE);
		UpdateWindow(hwndIcon[iDroppedIcon]);
		}
	    }
	else
	    if(DropPoint.x < 400)
		{
		// file dropped over edit windows
		iDroppedIcon = 0;
		while((iDroppedIcon*60+90) <= DropPoint.y)
		    {
		    iDroppedIcon++;
		    if(iDroppedIcon > 10)
			break;
		    }
		if(iDroppedIcon == 0) // program editwindow
		    {
		    strcpy(AppButton[iCurrent].ProgName, szDropFile);
		    Edit_SetText(hwndEdit[0], AppButton[iCurrent].ProgName);
		    LoadExeIcon(&hIcon[iCurrent], iCurrent);
		    InvalidateRect(hwndIcon[iBlackIcon], NULL, TRUE);
		    UpdateWindow(hwndIcon[iDroppedIcon]);
		    }
		if(iDroppedIcon == 1) // params editwindow
		    {
		    strcpy(AppButton[iCurrent].Params, szDropFile);
		    Edit_SetText(hwndEdit[1], AppButton[iCurrent].Params);
		    }
		if(iDroppedIcon == 2) // working directory editwindow
		    {
		    strcpy(AppButton[iCurrent].StartDir, szDropFile);
		    Edit_SetText(hwndEdit[2], AppButton[iCurrent].StartDir);
		    }
		if(iDroppedIcon == 3) // icon editwindow
		    {
		    strcpy(AppButton[iCurrent].IcoName, szDropFile);
		    Edit_SetText(hwndEdit[3], AppButton[iCurrent].IcoName);
		    DestroyIcon(hIcon[iCurrent]);
		    LoadIconFromFile(&hIcon[iCurrent], iCurrent);
		    InvalidateRect(hwndIcon[iBlackIcon], NULL, TRUE);
		    UpdateNextButtons(iCurrent);
		    }
		}
	DragFinish((HANDLE) wParam);
	break;

    case WM_DESTROY:
	DragAcceptFiles(hWnd, FALSE);
	DeleteBrush(hHighLightBrush);
	DeleteBitmap(hAppSetup);
        PostQuitMessage(0);
        break;

    default:
        return DefWindowProc(hWnd, message, wParam, lParam);
        break;
    }
    return NULL;
    }
