#define STRICT
#include <windows.h>
#include <windowsx.h>
#include <shellapi.h>
#include <stdio.h>
#include "morsetup.h"

#define MAKECHILD(a,b,c,d,e,f,g,h) CreateWindow(a,b,WS_CHILD | WS_VISIBLE | c,d,e,f,g,hWnd,h,hInst,(LPSTR) NULL)
#define MAKEBUTTON(a,b,c,d,e,f)    MAKECHILD("button",a,BS_PUSHBUTTON,b,c,d,e,f)
#define MAKECHECKBOX(a,b,c,d,e,f)  MAKECHILD("button",a,BS_AUTOCHECKBOX,b,c,d,e,f)
#define MAKERADIO(a,b,c,d,e,f)	   MAKECHILD("button",a,BS_RADIOBUTTON,b,c,d,e,f)
#define MAKETEXT(a,b,c,d,e,f)	   MAKECHILD("static",a,SS_LEFT,b,c,d,e,f)
#define MAKESTATIC(a,b,c,d)	   MAKECHILD("static",NULL,SS_BLACKRECT,a,b,c,d,(HMENU)-1)
#define MAKEBORDER(a,b,c,d)	   MAKECHILD("static",NULL,SS_WHITERECT,a,b,c,d,(HMENU) -1)
#define MAKEICON(a,b,c,d,e)	   MAKECHILD("button",NULL,BS_OWNERDRAW,a,b,c,d,e)
#define MAKEEDIT(a,b,c,d,e,f)	   CreateWindow("edit", "  ", WS_CHILD | WS_VISIBLE | WS_BORDER | ES_LEFT | ES_AUTOHSCROLL | a,b,c,d,e,hWnd,f,hInst,(LPSTR) NULL)

/*--------------------------------------------------------------------------*/
VOID UpdateEditWindows(int iCurrent)
    {
    char IcoString[32];

    sprintf(IcoString,"Program %d",iCurrent+1);
    Static_SetText(hwndText[0], IcoString);
    Edit_SetText(hwndEdit[0], AppButton[iCurrent].ProgName);

    sprintf(IcoString,"Parameters %d",iCurrent+1);
    Static_SetText(hwndText[1], IcoString);
    Edit_SetText(hwndEdit[1], AppButton[iCurrent].Params);

    sprintf(IcoString,"Working Directory %d",iCurrent+1);
    Static_SetText(hwndText[2], IcoString);
    Edit_SetText(hwndEdit[2], AppButton[iCurrent].StartDir);

    sprintf(IcoString,"Icon %d",iCurrent+1);
    Static_SetText(hwndText[3], IcoString);
    Edit_SetText(hwndEdit[3], AppButton[iCurrent].IcoName);
    }

/*--------------------------------------------------------------------------*/
VOID UpdateRadioButtons(int iCurrentRB)
    {
    int i;

    bSave = TRUE;
    bSaveButton[iCurrent] = TRUE;
    AppButton[iCurrent].ShowMode = iCurrentRB;
    for(i=0;i<4;i++)
	{
	if(i != iCurrentRB)
	    Button_SetCheck(hwndRadioButton[i], 0);
	else
	    Button_SetCheck(hwndRadioButton[i], 1);
	}
    }

/*--------------------------------------------------------------------------*/
VOID UpdateCheckBoxes(int iCurrent)
    {
    Button_SetCheck(hwndButtonLook, AppButton[iCurrent].ButtonLook);
    Button_SetCheck(hwndCloseProg, AppButton[iCurrent].Close);
    Button_SetCheck(hwndNoSound, AppButton[iCurrent].NoSound);
    }


/*-------------------------------------------------------------------------*/
VOID UpdateScrollIcons(int iCurrentIcon)
    {
    int i;

    iPrevBlackIcon = iBlackIcon;
    iBlackIcon = iCurrentIcon;
    iCurrent -= (iPrevBlackIcon-iCurrentIcon);
    bCurrentIcon[iPrevBlackIcon] = FALSE;
    bCurrentIcon[iBlackIcon] = TRUE;
    UpdateEditWindows(iCurrent);
    UpdateRadioButtons(AppButton[iCurrent].ShowMode);
    UpdateNextButtons(iCurrent);
    UpdateCheckBoxes(iCurrent);
    ScrollBar_SetPos(hwndScroll, iCurrent, TRUE);
    for(i=0;i<NUMICONS;i++)
	{
	InvalidateRect(hwndIcon[i], NULL, TRUE);
	UpdateWindow(hwndIcon[i]);
	}
    }

/*--------------------------------------------------------------------------*/
VOID UpdateNextButtons(int iCur)
{
    if(AppButton[iCur].IconNumber <= 0)
	Button_Enable(hwndNext[0], FALSE);
    else
	Button_Enable(hwndNext[0], TRUE);
    if(AppButton[iCur].IconNumber >= MaxIconNumber[iCur]-1)
	Button_Enable(hwndNext[1], FALSE);
    else
	Button_Enable(hwndNext[1], TRUE);
}

/*--------------------------------------------------------------------------
VOID CreateAllChildWindows(HWND hWnd, HINSTANCE hInst)
    {
    int i;
    POINT EditWindowPoint[4];
    char *Button[10] ={"Save","Exit","Browse","System","Sound","Sections",
		      "Insert","Delete","Move Up","Move Down"};
    char *Next[2] = {"<< "," >>"};
    char *RadioButton[4] = {"Normal","Maximized","Minimized","Maximum size"};

    EditWindowPoint[0].x = 110;
    EditWindowPoint[0].y = 32;
    EditWindowPoint[1].x = 110;
    EditWindowPoint[1].y = 90;
    EditWindowPoint[2].x = 110;
    EditWindowPoint[2].y = 148;
    EditWindowPoint[3].x = 110;
    EditWindowPoint[3].y = 206;

    // create windows for the icon buttons
    for(i=0;i<NUMICONS;i++)
	{
	hwndIcon[i] = CreateWindow("button",
			      NULL,
                              WS_CHILD | WS_VISIBLE | BS_OWNERDRAW,
			      10, 10+68*i,
			      70, 68,
			      hWnd,
			      IDC_ICONS+i,
                              hInst,
			      (LPSTR)NULL);
	}

    // create windows for the push buttons
    for(i=0;i<6;i++)
	hwndButton[i] = CreateWindow("button",
			      Button[i],
			      WS_CHILD | WS_VISIBLE | BS_PUSHBUTTON,
			      409, 10+i*26, 90, 24,
			      hWnd,
			      IDC_BUTTONS+i,
                              hInst,
			      (LPSTR)NULL);
    for(i=6;i<NUMBUTTONS;i++)
	hwndButton[i] = CreateWindow("button",
			      Button[i],
			      WS_CHILD | WS_VISIBLE | BS_PUSHBUTTON,
			      409, 24+i*26, 90, 24,
			      hWnd,
			      IDC_BUTTONS+i,
                              hInst,
			      (LPSTR)NULL);
    // create windows for the next push buttons beneath "icon"editwindow
    for(i=0;i<2;i++)
	hwndNext[i] = CreateWindow("button",
			      Next[i],
			      WS_CHILD | WS_VISIBLE | BS_PUSHBUTTON,
			      EditWindowPoint[3].x+i*40,
			      EditWindowPoint[3].y+27,
			      40, 18,
			      hWnd,
			      IDC_NEXT+i,
                              hInst,
			      (LPSTR)NULL);

    // create windows for buttonlook option checkbox
    hwndButtonLook = CreateWindow("button",
			      "Buttonlook",
			      WS_CHILD | WS_VISIBLE | BS_AUTOCHECKBOX,
			      260, 264, 120, 20,
			      hWnd,
			      IDC_BUTTONLOOK,
			      hInst,
			      (LPSTR)NULL);

    // create windows for the showmode radiobuttons
    for(i=0;i<4;i++)
	hwndRadioButton[i] = CreateWindow("button",
			      RadioButton[i],
			      WS_CHILD | WS_VISIBLE | BS_RADIOBUTTON,
			      115, 264+i*20, 120, 18,
			      hWnd,
			      IDC_RADIOS+i,
                              hInst,
			      (LPSTR)NULL);

    // create windows for close option checkbox
    hwndCloseProg = CreateWindow("button",
			      "Close Program",
			      WS_CHILD | WS_VISIBLE | BS_AUTOCHECKBOX,
			      260, 284, 120, 20,
			      hWnd,
			      IDC_CLOSEPROG,
                              hInst,
			      (LPSTR)NULL);

    // create edit textwindows
    for(i=0;i<NUMEDITS;i++)
	{
	if(i != 1)
	    hwndEdit[i] = CreateWindow("edit",
			      "  ",
			      WS_CHILD | WS_VISIBLE | WS_BORDER |
			      ES_LEFT | ES_LOWERCASE | ES_AUTOHSCROLL,
			      EditWindowPoint[i].x, EditWindowPoint[i].y,
			      280, 28,
			      hWnd,
			      IDC_EDITS+i,
                              hInst,
			      (LPSTR)NULL);
	if(i == 1)
	    hwndEdit[i] = CreateWindow("edit",
			      " ",
			      WS_CHILD | WS_VISIBLE | WS_BORDER |
			      ES_LEFT | ES_AUTOHSCROLL,
			      EditWindowPoint[i].x, EditWindowPoint[i].y,
			      280, 28,
			      hWnd,
			      IDC_EDITS+i,
                              hInst,
			      (LPSTR)NULL);

	Edit_LimitText(hwndEdit[i], MAXFILECHARS-1);
	lpfnOldEdit[i] = (FARPROC) GetWindowLong(hwndEdit[i], GWL_WNDPROC);
	SetWindowLong(hwndEdit[i], GWL_WNDPROC,
		  (LONG) MakeProcInstance( (FARPROC) EditProc,
		  (HINSTANCE) GetWindowWord(hWnd, GWW_HINSTANCE)));

	// create static text windows
	hwndText[i] = CreateWindow("static",
			      "    ",
			      WS_CHILD | WS_VISIBLE | SS_LEFT,
			      EditWindowPoint[i].x, EditWindowPoint[i].y-21,
			      140, 20,
			      hWnd,
			      IDC_TEXTS+i,
                              hInst,
			      (LPSTR)NULL);
	}

    // create scrollbar next to the iconbuttons
    hwndScroll = CreateWindow("scrollbar", NULL,
			      WS_CHILD | WS_VISIBLE | SBS_VERT,
			      80, 9, 20, 342,
			      hWnd,
			      IDC_SCROLL,
			      hInst,
			      (LPSTR)NULL);
    }  */
/*--------------------------------------------------------------------------*/
VOID CreateAllChildWindows(HWND hWnd, HINSTANCE hInst)
    {
    int i;
    char *Button[NUMBUTTONS] ={"Save","Exit","Browse","System","Sound","Sections",
		      "Help","Insert","Delete","Move Up","Move Down"};
    char *Next[2] = {"<< "," >>"};
    char *RadioButton[4] = {"Normal","Maximized","Minimized","Maximum size"};

    // create static frame around Icons+scroll and editwindows
    Ctl3dSubclassCtl(MAKEBORDER(0, 0, 512, 359));
    Ctl3dSubclassCtl(MAKESTATIC(9, 9, 388, 342));

    // create static frame around buttons
    Ctl3dSubclassCtl(MAKESTATIC(406, 9, 98, 342));

    // create static frame around checkboxes and radiobuttons
    Ctl3dSubclassCtl(MAKESTATIC(110, 260, 280, 86));

    // create windows for the icon buttons
    for(i=0;i<NUMICONS;i++)
	hwndIcon[i] = MAKEICON(10, 10+68*i, 70, 68, IDC_ICONS+i);

    // create windows for the push buttons
    for(i=0;i<7;i++)
	hwndButton[i] = MAKEBUTTON(Button[i], 410, 14+i*26, 90, 24,
				   IDC_BUTTONS+i);

    for(i=7;i<NUMBUTTONS;i++)
	hwndButton[i] = MAKEBUTTON(Button[i], 410, 28+i*26, 90, 24,
			      IDC_BUTTONS+i);

    // create windows for the next push buttons beneath "icon"editwindow
    for(i=0;i<2;i++)
	hwndNext[i] = MAKEBUTTON(Next[i], 110+i*40, 60+(NUMEDITS-1)*58,
				 40, 18, IDC_NEXT+i);

    // create windows for buttonlook option checkbox
    hwndButtonLook = MAKECHECKBOX("Buttonlook", 260, 264, 120, 20,
				  IDC_BUTTONLOOK);
    Ctl3dSubclassCtl(hwndButtonLook);

    // create windows for no sound option checkbox
    hwndNoSound = MAKECHECKBOX("No Sound", 260, 304, 120, 20,
			      IDC_NOSOUND);
    Ctl3dSubclassCtl(hwndNoSound);

    // create windows for close option checkbox
    hwndCloseProg = MAKECHECKBOX("Close Program", 260, 284, 120, 20,
			      IDC_CLOSEPROG);
    Ctl3dSubclassCtl(hwndCloseProg);

    // create windows for the showmode radiobuttons
    for(i=0;i<4;i++)
	{
	hwndRadioButton[i] = MAKERADIO(RadioButton[i], 115, 264+i*20, 130, 18,
			      IDC_RADIOS+i);
	Ctl3dSubclassCtl(hwndRadioButton[i]);
	}

    // create edit textwindows
    for(i=0;i<NUMEDITS;i++)
	{
	if(i != 1)
	    hwndEdit[i] = MAKEEDIT(ES_LOWERCASE, 110, 32+i*58, 280, 28,
				   IDC_EDITS+i);
	if(i == 1)
	    hwndEdit[i] = MAKEEDIT(0, 110, 32+i*58, 280, 28, IDC_EDITS+i);

	Ctl3dSubclassCtl(hwndEdit[i]);
	Edit_LimitText(hwndEdit[i], MAXFILECHARS-1);
	lpfnOldEdit[i] = (FARPROC) GetWindowLong(hwndEdit[i], GWL_WNDPROC);
	SetWindowLong(hwndEdit[i], GWL_WNDPROC,
		  (LONG) MakeProcInstance( (FARPROC) EditProc,
		  (HINSTANCE) GetWindowWord(hWnd, GWW_HINSTANCE)));

	// create static text windows
	hwndText[i] = MAKETEXT("   ", 110, 11+i*58, 140, 20, IDC_TEXTS+i);
	}

    // create scrollbar next to the iconbuttons
    hwndScroll = MAKECHILD("scrollbar", NULL, SBS_VERT, 80, 10, 20, 340,
			   IDC_SCROLL);
    }

/*--------------------------------------------------------------------------*/
VOID Insert(VOID)
    {
    int i;
    for(i=MAXAPPS-1;i>iCurrent;i--)
	{
	AppButton[i] = AppButton[i-1];
	hIcon[i] = hIcon[i-1];
	if(hIcon[i] != NULL)
	    bSaveButton[i] = TRUE;
	}
    AppButton[iCurrent] = AppButtonDefault;
    hIcon[iCurrent] = NULL;
    UpdateScrollIcons(iBlackIcon);
    bSave = TRUE;
    }

/*-------------------------------------------------------------------------*/
VOID Delete(VOID)
    {
    int i;

    for(i=iCurrent;i<MAXAPPS-1;i++)
	{
	AppButton[i] = AppButton[i+1];
	if(hIcon[i] != NULL)
	    bSaveButton[i] = TRUE;
	hIcon[i] = hIcon[i+1];
	}
    AppButton[MAXAPPS-1] = AppButtonDefault;
    hIcon[MAXAPPS-1] = NULL;
    UpdateScrollIcons(iBlackIcon);
    bSave = TRUE;
    }

/*--------------------------------------------------------------------------*/
VOID MoveUp(VOID)
    {
    if(iCurrent > 0)
	{
	AppButtonTemp = AppButton[iCurrent-1];
	AppButton[iCurrent-1] = AppButton[iCurrent];
	AppButton[iCurrent] = AppButtonTemp;
	hIconTemp = hIcon[iCurrent-1];
	hIcon[iCurrent-1] = hIcon[iCurrent];
	hIcon[iCurrent] = hIconTemp;
	bSaveButton[iCurrent-1] = TRUE;
	bSaveButton[iCurrent] = TRUE;
	bSave = TRUE;
	iCurrent--;
	iBlackIcon--;
	iBlackIcon = max(0, min(iBlackIcon, NUMICONS-1));
	bCurrentIcon[iPrevBlackIcon] = FALSE;
	bCurrentIcon[iBlackIcon+1] = FALSE;
	UpdateScrollIcons(iBlackIcon);
	}
    }

/*--------------------------------------------------------------------------*/
VOID MoveDown(VOID)
    {
    if(iCurrent < MAXAPPS-1)
	{
	AppButtonTemp = AppButton[iCurrent];
	AppButton[iCurrent] = AppButton[iCurrent+1];
	AppButton[iCurrent+1] = AppButtonTemp;
	hIconTemp = hIcon[iCurrent];
	hIcon[iCurrent] = hIcon[iCurrent+1];
	hIcon[iCurrent+1] = hIconTemp;
	bSaveButton[iCurrent+1] = TRUE;
	bSaveButton[iCurrent] = TRUE;
	bSave = TRUE;
	iCurrent++;
	iBlackIcon++;
	iBlackIcon = max(0, min(iBlackIcon, NUMICONS-1));
	bCurrentIcon[iPrevBlackIcon] = FALSE;
	bCurrentIcon[iBlackIcon-1] = FALSE;
	UpdateScrollIcons(iBlackIcon);
	}
    }

/*--------------------------------------------------------------------------*/
VOID Next(int i)
    {
    bSave = TRUE;
    bSaveButton[iCurrent] = TRUE;
    if(i == DOWN)
	{
	AppButton[iCurrent].IconNumber--;
	AppButton[iCurrent].IconNumber = max(0, AppButton[iCurrent].IconNumber);
	}
    if(i == UP)
	{
	AppButton[iCurrent].IconNumber++;
	AppButton[iCurrent].IconNumber = min(MaxIconNumber[iCurrent]-1, AppButton[iCurrent].IconNumber);
	}
    DestroyIcon(hIcon[iCurrent]);
    hIcon[iCurrent] = ExtractIcon(hInst, AppButton[iCurrent].IcoName, AppButton[iCurrent].IconNumber);
    if(hIcon[iCurrent] == (HICON) 1)
	hIcon[iCurrent] = NULL;
    InvalidateRect(hwndIcon[iBlackIcon], NULL, FALSE);
    UpdateWindow(hwndIcon[iBlackIcon]);
    UpdateNextButtons(iCurrent);
    }
