#define STRICT
#include <windows.h>
#include <windowsx.h>
#include <commdlg.h>
#include <cderr.h>
#include <string.h>
#include <io.h>
#include <stdarg.h>
#include <stdio.h>
#include "morsetup.h"

// !!!!! Don't forget to link commdlg.dll !!!!!

BOOL PASCAL BrowseFile(char *FileName, HWND hWndCommDlgParent, BROWSEFILES FileType)
    {
    OPENFILENAME ofn;
    char szDirName[256];
    char szFile[256], szFileTitle[256]; /* file and title arrays */
    char *szWaveFilter[] = {
    "Sound Files (*.wav)",
    "*.wav",
    ""
    };
char *szIcoFilter[] = {
    "Icon Resource Files",
    "*.ico;*.exe;*.dll",
    "All Files",
    "*.*",
    ""
    };
char *szExeFilter[] = {
    "Executable Files",
    "*.exe;*.com;*.pif",
    "All Files"
    "*.*",
    ""
    };

    /* Initialize the OPENFILENAME members */
    GetWindowsDirectory((LPSTR)szDirName, 255);

    szFile[0] = '\0';
    ofn.lStructSize = sizeof(OPENFILENAME);
    ofn.hwndOwner = hWndCommDlgParent;
    if(FileType == ICONFILES)
	{
	ofn.lpstrFilter = szIcoFilter[0];
	ofn.lpstrTitle = (LPSTR) "AppBar Setup - Browse IconFiles";
	ofn.lpstrInitialDir = AppSystem.DefaultIconDir;
	}
    if(FileType == EXEFILES)
	{
	ofn.lpstrFilter = szExeFilter[0];
	ofn.lpstrTitle = (LPSTR) "AppBar Setup - Browse Executable Files";
	ofn.lpstrInitialDir = szDirName;
	}
    if(FileType == WAVEFILES)
	{
	ofn.lpstrFilter = szWaveFilter[0];
	ofn.lpstrTitle = (LPSTR) "AppBar Setup - Browse SoundFiles";
	ofn.lpstrInitialDir = AppSound.SoundDirectory;
	}
    ofn.lpstrCustomFilter = (LPSTR) NULL;
    ofn.nMaxCustFilter = 0L;
    ofn.nFilterIndex = 1L;
    ofn.lpstrFile= szFile;
    ofn.nMaxFile = sizeof(szFile);
    ofn.lpstrFileTitle = szFileTitle;
    ofn.nMaxFileTitle = sizeof(szFileTitle);
    ofn.Flags = OFN_PATHMUSTEXIST | OFN_FILEMUSTEXIST;
    ofn.nFileOffset = 0;
    ofn.nFileExtension = 0;
    ofn.lpstrDefExt = (LPSTR) NULL;

    /* Call the GetOpenFilename function */
    if(GetOpenFileName(&ofn))
	{
	strcpy(FileName, (char *) ofn.lpstrFile);
	return TRUE;
	}
    else
	{
	FileErrorHandler();
	return FALSE;
	}
    }

/*--------------------------------------------------------------------------*/
/* FUNCTION: SelectDirDlgProc() 					    */
/*									    */
/* PURPOSE:  Processes Select Directory Dialog Box Messages		    */
/*--------------------------------------------------------------------------*/
BOOL WINAPI SelectDirDlgProc(HWND hDlg, UINT message, WPARAM wParam, LPARAM lParam)
    {
    static BOOL ListBoxFocus = FALSE;

    switch(message)
        {
	case WM_INITDIALOG:
            strcpy(TempStr, Directory);
            UpdateListBox(hDlg);
	    SetFocus(GetDlgItem(hDlg, IDDIR_LIST));
            return FALSE;
	    break;

	case WM_COMMAND:
            switch(wParam)
                {
		case IDDIR_LIST:
                    switch(HIWORD(lParam))
                        {
                        case LBN_SETFOCUS:
                            ListBoxFocus = TRUE;
			    SendDlgItemMessage(hDlg, IDDIR_LIST, LB_SETCURSEL,
                              GetListBoxIndex(hDlg), 0L);
                            return TRUE;

                        case LBN_KILLFOCUS:
                            ListBoxFocus = FALSE;
			    SendDlgItemMessage(hDlg, IDDIR_LIST, LB_SETCURSEL,
                              -1, 0L);
                            return TRUE;

                        case LBN_DBLCLK:
DoubleClick:		    DlgDirSelect(hDlg, TempStr, IDDIR_LIST);
                            UpdateListBox(hDlg);
                            return (TRUE);
                            break;

			} /* end IDDIR_LIST switch */
                    break;

		case IDDIR_OK:
                    if(ListBoxFocus)
                        goto DoubleClick;

		    GetDlgItemText(hDlg, IDDIR_PATH, Directory, sizeof(Directory));
		    bNewDir = TRUE;
		    EndDialog(hDlg,TRUE);
		    return (TRUE);
                    break;

		case IDDIR_CANCEL:
		    EndDialog(hDlg,FALSE);
		    bNewDir = FALSE;
                    return (TRUE);
                    break;

                default:
                    return (FALSE);
                } /* end WM_COMMAND SWITCH */
        default:
            return (FALSE);
        }
    }

/*--------------------------------------------------------------------------*/
/* FUNCTION: UpdateListBox(HWND hDlg)					    */
/*									    */
/* PURPOSE:  Helper function for dialog window proc			    */
/*--------------------------------------------------------------------------*/
void UpdateListBox(HWND hDlg)
    {
    SetDlgItemText(hDlg, IDDIR_PATH, TempStr);
    DlgDirList(hDlg, TempStr, IDDIR_LIST, IDDIR_PATH, DDL_DIRECTORY | DDL_DRIVES | DDL_EXCLUSIVE);
    SendDlgItemMessage(hDlg, IDDIR_LIST, LB_SETCURSEL,
      GetListBoxIndex(hDlg), 0L);
    InvalidateRect(hDlg, NULL, TRUE);
    UpdateWindow(hDlg);
    }

/*--------------------------------------------------------------------------*/
/* FUNCTION: GetListBoxIndex(HWND hDlg) 				    */
/*									    */
/* PURPOSE:  Helper function for dialog window proc			    */
/*--------------------------------------------------------------------------*/
UINT GetListBoxIndex(HWND hDlg)
    {
    WORD rtn;

    rtn = (UINT) SendDlgItemMessage(hDlg, IDDIR_LIST, LB_GETCURSEL, 0, 0L);
    if(rtn == LB_ERR)
        return 0;
    else
        return rtn;
    }

/*--------------------------------------------------------------------------*/
void FileErrorHandler(void)
    {
    BOOL bDisplayError = TRUE;

    switch(CommDlgExtendedError())
	{
	case CDERR_FINDRESFAILURE:
	    strcpy(szBuffer,"Common dialog box function failed to\n find specified resource.");
	    break;

	case CDERR_INITIALIZATION:
	    strcpy(szBuffer,"Common dialog box function\n failed during initialization.");
	    break;

	case CDERR_LOCKRESFAILURE:
	    strcpy(szBuffer,"Common dialog box function failed to\nlock a specified resource.");
	    break;

	case CDERR_LOADRESFAILURE:
	    strcpy(szBuffer,"Common dialog box function failed to\nload a specified resource.");
	    break;

	case CDERR_LOADSTRFAILURE:
	    strcpy(szBuffer,"Common dialog box function failed to\nload a specified string.");
	    break;

	case CDERR_MEMALLOCFAILURE:
	    strcpy(szBuffer,"Common dialog box function was unable to\nallocate memory for internal datastructures.");
	    break;

	case CDERR_MEMLOCKFAILURE:
	    strcpy(szBuffer,"Common dialog box function was unable to\nlock the memory associated with a handle.");
	    break;

	case CDERR_NOHINSTANCE:
	    strcpy(szBuffer,"ENABLETEMPLATE flag was set in the Flags member\nof the common dialog box but\nthat the application failed to provide a corresponding instance handle.");
	    break;

	case CDERR_NOHOOK:
	    strcpy(szBuffer,"ENABLEHOOK flag was set in the Flags member\nof the common dialog box but that\nthe application failed to provide a pointer to a corresponding hook function.");
	    break;

	case CDERR_NOTEMPLATE:
	    strcpy(szBuffer,"ENABLETEMPLATE flag was set in the Flags member\nof the common dialog box but that\nthe application failed to provide a corresponding template.");
	    break;

	case CDERR_REGISTERMSGFAIL:
	    strcpy(szBuffer, "RegisterWindowMessage function returned\nan error value forthe common dialog box function.");
	    break;

	case CDERR_STRUCTSIZE:
	    strcpy(szBuffer, "Invalid lStructSize of the common dialog box.");
	    break;

	case FNERR_BUFFERTOOSMALL:
	    strcpy(szBuffer, "Buffer to which the lpstrFile of\nthe common dialog box function points is too small.");
	    break;

	case FNERR_INVALIDFILENAME:
	    strcpy(szBuffer, "Invalid filename.");
	    break;

	case FNERR_SUBCLASSFAILURE:
	    strcpy(szBuffer, "An attempt to subclass a list box\nfailed due to insufficient memory.");
	    break;

	case FRERR_BUFFERLENGTHZERO:
	    strcpy(szBuffer, "A member in a data structure for\nthe common dialog box points to an invalid buffer.");
	    break;

	default:
	    bDisplayError = FALSE;
	    break;
	}
    if(bDisplayError)
	OkMsgBox("AppSetup - Browse", "Common dialog error:\n%s", szBuffer);
    }
