#define STRICT
#include <windows.h>
#include <windowsx.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include "apptask.h"

/*-------------------------------------------------------------------------*/
BOOL WINAPI SetupDlgProc(HWND hDlg, UINT message, WPARAM wParam, LPARAM lParam)
    {
    OFSTRUCT	of;
    BOOL bAlreadyTaskMan = FALSE;

    switch(message)
	{
	case WM_INITDIALOG:
	    GetPrivateProfileString("boot", "taskman.exe", "  ", szBuffer, 255, "system.ini");
	    if(strstr(AnsiLower(szBuffer),"apptask.exe"))
		{
		bAlreadyTaskMan = TRUE;
		CheckDlgButton(hDlg, IDS_REPLACE, TRUE);
		}
	    else
		bAlreadyTaskMan = FALSE;
	    if(ShowAll)
		CheckDlgButton(hDlg, IDS_ALL, TRUE);
	    if(CloseDeAct)
		CheckDlgButton(hDlg, IDS_DEACT, TRUE);
	    CheckRadioButton(hDlg, IDS_CLOSE, IDS_QUIT, IDS_CLOSE+CloseMode);
	    return TRUE;

	case WM_COMMAND:
	    switch(wParam)
		{
		case IDS_REPLACE:
		    CheckDlgButton(hDlg, IDS_REPLACE, !IsDlgButtonChecked(hDlg, IDS_REPLACE));
		    return TRUE;

		case IDS_ALL:
		    CheckDlgButton(hDlg, IDS_ALL, !IsDlgButtonChecked(hDlg, IDS_ALL));
		    return TRUE;

		case IDS_DEACT:
		    CheckDlgButton(hDlg, IDS_DEACT, !IsDlgButtonChecked(hDlg, IDS_DEACT));
		    return TRUE;

		case IDS_CLOSE:
		    CloseMode = 0;
		    CheckRadioButton(hDlg, IDS_CLOSE, IDS_QUIT, IDS_CLOSE);
		    return TRUE;

		case IDS_DESTROY:
		    CloseMode = 1;
		    CheckRadioButton(hDlg, IDS_CLOSE, IDS_QUIT, IDS_DESTROY);
		    return TRUE;

		case IDS_QUIT:
		    CloseMode = 2;
		    CheckRadioButton(hDlg, IDS_CLOSE, IDS_QUIT, IDS_QUIT);
		    return TRUE;

		case IDS_OK:
		    /* save Replace setting */
		    if(IsDlgButtonChecked(hDlg, IDS_REPLACE) && !bAlreadyTaskMan)
			{
			if(OpenFile("apptask.exe", &of, OF_EXIST | OF_SEARCH) != -1)
			    {
			    strcpy(szBuffer, of.szPathName);
			    }
			else
			    {
			    strcpy(szBuffer, "apptask.exe");
			    }
			WritePrivateProfileString("boot", "taskman.exe", szBuffer, "system.ini");
			}
		    if(!IsDlgButtonChecked(hDlg, IDS_REPLACE) && bAlreadyTaskMan)
			WritePrivateProfileString("boot", "taskman.exe", "taskman.exe", "system.ini");

		    /* save ShowAll setting */
		    if(IsDlgButtonChecked(hDlg, IDS_ALL))
			ShowAll = 1;
		    else
			ShowAll = 0;
		    sprintf(szBuffer, "%d", ShowAll);
		    WritePrivateProfileString("AppTask", "ShowAll", szBuffer, "AppTools.ini");

		    /* save Close Deactivated setting */
		    if(IsDlgButtonChecked(hDlg, IDS_DEACT))
			CloseDeAct = 1;
		    else
			CloseDeAct = 0;
		    sprintf(szBuffer, "%d", CloseDeAct);
		    WritePrivateProfileString("AppTask", "CloseDeAct", szBuffer, "AppTools.ini");

		    /* save CloseMode setting */
		    sprintf(szBuffer, "%d", CloseMode);
		    WritePrivateProfileString("AppTask", "CloseMode", szBuffer, "AppTools.ini");

		    EndDialog(hDlg, 0);
		    return TRUE;

		case IDS_HELP:
		    WinHelp(hWndAppTask, "AppTools.hlp", HELP_CONTENTS, 0L);
		    return TRUE;

		case IDS_CANCEL:
		    EndDialog(hDlg, 0);
		    return TRUE;
		}
	    break;
	}
    return FALSE;
    }
