#define STRICT
#include <windows.h>
#include <windowsx.h>
#include <ctype.h>
#include <string.h>
#include <stdio.h>
#include <io.h>
#include <stdarg.h>
#include <stdio.h>
#include <direct.h>
#include "appfindr.h"

extern char *TempStr, *Directory;

/*----------------------------------------------------------------------------*/
/* FUNCTION: AppDlgProc(HWND, unsigned, WORD, LONG)                           */
/*                                                                            */
/* PURPOSE:  Processes Dialog Box Messages                                    */
/*----------------------------------------------------------------------------*/
BOOL WINAPI AppDlgProc(HWND hDlg, UINT message, WPARAM wParam, LPARAM lParam)
    {
    static BOOL ListBoxFocus = FALSE;

    switch(message)
        {
        case WM_INITDIALOG:
            strcpy(TempStr, Directory);
            UpdateListBox(hDlg);
            SetFocus(GetDlgItem(hDlg, IDC_LISTBOX));
	    return TRUE;
            break;

        case WM_COMMAND:
            switch(wParam)
                {
                case IDC_LISTBOX:
                    switch(HIWORD(lParam))
                        {
                        case LBN_SETFOCUS:
                            ListBoxFocus = TRUE;
                            SendDlgItemMessage(hDlg, IDC_LISTBOX, LB_SETCURSEL,
                              GetListBoxIndex(hDlg), 0L);
                            return TRUE;

                        case LBN_KILLFOCUS:
                            ListBoxFocus = FALSE;
                            SendDlgItemMessage(hDlg, IDC_LISTBOX, LB_SETCURSEL,
                              -1, 0L);
                            return TRUE;

                        case LBN_DBLCLK:
DoubleClick:                DlgDirSelect(hDlg, TempStr, IDC_LISTBOX);
                            UpdateListBox(hDlg);
                            return (TRUE);
                            break;

                        } /* end IDC_LISTBOX switch */
                    break;

                case IDOK:
                    if(ListBoxFocus)
                        goto DoubleClick;

                    GetDlgItemText(hDlg, IDC_PATH, Directory, sizeof(Directory));
		    EndDialog(hDlg,TRUE);
		    return (TRUE);
                    break;

                case IDCANCEL:
                    EndDialog(hDlg,FALSE);
                    return (TRUE);
                    break;

                default:
                    return (FALSE);
                } /* end WM_COMMAND SWITCH */
        default:
            return (FALSE);
        }
    }

/*----------------------------------------------------------------------------*/
/* FUNCTION: UpdateListBox(HWND hDlg)                                         */
/*                                                                            */
/* PURPOSE:  Helper function for dialog window proc                           */
/*----------------------------------------------------------------------------*/
void UpdateListBox(HWND hDlg)
    {
    SetDlgItemText(hDlg, IDC_PATH, TempStr);
    DlgDirList(hDlg, TempStr, IDC_LISTBOX, IDC_PATH, 0xC000);
    SendDlgItemMessage(hDlg, IDC_LISTBOX, LB_SETCURSEL,
      GetListBoxIndex(hDlg), 0L);
    }

/*----------------------------------------------------------------------------*/
/* FUNCTION: GetListBoxIndex(HWND hDlg)                                       */
/*                                                                            */
/* PURPOSE:  Helper function for dialog window proc                           */
/*----------------------------------------------------------------------------*/
WORD GetListBoxIndex(HWND hDlg)
    {
    WORD rtn;

    rtn = (WORD)SendDlgItemMessage(hDlg, IDC_LISTBOX, LB_GETCURSEL, 0, 0L);
    if(rtn == LB_ERR)
        return 0;
    else
        return rtn;
    }
