/* appbar.h */

#include <mmsystem.h>

#define WM_APPBAR_RESTART   (WM_USER+1001)
#define WM_APPBAR_CLOSE	    (WM_USER+1002)
#define PM_TIP_SETICON	    (WM_USER+1100)

#define ID_TIMER	  100

#define SYSTEM_BUTTON	  0

#define ID_CLOSE	400
#define ID_ABOUT	401
#define ID_MOVE		402
#define ID_OK		403
#define ID_CANCEL	404
#define ID_SETUP	405
#define ID_RESTART	406
#define ID_QUICKLOAD	407
#define ID_RUN		408
#define ID_MINIMIZE	409
#define ID_HELP		410
#define ID_INFRONT	411

#define IDEXITW_YES	500
#define IDEXITW_NO	501
#define IDEXITW_RESTART	502

#define IDRUN_PROGRAM	600
#define IDRUN_CANCEL	601
#define IDRUN_OK	602
#define IDRUN_BROWSE	603

#define IDMOVE_YES	700
#define IDMOVE_NO	701

#define IDASK_PARAMS	800
#define IDASK_CANCEL	801
#define IDASK_OK	802

#define ID_BUTTON1	1000

#define INI_SYSTEM	"System"
#define INI_BUTTON	"Buttons"
#define INI_SOUND	"Sounds"
#define INI_FILE	"appbar.ini"

#define LEFT		"Left"
#define TOP		"Top"
#define COLUMNS		"Columns"
#define BUTTONS 	"Buttons"
#define CLOSEALL	"CloseAll"
#define STAYINFRONT	"StayInFront"
#define INITIALIZED	"Initialized"
#define BIGBUTTONS	"BigButtons"
#define DOUBLECLICK	"DoubleClick"
#define BORDER		"Border"

#define SOUNDENABLE	"EnableSound"
#define APPSTART	"AppBarStart"
#define APPEXIT 	"AppBarExit"
#define WINEXIT 	"WindowsExit"
#define PROGSTART	"ProgramStart"
#define PROGCLOSE	"ProgramClose"
#define DROPFILE	"DropFile"
#define ERRORMESSAGE	"ErrorMessage"

#define LEFT_DEFAULT	    "-1"
#define TOP_DEFAULT	    "-1"
#define COLUMNS_DEFAULT	    "1"
#define BUTTONS_DEFAULT     "8"
#define CLOSEALL_DEFAULT    "1"
#define NOSOUND_DEFAULT     "0"
#define CLOSEPROG_DEFAULT   "1"
#define SHOWMODE_DEFAULT    "0"
#define STAYINFRONT_DEFAULT "0"
#define INITIALIZED_DEFAULT "0"
#define ICONNUMBER_DEFAULT  "0"
#define BUTTONLOOK_DEFAULT  "0"
#define BIGBUTTONS_DEFAULT  "0"
#define DOUBLECLICK_DEFAULT "0"
#define BORDER_DEFAULT	    "0"

#define SOUNDENABLE_DEFAULT	"0"
#define APPSTART_DEFAULT	"<none>"
#define APPEXIT_DEFAULT		"<none>"
#define WINEXIT_DEFAULT		"<none>"
#define PROGSTART_DEFAULT	"<none>"
#define PROGCLOSE_DEFAULT	"<none>"
#define DROPFILE_DEFAULT	"<none>"
#define ERRORMESSAGE_DEFAULT	"<none>"

#define MAXFILECHARS	81 //DOS sets max of file to 80 chars
#define MAXDIGITS	5
#define NUMICONS	4
#define NUMEDITS	3
#define MAXBUTTONS	49
#define MAXAPPS 	(MAXBUTTONS-1)
#define MAXRES		1280
#define MAXBORDER	15

#define APPBARVERSION	400
#define APPBAR4		400

typedef struct {
       int	nColumns;
       int	nButtons;
       int	cxButton;
       int	cyButton;
       } APPWINDOW;

typedef enum {NOTALIVE = FALSE, ALIVE = TRUE} STATUS;

typedef struct {
	char	IcoName[MAXFILECHARS];
	char	ProgName[MAXFILECHARS];
	char	StartDir[MAXFILECHARS];
	char	Params[MAXFILECHARS];
	HWND	hWndApp;
	int	IconNumber;
	BOOL	ButtonLook;
	STATUS	ProgStatus;
	BOOL	Close;
	short	ShowMode;
	BOOL	NoSound;
	} APPBARBUTTONS;

typedef struct {
	short	Left;
	short	Top;
	int	Columns;
	int	Buttons;
	BOOL	CloseAll;
	BOOL	StayInFront;
	int	Initialized;
	BOOL	BigButtons;
	BOOL	DoubleClick;
	int	Border;
	char	DefaultIconDir[MAXFILECHARS];
	char	ShellGroup[8*MAXFILECHARS];
	} APPSYSTEM;

typedef struct {
	BOOL	EnableSound;
	char	AppBarStart[MAXFILECHARS];
	char	AppBarExit[MAXFILECHARS];
	char	WindowsExit[MAXFILECHARS];
	char	ProgramStart[MAXFILECHARS];
	char	ProgramClose[MAXFILECHARS];
	char	DropFile[MAXFILECHARS];
	char	ErrorMessage[MAXFILECHARS];
	char	SoundDirectory[MAXFILECHARS];
	} APPSOUND;

typedef struct {
	int left;
	int top;
	int width;
	int height;
	} APPMAXSIZE;

char szBuffer[256];
int temp;

#define WITHIN(val, min, max)	  (((temp=val) > max ? max : (temp < min) ? min : temp))
#define ONEORZERO(val)		  WITHIN((BOOL)val, 0, 1)

extern APPBARBUTTONS	AppButton[MAXAPPS], AppEmptyButton;
extern APPSYSTEM	AppSystem;
extern APPWINDOW	AppWindow;
extern APPSOUND 	AppSound;
extern APPMAXSIZE	AppMaxSize;
extern HWND		hWndMain, hWndCurrentButton, hWndButton[MAXBUTTONS];
extern HINSTANCE	hInst;
extern HBITMAP		hAppLogo, hNNever;
extern HBITMAP		hbPressed, hbBlank, hbKeyb;
extern HICON		hSystem, hBlank, hPressed, hQuickLoad;
extern HICON		hRun, hKeybOn, hPressed2, hSystem2;
extern int		iCurrent, iKey, iActive, cxChar, cyChar, FirstAppButton;
extern char		szError[256];
extern BOOL		bQuickLoad, bMoveButton;
extern BOOL		bKeyboardOn, bExecuteProg, bShuffleButton;


/* defined in AppBar.c */
extern	int  PASCAL WinMain(HINSTANCE hInstance, HINSTANCE hPrevInstance, LPSTR lpszCmdLine, int nCmdShow);
extern	long WINAPI WndProc(HWND hWnd, UINT message, WPARAM wParam, LPARAM lParam);

/* defined in AppTools.c*/
extern VOID OkMsgBox(char *szCaption, char *szFormat, ...);
extern VOID ErrorMsgBox(char *szCaption, char *szFormat, ...);
extern VOID PASCAL IniRead(VOID);
extern APPMAXSIZE CalculateAppMaxSize(VOID);
extern VOID SetNormalChildCursor(VOID);
extern VOID SetShuffleChildCursor(VOID);
extern void InitTip(void);
extern BOOL IsAppTip(int AppNumber);
extern void LoadAllButtonIcons(HICON *hIcon);
extern void TipSetIcon(WORD iIcon, HICON *hIcon);
extern void LoadAppBarResources(void);
extern void FreeAppBarResources(void);
extern BOOL IsAppBarShell(VOID);

/* defined in AppClose.c */
//long WINAPI WaitForWMCloseWndProc(HWND hWnd, UINT message, WPARAM wParam, LPARAM lParam);
//VOID PASCAL WaitForWMClose(HWND hWndClose);
//BOOL PASCAL CloseApp(HWND hWndClose);

/* defined in AppDlgs.c */
extern BOOL WINAPI AboutDlgProc(HWND hWnd, UINT message, WPARAM wParam, LPARAM lParam);
extern BOOL WINAPI SystemDlgProc(HWND hWnd, UINT message, WPARAM wParam, LPARAM lParam);
extern BOOL WINAPI ExitWDlgProc(HWND hWnd, UINT message, WPARAM wParam, LPARAM lParam);
extern BOOL WINAPI AskDlgProc(HWND hDlg, UINT message, WPARAM wParam, LPARAM lParam);

/* defined in AppExec.c */
extern BOOL PASCAL ProgExec(HWND hWndParent, LPSTR lpszFile, LPSTR lpszParams, LPSTR lpszDir, int nCmdShow);
extern VOID PASCAL StartOrCloseProgram(int,UINT);
extern VOID DoShellTasks(VOID);
extern VOID PASCAL CheckProgStatus(VOID);
extern int AskForParameters(char *szParams);

/* defined in AppDraw.c */
extern void DrawItem(LPDRAWITEMSTRUCT lpIconDIS, HICON *hIcon);

/* defined in AppGrp.c */
extern BOOL ExecGroupFile(char *szGroupFileName);
extern BOOL ReadGroupFile(LPSTR lpszGroupFileName, PHANDLE ghMemGroupFileData);

/* defined in AppKeyb.c */
extern int KeyboardInterface(int Key);
extern int ProcessSystemKeys(int SysKey);

/* defined in AppDrop.c */
extern VOID ProcessDropFiles(HANDLE hDrop, HICON *hIcon);

/* Undocumented Windows function in taskman.exe (PCM/FEB92) */
extern BOOL WINAPI IsWinOldApTask(HTASK);

#define IsDosWindow(hWnd)   IsWinOldApTask(GetWindowTask(hWnd))

/*defined in AppBar.dll */
extern TEXTMETRIC WINAPI RetrieveTextMetrics(HWND hWnd);
extern void WINAPI DrawBitmap(HDC hDC, short x, short y, HBITMAP hBitmap);
extern APPSYSTEM  WINAPI ReadSystemIni(VOID);
extern APPSOUND   WINAPI ReadSoundIni(VOID);
extern APPBARBUTTONS WINAPI ReadButtonIni(int i, LPSTR SectionName, LPSTR IniFile);
extern VOID WINAPI SaveButtonIni(APPBARBUTTONS AppButton, int i, LPSTR SectionName, LPSTR IniFile);
extern APPBARBUTTONS WINAPI InitButton(VOID);
extern VOID WINAPI ExecuteErrorHandle(int iError, char *szError);
extern BOOL WINAPI CloseApp(HWND hWndClose, HINSTANCE hInst);
