#define STRICT
#include <windows.h>
#include <windowsx.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include "appsetup.h"

/*--------------------------------------------------------------------------*/
/* FUNCTION: IniRead(void)						    */
/*									    */
/* PURPOSE:  Read settings in the appbar.ini file.			    */
/*--------------------------------------------------------------------------*/
VOID PASCAL IniRead(VOID)
    {
    int i;

    SetCursor(LoadCursor(NULL, IDC_WAIT));
    // get ini-settings for AppSystem struct.
    strcpy(AppSystem.DefaultIconDir, " ");
    AppSystem = ReadSystemIni();
    if(AppSystem.Border < 3)
	AppSystem.Border = 0;

    // get ini-settings for AppSound struct.
    AppSound = ReadSoundIni();

    // get ini-settings for AppButton struct.
    for(i=0;i<MAXAPPS;i++)
	AppButton[i] = ReadButtonIni(i, (LPSTR) INI_BUTTON, (LPSTR) INI_FILE);

    AppButtonDefault = InitButton();

    // update appbar.ini from earlier version than AppBar 4.0
    if(AppSystem.Initialized < APPBAR4)
	{
	GetPrivateProfileString(INI_SYSTEM, SHELLGROUP, SHELLGROUP_DEFAULT,
			   AppSystem.ShellGroup, 4*MAXFILECHARS-1, INI_FILE);
	WritePrivateProfileString(INI_SHELL, SHELLGROUP, AppSystem.ShellGroup, INI_FILE);
	//WritePrivateProfileString(INI_SYSTEM, SHELLGROUP, "not used anymore, see [Shell] section", INI_FILE);
	}

    SetCursor(LoadCursor(NULL, IDC_ARROW));
    }

/*--------------------------------------------------------------------------*/
/* FUNCTION: IniSave(void)						    */
/*									    */
/* PURPOSE:  Saves settings to the appbar.ini file.			    */
/*--------------------------------------------------------------------------*/
VOID PASCAL IniSave(VOID)
    {
    int i;

    SetCursor(LoadCursor(NULL, IDC_WAIT));
    // Save ini-settings from AppButton struct.
    for(i=0;i<MAXAPPS;i++)
	SaveButtonIni(AppButton[i], i, (LPSTR) INI_BUTTON, (LPSTR) INI_FILE);

    // Save ini-settings from AppSystem struct.
    SaveSystemIni(AppSystem);

    // Save AppSound settings.
    SaveSoundIni(AppSound);

    SetCursor(LoadCursor(NULL, IDC_ARROW));
    }
