//compile with the strictest error checking
#define STRICT
#include <windows.h>
#include <windowsx.h>
#include <string.h>
#include <stdio.h>
#include "appprint.h"


static char GlobalPrinterName[STRING_SIZE];

int SelectPrinterDialog(HINSTANCE hInstance, HWND hWndParent, char *PrinterName)
{
	DLGPROC lpfnDialogProc;
	int ReturnValue;

	/* Display dialog box. */
	lpfnDialogProc=(DLGPROC)MakeProcInstance(
		(FARPROC)SelectPrinterDialogProc,hInstance);
	ReturnValue=DialogBox(hInstance,"SelectPrinterDialog",hWndParent,
		lpfnDialogProc);
	FreeProcInstance((FARPROC)lpfnDialogProc);
	
	/* If dialog has successfully ended, copy the printer name form
	the static global variable to the parameter variable. */
	if(ReturnValue==0)
	{
		strncpy(PrinterName,GlobalPrinterName,STRING_SIZE-1);
		PrinterName[STRING_SIZE-1]='\0';
	}

	/* return. On succes the return value is 0. */
	return ReturnValue;
}




BOOL CALLBACK SelectPrinterDialogProc(HWND hwnd,UINT message,WPARAM wParam, 
	LPARAM lParam)
{
	char Message[STRING_SIZE];
	static char AllPrinterNames[ALL_PRINT_NAME_SIZE];
	static char *PrinterNameTable[PRINT_NAME_TAB_SIZE];
	char PrinterDescription[STRING_SIZE];
	char *PrinterName,*PrinterDriver,*PrinterPort;
	char ListEntry[STRING_SIZE];
	char DriverFile[STRING_SIZE];
	int i,j;

	LRESULT CurSel;
	HINSTANCE hLibrary;
	typedef void (WINAPI *DRIVERPROC)(HWND hwnd, HINSTANCE hLibrary,
		LPSTR szPrinterName, LPSTR szPrinterPort);
	DRIVERPROC lpfnDriverProc;
	
	switch(message)
	{

	    /* Initialisation. */
	    case WM_INITDIALOG:
	    
	    	/* Get list containing the names of all available printers. */
	    	GetProfileString("devices",0,"",AllPrinterNames,
	    		ALL_PRINT_NAME_SIZE-1);
	    		
	    	/* Fill the table AllPrinterNames with the names of the
	    	printers. AllPrinterNames will be terminated with a NULL. */
	    	for(i=0,j=0;AllPrinterNames[j]!='\0' && 
	    		i<PRINT_NAME_TAB_SIZE;i++,j++)
	    	{
			PrinterNameTable[i]=AllPrinterNames+j;
			while(AllPrinterNames[j]!='\0')j++;
	    	}
	    	PrinterNameTable[i]=NULL;
	    	
	    	
		for(i=0;PrinterNameTable[i]!=NULL;i++)
		{
			/* Get the port name of each printer. If it
			is not possiple to get the port name of the
			printer, remove the printer from the list. */
			GetProfileString("devices",PrinterNameTable[i],",,",
				PrinterDescription,STRING_SIZE);
			if( (PrinterDriver=strtok(PrinterDescription,", "))
				==NULL || (PrinterPort=strtok(NULL,", "))
				==NULL )
			{
				for(j=i;PrinterNameTable[j+1]!=NULL;
					j++)PrinterNameTable[j]=
					PrinterNameTable[j+1];
				PrinterNameTable[j]=NULL;
				i--;
				continue;
			}

			/* The complete text for a printer in the list
			box is "PrinterName on PrinterPort". */
			strncpy(ListEntry,PrinterNameTable[i],STRING_SIZE-1);
			ListEntry[STRING_SIZE-1]='\0';
			strncat(ListEntry," on ",STRING_SIZE-	
				strlen(ListEntry)-1);
			strncat(ListEntry,PrinterPort,STRING_SIZE-	
				strlen(ListEntry)-1);

			/* If the printer port is "none", remove the printer
			from the list. */
			for(j=0;PrinterPort[j]!='\0';j++)if
				('A'<=PrinterPort[j] &&
				PrinterPort[j]<='Z')
				PrinterPort[j]+='a'-'A';
			if(strcmp(PrinterPort,"none")==0)
			{
				for(j=i;PrinterNameTable[j+1]!=NULL;
					j++)PrinterNameTable[j]=
					PrinterNameTable[j+1];
				PrinterNameTable[j]=NULL;
				i--;
				continue;
			}
			
			/* Add printer to the list box. */
		 	SendDlgItemMessage(hwnd,IDD_LISTBOX_PRINTERS,
				LB_INSERTSTRING,i,
				(LONG)(char far *)ListEntry);
		}

		/* Get the name of the default printer. */
		GetProfileString("windows","device",",,,",PrinterDescription,
			STRING_SIZE);
		if( (PrinterName=strtok(PrinterDescription,","))==NULL )
		{
			SendDlgItemMessage(hwnd,IDD_LISTBOX_PRINTERS,
				LB_SETCURSEL,0,0L);
			    	return TRUE;
		}
		
		/* Find the default printer in the list of printer. If
		found, select this printer in the list box.*/
		for(i=0;PrinterNameTable[i]!=NULL;i++)
		{
			if(strcmp(PrinterNameTable[i],PrinterName)==0)
			{
				SendDlgItemMessage(hwnd,IDD_LISTBOX_PRINTERS,
				LB_SETCURSEL,i,0L);
				return TRUE;
			}
		}

		/* If there is no default printer, the first printer in
		the list is selected. */
		SendDlgItemMessage(hwnd,IDD_LISTBOX_PRINTERS,LB_SETCURSEL,
			0,0L);

	    	return TRUE;

	    case WM_COMMAND:

		switch(wParam)
		{

		    /* The OK button is pressed. */
		    case IDD_BUTTON_OK:
		    
		        /* Get the ordinal number of the currently selected
		        printer. */
			CurSel=SendDlgItemMessage(hwnd,IDD_LISTBOX_PRINTERS,
				LB_GETCURSEL,0,0L);
		    	if(CurSel==LB_ERR)return TRUE;
		    	
		    	/* Copy the name of the currently selected printer
		    	into a global variable. */
	    		strncpy(GlobalPrinterName,PrinterNameTable[CurSel],
				STRING_SIZE-1);
			GlobalPrinterName[STRING_SIZE-1]='\0';
	    		
	    		/* terminate the dialog. */
	    		EndDialog(hwnd,0);
	    		
			return TRUE;

		    /* The cancel button is pressed, or the close option
		    from the system menu is selected. */
		    case IDD_BUTTON_CANCEL:
		    case IDCANCEL:

			/* Terminate the dialog. */
			EndDialog(hwnd,1);
			
			return TRUE;

		    /* The setup button is pressed. */
		    case IDD_BUTTON_SETUP:

		        /* Get the ordinal number of the currently selected
		        printer. */
		    	CurSel=SendDlgItemMessage(hwnd,
		    		IDD_LISTBOX_PRINTERS,LB_GETCURSEL,0,0);
		    	if(CurSel==LB_ERR)return TRUE;

			/* Get the driver file of the selected printer,
			and the port it is connected to. */
			GetProfileString("devices",PrinterNameTable[CurSel],",,",
				PrinterDescription,STRING_SIZE);
			if( (PrinterDriver=strtok(PrinterDescription,", "))
				==NULL || (PrinterPort=strtok(NULL,", "))
				==NULL )
			{
				sprintf(Message,
					"%s: this printer is not properly installed.",
					PrinterNameTable[CurSel]);
				MessageBox(hwnd,Message,"Printer Setup",
					MB_ICONEXCLAMATION|MB_OK);
			}
			strncpy(DriverFile,PrinterDriver,STRING_SIZE-1);
			DriverFile[STRING_SIZE-1]='\0';
			strncat(DriverFile,".drv",STRING_SIZE-
				strlen(DriverFile)-1);

			/* Start the DEVICEMODE procedure from the
			driver file. */
			hLibrary=LoadLibrary(DriverFile);
			if((unsigned int)hLibrary<32)
			{
				sprintf(Message,
					"%s\nThis driver file is invalid.",
					DriverFile);
				MessageBox(hwnd,Message,"Printer Setup",
					MB_OK|MB_ICONEXCLAMATION);
			}
			else
			{
				lpfnDriverProc=(DRIVERPROC)
					GetProcAddress(hLibrary,"DEVICEMODE");
				(*lpfnDriverProc)(hwnd,hLibrary,
					(LPSTR)PrinterNameTable[CurSel],
					(LPSTR)PrinterPort);
				FreeLibrary(hLibrary);
			}
			
			return TRUE;
			
	   	    case IDD_LISTBOX_PRINTERS:

			switch(HIWORD(lParam))
			{
			
			    /* A printer in the select box is double 
			    clicked on. */
			    case LBN_DBLCLK:
			    
			        /* Get the ordinal number of the currently 
			        selected printer. */
			    	CurSel=SendDlgItemMessage(hwnd,
				       IDD_LISTBOX_PRINTERS,LB_GETCURSEL,0,0);
			    	if(CurSel==LB_ERR)return TRUE;
			    	
			    	/* Copy the name of the selected printer
			    	to a global variable. */
		    		strncpy(GlobalPrinterName,
		    			PrinterNameTable[CurSel],
		    			STRING_SIZE-1);
				GlobalPrinterName[STRING_SIZE-1]='\0';
		    			
		    		/* Terminate the dialog. */
				EndDialog(hwnd,0);
			    	return TRUE;
			    	
			}
			break;
		}
		break;
	}
	return FALSE;

}
       
